/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.FundingMonitor;
import nxt.account.HoldingType;
import nxt.ae.Asset;
import nxt.blockchain.Chain;
import nxt.blockchain.FxtChain;
import nxt.crypto.Crypto;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.ms.Currency;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class StartFundingMonitor
extends APIServlet.APIRequestHandler {
    static final StartFundingMonitor instance = new StartFundingMonitor();

    private StartFundingMonitor() {
        super(new APITag[]{APITag.ACCOUNTS}, "holdingType", "holding", "property", "amount", "threshold", "interval", "secretPhrase", "feeRateNQTPerFXT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Object object;
        Object object2;
        Chain chain = ParameterParser.getChain(httpServletRequest);
        HoldingType holdingType = ParameterParser.getHoldingType(httpServletRequest);
        long l = ParameterParser.getHoldingId(httpServletRequest);
        String string = ParameterParser.getAccountProperty(httpServletRequest, true);
        long l2 = ParameterParser.getLong(httpServletRequest, "amount", 0L, Long.MAX_VALUE, true);
        if (l2 < 1L) {
            return JSONResponses.incorrect("amount", "Minimum funding amount is 1");
        }
        long l3 = ParameterParser.getLong(httpServletRequest, "threshold", 0L, Long.MAX_VALUE, true);
        if (l3 < 1L) {
            return JSONResponses.incorrect("threshold", "Minimum funding threshold is 1");
        }
        int n = ParameterParser.getInt(httpServletRequest, "interval", 10, Integer.MAX_VALUE, true);
        long l4 = ParameterParser.getLong(httpServletRequest, "feeRateNQTPerFXT", 0L, 100000000000000000L, true);
        String string2 = ParameterParser.getSecretPhrase(httpServletRequest, true);
        switch (holdingType) {
            case ASSET: {
                if (chain == FxtChain.FXT) {
                    return JSONResponses.INCORRECT_CHAIN;
                }
                object2 = Asset.getAsset(l);
                if (object2 != null) break;
                return JSONResponses.UNKNOWN_ASSET;
            }
            case CURRENCY: {
                if (chain == FxtChain.FXT) {
                    return JSONResponses.INCORRECT_CHAIN;
                }
                object = Currency.getCurrency(l);
                if (object != null) break;
                return JSONResponses.UNKNOWN_CURRENCY;
            }
            case COIN: {
                if (l == (long)chain.getId()) break;
                return JSONResponses.INCORRECT_CHAIN;
            }
        }
        object2 = Account.getAccount(Crypto.getPublicKey(string2));
        if (object2 == null) {
            return JSONResponses.UNKNOWN_ACCOUNT;
        }
        if (((Account)object2).getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            return JSONResponses.error("Accounts under phasing only control cannot run a funding monitor");
        }
        object = FundingMonitor.startMonitor(chain, holdingType, l, string, l2, l3, n, string2, l4);
        if (object != null) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"started", (Object)true);
            jSONObject.put((Object)"monitor", (Object)JSONData.accountMonitor((FundingMonitor)object, false, false));
            return jSONObject;
        }
        return JSONResponses.MONITOR_ALREADY_STARTED;
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }
}

