/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Chain;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.messaging.PrunableEncryptedMessageAppendix;
import nxt.messaging.PrunablePlainMessageAppendix;
import nxt.util.JSON;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class VerifyPrunableMessage
extends APIServlet.APIRequestHandler {
    static final VerifyPrunableMessage instance = new VerifyPrunableMessage();
    private static final JSONStreamAware NO_SUCH_PLAIN_MESSAGE;
    private static final JSONStreamAware NO_SUCH_ENCRYPTED_MESSAGE;

    private VerifyPrunableMessage() {
        super(new APITag[]{APITag.MESSAGES}, "transactionFullHash", "message", "messageIsText", "messageToEncryptIsText", "encryptedMessageData", "encryptedMessageNonce", "compressMessageToEncrypt");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "transactionFullHash", true);
        Chain chain = ParameterParser.getChain(httpServletRequest);
        Transaction transaction = Nxt.getBlockchain().getTransaction(chain, byArray);
        if (transaction == null) {
            return JSONResponses.UNKNOWN_TRANSACTION;
        }
        PrunablePlainMessageAppendix prunablePlainMessageAppendix = (PrunablePlainMessageAppendix)ParameterParser.getPlainMessage(httpServletRequest, true);
        PrunableEncryptedMessageAppendix prunableEncryptedMessageAppendix = (PrunableEncryptedMessageAppendix)ParameterParser.getEncryptedMessage(httpServletRequest, null, true);
        if (prunablePlainMessageAppendix == null && prunableEncryptedMessageAppendix == null) {
            return JSONResponses.MISSING_MESSAGE_ENCRYPTED_MESSAGE;
        }
        if (prunablePlainMessageAppendix != null && prunableEncryptedMessageAppendix != null) {
            return JSONResponses.EITHER_MESSAGE_ENCRYPTED_MESSAGE;
        }
        if (prunablePlainMessageAppendix != null) {
            PrunablePlainMessageAppendix prunablePlainMessageAppendix2 = transaction.getPrunablePlainMessage();
            if (prunablePlainMessageAppendix2 == null) {
                return NO_SUCH_PLAIN_MESSAGE;
            }
            if (!Arrays.equals(prunablePlainMessageAppendix2.getHash(), prunablePlainMessageAppendix.getHash())) {
                return JSONResponses.HASHES_MISMATCH;
            }
            JSONObject jSONObject = prunablePlainMessageAppendix2.getJSONObject();
            jSONObject.put((Object)"verify", (Object)true);
            return jSONObject;
        }
        if (prunableEncryptedMessageAppendix != null) {
            PrunableEncryptedMessageAppendix prunableEncryptedMessageAppendix2 = transaction.getPrunableEncryptedMessage();
            if (prunableEncryptedMessageAppendix2 == null) {
                return NO_SUCH_ENCRYPTED_MESSAGE;
            }
            if (!Arrays.equals(prunableEncryptedMessageAppendix2.getHash(), prunableEncryptedMessageAppendix.getHash())) {
                return JSONResponses.HASHES_MISMATCH;
            }
            JSONObject jSONObject = prunableEncryptedMessageAppendix2.getJSONObject();
            jSONObject.put((Object)"verify", (Object)true);
            return jSONObject;
        }
        return JSON.emptyJSON;
    }

    static {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"errorCode", (Object)5);
        jSONObject.put((Object)"errorDescription", (Object)"This transaction has no plain message attachment");
        NO_SUCH_PLAIN_MESSAGE = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put((Object)"errorCode", (Object)5);
        jSONObject.put((Object)"errorDescription", (Object)"This transaction has no encrypted message attachment");
        NO_SUCH_ENCRYPTED_MESSAGE = JSON.prepare(jSONObject);
    }
}

