/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.taggeddata.TaggedDataAttachment;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class VerifyTaggedData
extends APIServlet.APIRequestHandler {
    static final VerifyTaggedData instance = new VerifyTaggedData();

    private VerifyTaggedData() {
        super("file", new APITag[]{APITag.DATA}, "transactionFullHash", "name", "description", "tags", "type", "channel", "isText", "filename", "data");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "transactionFullHash", true);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        Transaction transaction = Nxt.getBlockchain().getTransaction(childChain, byArray);
        if (transaction == null) {
            return JSONResponses.UNKNOWN_TRANSACTION;
        }
        TaggedDataAttachment taggedDataAttachment = ParameterParser.getTaggedData(httpServletRequest);
        Attachment attachment = transaction.getAttachment();
        if (!(attachment instanceof TaggedDataAttachment)) {
            return JSONResponses.INCORRECT_TRANSACTION;
        }
        TaggedDataAttachment taggedDataAttachment2 = (TaggedDataAttachment)attachment;
        if (!Arrays.equals(taggedDataAttachment2.getHash(), taggedDataAttachment.getHash())) {
            return JSONResponses.HASHES_MISMATCH;
        }
        JSONObject jSONObject = taggedDataAttachment2.getJSONObject();
        jSONObject.put((Object)"verify", (Object)true);
        return jSONObject;
    }
}

