/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.responses;

import nxt.addons.ContractRunnerConfig;
import nxt.addons.JO;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.TransactionType;
import nxt.http.responses.TransactionResponseImpl;
import org.json.simple.JSONObject;

public interface TransactionResponse {
    public static TransactionResponse create(Object object) {
        if (object instanceof JSONObject) {
            return new TransactionResponseImpl((JSONObject)object);
        }
        return new TransactionResponseImpl((JO)object);
    }

    public TransactionType getTransactionType();

    public int getChainId();

    public long getSenderId();

    public String getSender();

    public String getSenderRs();

    public byte[] getSenderPublicKey();

    public long getRecipientId();

    public String getRecipient();

    public String getRecipientRs();

    public int getHeight();

    public long getBlockId();

    public short getIndex();

    public int getTimestamp();

    public int getBlockTimestamp();

    public short getDeadline();

    public int getExpiration();

    public long getAmount();

    public long getFee();

    public byte[] getSignature();

    public byte[] getFullHash();

    public byte getType();

    public byte getSubType();

    public byte getVersion();

    public int getECBlockHeight();

    public long getECBlockId();

    public boolean isPhased();

    public long getFxtTransaction();

    public long getTransactionId();

    public String getUnsignedLongTransactionId();

    public int getConfirmations();

    public int getBlockTimeStamp();

    public ChainTransactionId getReferencedTransaction();

    public byte[] getSignatureHash();

    public int getEcBlockHeight();

    public long getEcBlockId();

    public boolean isBundled();

    public long getRandomSeed(ContractRunnerConfig var1);

    public JO getAttachmentJson();

    public JO getJson();

    public boolean similar(TransactionResponse var1);
}

