/*
 * Decompiled with CFR 0.152.
 */
package nxt.lightcontracts;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.TransactionType;
import nxt.lightcontracts.LightContractTransactionType;
import nxt.util.Convert;
import nxt.util.bbh.LengthRwPrimitiveType;
import nxt.util.bbh.StringRw;
import org.json.simple.JSONObject;

public final class ContractReferenceAttachment
extends Attachment.AbstractAttachment {
    public static final StringRw NAME_RW = new StringRw(32);
    public static final StringRw PARAMS_RW = new StringRw(LengthRwPrimitiveType.UBYTE, 160);
    private final String contractName;
    private final String contractParams;
    private final ChainTransactionId contractId;

    ContractReferenceAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.contractName = NAME_RW.readFromBuffer(byteBuffer).trim();
        this.contractParams = PARAMS_RW.readFromBuffer(byteBuffer).trim();
        this.contractId = ChainTransactionId.parse(byteBuffer);
    }

    ContractReferenceAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.contractName = Convert.nullToEmpty((String)jSONObject.get((Object)"contractName")).trim();
        this.contractParams = Convert.nullToEmpty((String)jSONObject.get((Object)"contractParams")).trim();
        this.contractId = ChainTransactionId.parse((JSONObject)jSONObject.get((Object)"contract"));
    }

    public ContractReferenceAttachment(String string, String string2, ChainTransactionId chainTransactionId) {
        this.contractName = string.trim();
        this.contractParams = Convert.nullToEmpty(string2).trim();
        this.contractId = chainTransactionId;
    }

    @Override
    protected int getMySize() {
        return NAME_RW.getSize(this.contractName) + PARAMS_RW.getSize(this.contractParams) + 36;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        NAME_RW.writeToBuffer(this.contractName, byteBuffer);
        PARAMS_RW.writeToBuffer(this.contractParams, byteBuffer);
        this.contractId.put(byteBuffer);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"contractName", (Object)this.contractName);
        jSONObject.put((Object)"contractParams", (Object)this.contractParams);
        jSONObject.put((Object)"contract", (Object)this.contractId.getJSON());
    }

    @Override
    public TransactionType getTransactionType() {
        return LightContractTransactionType.CONTRACT_REFERENCE_SET;
    }

    public String getContractName() {
        return this.contractName;
    }

    public String getContractParams() {
        return this.contractParams;
    }

    public ChainTransactionId getContractId() {
        return this.contractId;
    }
}

