/*
 * Decompiled with CFR 0.152.
 */
package nxt.lightcontracts;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.Appendix;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.lightcontracts.ContractReference;
import nxt.lightcontracts.ContractReferenceAttachment;
import nxt.lightcontracts.ContractReferenceDeleteAttachment;
import org.json.simple.JSONObject;

public abstract class LightContractTransactionType
extends ChildTransactionType {
    private static final byte SUBTYPE_CONTRACT_REFERENCE_SET = 0;
    private static final byte SUBTYPE_CONTRACT_REFERENCE_DELETE = 1;
    public static final TransactionType CONTRACT_REFERENCE_SET = new LightContractTransactionType(){
        private final Fee CONTRACT_REFERENCE_ANNOUNCE_FEE = new Fee.SizeBasedFee(10000000L, 10000000L, 32){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                ContractReferenceAttachment contractReferenceAttachment = (ContractReferenceAttachment)transactionImpl.getAttachment();
                return contractReferenceAttachment.getSize();
            }
        };

        @Override
        public byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CONTRACT_REFERENCE_SET;
        }

        @Override
        public String getName() {
            return "ContractReference";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return this.CONTRACT_REFERENCE_ANNOUNCE_FEE;
        }

        @Override
        public ContractReferenceAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new ContractReferenceAttachment(byteBuffer);
        }

        @Override
        public ContractReferenceAttachment parseAttachment(JSONObject jSONObject) {
            return new ContractReferenceAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            ContractReferenceAttachment contractReferenceAttachment = (ContractReferenceAttachment)childTransactionImpl.getAttachment();
            String string = contractReferenceAttachment.getContractParams();
            if (!ContractReferenceAttachment.NAME_RW.validate(contractReferenceAttachment.getContractName()) || contractReferenceAttachment.getContractName().length() == 0 || !ContractReferenceAttachment.PARAMS_RW.validate(string)) {
                throw new NxtException.NotValidException("Invalid light contract announcement: " + contractReferenceAttachment.getJSONObject());
            }
            ChainTransactionId chainTransactionId = contractReferenceAttachment.getContractId();
            if (chainTransactionId == null) {
                throw new NxtException.NotCurrentlyValidException("Missing contract reference");
            }
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ContractReferenceAttachment contractReferenceAttachment = (ContractReferenceAttachment)childTransactionImpl.getAttachment();
            ContractReference.setContractReference(childTransactionImpl, account, contractReferenceAttachment.getContractName(), contractReferenceAttachment.getContractParams(), contractReferenceAttachment.getContractId());
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (ContractReference.getContractReference(childTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate light contract announce id " + childTransactionImpl.getStringId());
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }
    };
    public static final TransactionType CONTRACT_REFERENCE_DELETE = new LightContractTransactionType(){

        @Override
        public byte getSubtype() {
            return 1;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CONTRACT_REFERENCE_DELETE;
        }

        @Override
        public String getName() {
            return "ContractReferenceDelete";
        }

        @Override
        public ContractReferenceDeleteAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new ContractReferenceDeleteAttachment(byteBuffer);
        }

        @Override
        public ContractReferenceDeleteAttachment parseAttachment(JSONObject jSONObject) {
            return new ContractReferenceDeleteAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            ContractReferenceDeleteAttachment contractReferenceDeleteAttachment = (ContractReferenceDeleteAttachment)childTransactionImpl.getAttachment();
            ContractReference contractReference = ContractReference.getContractReference(contractReferenceDeleteAttachment.getContractReferenceId());
            if (contractReference == null) {
                throw new NxtException.NotCurrentlyValidException("No such light contract " + Long.toUnsignedString(contractReferenceDeleteAttachment.getContractReferenceId()));
            }
            if (contractReference.getAccountId() != childTransactionImpl.getSenderId()) {
                throw new NxtException.NotValidException("Account " + Long.toUnsignedString(childTransactionImpl.getSenderId()) + " cannot delete light contract " + Long.toUnsignedString(contractReferenceDeleteAttachment.getContractReferenceId()));
            }
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ContractReferenceDeleteAttachment contractReferenceDeleteAttachment = (ContractReferenceDeleteAttachment)childTransactionImpl.getAttachment();
            ContractReference.deleteContractReference(contractReferenceDeleteAttachment.getContractReferenceId());
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return CONTRACT_REFERENCE_SET;
            }
            case 1: {
                return CONTRACT_REFERENCE_DELETE;
            }
        }
        return null;
    }

    private LightContractTransactionType() {
    }

    @Override
    public final byte getType() {
        return 12;
    }

    @Override
    public final boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        return true;
    }

    @Override
    public final void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
    }

    @Override
    public final boolean isGlobal() {
        return true;
    }
}

