/*
 * Decompiled with CFR 0.152.
 */
package nxt.messaging;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Appendix;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.crypto.EncryptedData;
import nxt.util.Convert;
import org.json.simple.JSONObject;

abstract class AbstractEncryptedMessageAppendix
extends Appendix.AbstractAppendix {
    private static final Fee ENCRYPTED_MESSAGE_FEE = new Fee.SizeBasedFee(10000000L, 10000000L, 32){

        @Override
        public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
            return ((AbstractEncryptedMessageAppendix)appendix).getEncryptedDataLength() - 16;
        }
    };
    private EncryptedData encryptedData;
    private final boolean isText;
    private final boolean isCompressed;

    AbstractEncryptedMessageAppendix(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        byte by = byteBuffer.get();
        this.isText = (by & 1) != 0;
        this.isCompressed = (by & 2) != 0;
        int n = byteBuffer.getShort() & 0xFFFF;
        this.encryptedData = EncryptedData.readEncryptedData(byteBuffer, n, 1000);
    }

    AbstractEncryptedMessageAppendix(JSONObject jSONObject, JSONObject jSONObject2) {
        super(jSONObject);
        byte[] byArray = Convert.parseHexString((String)jSONObject2.get((Object)"data"));
        byte[] byArray2 = Convert.parseHexString((String)jSONObject2.get((Object)"nonce"));
        this.encryptedData = new EncryptedData(byArray, byArray2);
        this.isText = Boolean.TRUE.equals(jSONObject2.get((Object)"isText"));
        Object object = jSONObject2.get((Object)"isCompressed");
        this.isCompressed = object == null || Boolean.TRUE.equals(object);
    }

    AbstractEncryptedMessageAppendix(EncryptedData encryptedData, boolean bl, boolean bl2) {
        this.encryptedData = encryptedData;
        this.isText = bl;
        this.isCompressed = bl2;
    }

    @Override
    protected int getMySize() {
        return 3 + this.encryptedData.getSize();
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byte by = 0;
        if (this.isText) {
            by = (byte)(by | 1);
        }
        if (this.isCompressed) {
            by = (byte)(by | 2);
        }
        byteBuffer.put(by);
        byteBuffer.putShort((short)this.encryptedData.getData().length);
        byteBuffer.put(this.encryptedData.getData());
        byteBuffer.put(this.encryptedData.getNonce());
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"data", (Object)Convert.toHexString(this.encryptedData.getData()));
        jSONObject.put((Object)"nonce", (Object)Convert.toHexString(this.encryptedData.getNonce()));
        jSONObject.put((Object)"isText", (Object)this.isText);
        jSONObject.put((Object)"isCompressed", (Object)this.isCompressed);
    }

    @Override
    public Fee getBaselineFee(Transaction transaction) {
        return ENCRYPTED_MESSAGE_FEE;
    }

    @Override
    public void validate(Transaction transaction) throws NxtException.ValidationException {
        if (this.getEncryptedDataLength() > 176) {
            throw new NxtException.NotValidException("Max encrypted message length exceeded");
        }
        if (this.encryptedData != null && (this.encryptedData.getNonce().length != 32 && this.encryptedData.getData().length > 0 || this.encryptedData.getNonce().length != 0 && this.encryptedData.getData().length == 0)) {
            throw new NxtException.NotValidException("Invalid nonce length " + this.encryptedData.getNonce().length);
        }
    }

    @Override
    public void apply(Transaction transaction, Account account, Account account2) {
    }

    public final EncryptedData getEncryptedData() {
        return this.encryptedData;
    }

    final void setEncryptedData(EncryptedData encryptedData) {
        this.encryptedData = encryptedData;
    }

    int getEncryptedDataLength() {
        return this.encryptedData.getData().length;
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isCompressed() {
        return this.isCompressed;
    }

    @Override
    public final boolean isPhasable() {
        return false;
    }

    @Override
    public boolean isAllowed(Chain chain) {
        return chain instanceof ChildChain;
    }
}

