/*
 * Decompiled with CFR 0.152.
 */
package nxt.messaging;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Appendix;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.crypto.Crypto;
import nxt.messaging.PrunableMessageHome;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public class PrunablePlainMessageAppendix
extends Appendix.AbstractAppendix
implements Appendix.Prunable {
    public static final int appendixType = 8;
    public static final String appendixName = "PrunablePlainMessage";
    public static final Appendix.Parser appendixParser = new Appendix.Parser(){

        @Override
        public Appendix.AbstractAppendix parse(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new PrunablePlainMessageAppendix(byteBuffer);
        }

        @Override
        public Appendix.AbstractAppendix parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(PrunablePlainMessageAppendix.appendixName, jSONObject)) {
                return null;
            }
            return new PrunablePlainMessageAppendix(jSONObject);
        }
    };
    private static final Fee PRUNABLE_MESSAGE_FEE = new Fee.SizeBasedFee(1000000L){

        @Override
        public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
            return appendix.getFullSize();
        }
    };
    private final byte[] hash;
    private final byte[] message;
    private final boolean isText;
    private volatile PrunableMessageHome.PrunableMessage prunableMessage;

    private PrunablePlainMessageAppendix(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        byte by = byteBuffer.get();
        if ((by & 1) != 0) {
            this.isText = (by & 2) != 0;
            int n = byteBuffer.getInt();
            if (n > 43008) {
                throw new NxtException.NotValidException("Invalid prunable message length: " + n);
            }
            this.message = new byte[n];
            byteBuffer.get(this.message);
            this.hash = null;
        } else {
            this.hash = new byte[32];
            byteBuffer.get(this.hash);
            this.message = null;
            this.isText = false;
        }
    }

    private PrunablePlainMessageAppendix(JSONObject jSONObject) {
        super(jSONObject);
        String string = Convert.emptyToNull((String)jSONObject.get((Object)"messageHash"));
        String string2 = Convert.emptyToNull((String)jSONObject.get((Object)"message"));
        if (string != null && string2 == null) {
            this.hash = Convert.parseHexString(string);
            this.message = null;
            this.isText = false;
        } else {
            this.hash = null;
            this.isText = Boolean.TRUE.equals(jSONObject.get((Object)"messageIsText"));
            this.message = Convert.toBytes(string2, this.isText);
        }
    }

    public PrunablePlainMessageAppendix(byte[] byArray) {
        this(byArray, false);
    }

    public PrunablePlainMessageAppendix(String string) {
        this(Convert.toBytes(string), true);
    }

    public PrunablePlainMessageAppendix(String string, boolean bl) {
        this(Convert.toBytes(string, bl), bl);
    }

    public PrunablePlainMessageAppendix(byte[] byArray, boolean bl) {
        this.message = byArray;
        this.isText = bl;
        this.hash = null;
    }

    @Override
    public int getAppendixType() {
        return 8;
    }

    @Override
    public String getAppendixName() {
        return appendixName;
    }

    @Override
    public Fee getBaselineFee(Transaction transaction) {
        return PRUNABLE_MESSAGE_FEE;
    }

    @Override
    protected int getMySize() {
        return 33;
    }

    @Override
    public int getMyFullSize() {
        if (!this.hasPrunableData()) {
            throw new IllegalStateException("Prunable data not available");
        }
        return 5 + this.getMessage().length;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)0);
        byteBuffer.put(this.getHash());
    }

    @Override
    public void putMyPrunableBytes(ByteBuffer byteBuffer) {
        if (!this.hasPrunableData()) {
            throw new IllegalStateException("Prunable data not available");
        }
        byte by = 1;
        if (this.isText()) {
            by = (byte)(by | 2);
        }
        byteBuffer.put(by);
        byteBuffer.putInt(this.getMessage().length);
        byteBuffer.put(this.getMessage());
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        if (this.prunableMessage != null) {
            jSONObject.put((Object)"message", (Object)Convert.toString(this.prunableMessage.getMessage(), this.prunableMessage.messageIsText()));
            jSONObject.put((Object)"messageIsText", (Object)this.prunableMessage.messageIsText());
        } else if (this.message != null) {
            jSONObject.put((Object)"message", (Object)Convert.toString(this.message, this.isText));
            jSONObject.put((Object)"messageIsText", (Object)this.isText);
        }
        jSONObject.put((Object)"messageHash", (Object)Convert.toHexString(this.getHash()));
    }

    @Override
    public void validate(Transaction transaction) throws NxtException.ValidationException {
        if (transaction instanceof ChildTransaction && ((ChildTransaction)transaction).getMessage() != null) {
            throw new NxtException.NotValidException("Cannot have both message and prunable message attachments");
        }
        byte[] byArray = this.getMessage();
        if (byArray != null && byArray.length > 43008) {
            throw new NxtException.NotValidException("Invalid prunable message length: " + byArray.length);
        }
        if (byArray == null && Nxt.getEpochTime() - transaction.getTimestamp() < Constants.MIN_PRUNABLE_LIFETIME) {
            throw new NxtException.NotCurrentlyValidException("Message has been pruned prematurely");
        }
    }

    @Override
    public void apply(Transaction transaction, Account account, Account account2) {
        if (Nxt.getEpochTime() - transaction.getTimestamp() < Constants.MAX_PRUNABLE_LIFETIME) {
            transaction.getChain().getPrunableMessageHome().add((TransactionImpl)transaction, this);
        }
    }

    public byte[] getMessage() {
        if (this.prunableMessage != null) {
            return this.prunableMessage.getMessage();
        }
        return this.message;
    }

    public boolean isText() {
        if (this.prunableMessage != null) {
            return this.prunableMessage.messageIsText();
        }
        return this.isText;
    }

    @Override
    public byte[] getHash() {
        if (this.hash != null) {
            return this.hash;
        }
        MessageDigest messageDigest = Crypto.sha256();
        messageDigest.update((byte)(this.isText ? 1 : 0));
        messageDigest.update(this.message);
        return messageDigest.digest();
    }

    @Override
    public final void loadPrunable(Transaction transaction, boolean bl) {
        PrunableMessageHome.PrunableMessage prunableMessage;
        if (!this.hasPrunableData() && this.shouldLoadPrunable(transaction, bl) && (prunableMessage = transaction.getChain().getPrunableMessageHome().getPrunableMessage(transaction.getFullHash())) != null && prunableMessage.getMessage() != null) {
            this.prunableMessage = prunableMessage;
        }
    }

    @Override
    public boolean isPhasable() {
        return false;
    }

    @Override
    public boolean isAllowed(Chain chain) {
        return true;
    }

    @Override
    public final boolean hasPrunableData() {
        return this.prunableMessage != null || this.message != null;
    }

    @Override
    public void restorePrunableData(Transaction transaction, int n, int n2) {
        transaction.getChain().getPrunableMessageHome().add((TransactionImpl)transaction, this, n, n2);
    }
}

