/*
 * Decompiled with CFR 0.152.
 */
package nxt.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Nxt;
import nxt.account.HoldingType;
import nxt.blockchain.ChildChain;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;

class HoldingMigration {
    private static final DbKey.LongKeyFactory DB_KEY_FACTORY = new DbKey.LongKeyFactory<HoldingMigration>("child_chain_id"){

        @Override
        public DbKey newKey(HoldingMigration holdingMigration) {
            return holdingMigration.dbKey;
        }
    };
    private static final VersionedEntityDbTable<HoldingMigration> DB_TABLE = new VersionedEntityDbTable<HoldingMigration>("public.holding_migrate", (DbKey.Factory)DB_KEY_FACTORY){

        @Override
        protected HoldingMigration load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new HoldingMigration(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, HoldingMigration holdingMigration) throws SQLException {
            holdingMigration.save(connection);
        }
    };
    private final DbKey dbKey;
    private final long holdingId;
    private final HoldingType holdingType;
    private final ChildChain childChain;
    private final int minHeight;
    private int actualHeight;
    private int height;

    static void init() {
    }

    HoldingMigration(long l, HoldingType holdingType, ChildChain childChain, int n, int n2) {
        this.dbKey = DB_KEY_FACTORY.newKey(childChain.getId());
        this.holdingId = l;
        this.holdingType = holdingType;
        this.minHeight = n;
        this.actualHeight = n2;
        this.childChain = childChain;
        this.height = -1;
    }

    private HoldingMigration(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.dbKey = dbKey;
        this.holdingId = resultSet.getLong("holding_id");
        this.holdingType = HoldingType.valueOf(resultSet.getString("holding_type"));
        this.childChain = ChildChain.getChildChain(resultSet.getInt("child_chain_id"));
        this.minHeight = resultSet.getInt("min_height");
        this.actualHeight = resultSet.getInt("actual_height");
        this.height = resultSet.getInt("height");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO holding_migrate (holding_id, holding_type, child_chain_id, min_height, actual_height, height, latest) KEY (child_chain_id, height) VALUES (?, ?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.holdingId);
            preparedStatement.setString(++n, this.holdingType.name());
            preparedStatement.setInt(++n, this.childChain.getId());
            preparedStatement.setInt(++n, this.minHeight);
            preparedStatement.setInt(++n, this.actualHeight);
            preparedStatement.setInt(++n, this.height);
            preparedStatement.executeUpdate();
        }
    }

    static HoldingMigration getByChildChain(ChildChain childChain) {
        return (HoldingMigration)DB_TABLE.get(DB_KEY_FACTORY.newKey(childChain.getId()));
    }

    static HoldingMigration getByHoldingId(long l, HoldingType holdingType) {
        return (HoldingMigration)DB_TABLE.getBy(new DbClause.LongClause("holding_id", l).and(new DbClause.StringClause("holding_type", holdingType.name())));
    }

    static void insert(HoldingMigration holdingMigration) {
        DB_TABLE.insert(holdingMigration);
    }

    static DbIterator<HoldingMigration> getAll() {
        return DB_TABLE.getAll(0, -1);
    }

    static DbIterator<HoldingMigration> getMigrations(int n) {
        DbClause.IntClause intClause = new DbClause.IntClause("actual_height", n);
        return DB_TABLE.getManyBy(intClause, -1, -1);
    }

    void setActualHeight(int n) {
        this.actualHeight = n;
        this.height = Nxt.getBlockchain().getHeight();
    }

    long getHoldingId() {
        return this.holdingId;
    }

    ChildChain getChildChain() {
        return this.childChain;
    }

    int getMinHeight() {
        return this.minHeight;
    }

    HoldingType getHoldingType() {
        return this.holdingType;
    }

    int getActualHeight() {
        return this.actualHeight;
    }

    public String toString() {
        return "HoldingMigration{holdingId=" + this.holdingId + ", holdingType=" + (Object)((Object)this.holdingType) + ", childChain=" + this.childChain.getId() + ", minHeight=" + this.minHeight + ", actualHeight=" + this.actualHeight + '}';
    }
}

