/*
 * Decompiled with CFR 0.152.
 */
package nxt.migration;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import nxt.Constants;
import nxt.account.HoldingType;
import nxt.migration.HoldingMigration;
import nxt.util.JSON;
import nxt.util.Logger;
import nxt.util.ResourceLookup;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public abstract class HoldingSnapshot {
    private final HoldingType holdingType;

    public HoldingSnapshot(HoldingType holdingType) {
        this.holdingType = holdingType;
    }

    File writeSnapshot(long l, int n) {
        Map<String, Long> map = this.takeSnapshot(l);
        return this.writeSnapshot(map, l, n);
    }

    public File writeSnapshot(Map<String, Long> map, long l, int n) {
        String string = Constants.isTestnet ? "snapshot-%s_%s-height_%s-testnet.json" : "snapshot-%s_%s-height_%s.json";
        String string2 = String.format(string, this.holdingType.name().toLowerCase(), Long.toUnsignedString(l), n);
        File file = new File(string2);
        Logger.logInfoMessage("Will save " + map.size() + " entries to " + string2);
        try (PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(file)), true);){
            JSON.encodeObject(map, printWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
        Logger.logInfoMessage("Done");
        return file;
    }

    Map<String, Long> getSnapshot(HoldingMigration holdingMigration) {
        Map<String, Long> map = this.readSnapshot(holdingMigration);
        if (map != null) {
            Logger.logInfoMessage("Read snapshot for child chain " + holdingMigration.getChildChain().getName());
            return map;
        }
        return this.takeSnapshot(holdingMigration.getHoldingId());
    }

    protected abstract Map<String, Long> takeSnapshot(long var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Long> readSnapshot(HoldingMigration holdingMigration) {
        String string = "data/" + holdingMigration.getChildChain().getName() + (Constants.isTestnet ? "-testnet.json" : ".json");
        InputStream inputStream = ResourceLookup.getSystemResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            Map map = (Map)JSONValue.parseWithException((Reader)bufferedReader);
            return map;
        }
        catch (IOException | ParseException throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public HoldingType getHoldingType() {
        return this.holdingType;
    }
}

