/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import nxt.Nxt;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.BalanceHome;
import nxt.blockchain.Block;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;
import nxt.ms.CurrencyFounderHome;
import nxt.ms.CurrencyFreezeMonitor;
import nxt.ms.CurrencyIssuanceAttachment;
import nxt.ms.CurrencyMigrateMonitor;
import nxt.ms.CurrencyMint;
import nxt.ms.CurrencyTransfer;
import nxt.ms.CurrencyType;
import nxt.ms.ExchangeHome;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class Currency {
    public static final String CURRENCY_FREEZE_HEIGHT_PROPERTY_PREFIX = "Freeze";
    public static final String CURRENCY_MIGRATE_HEIGHT_PROPERTY_PREFIX = "Migrate";
    private static final DbKey.LongKeyFactory<Currency> currencyDbKeyFactory = new DbKey.LongKeyFactory<Currency>("id"){

        @Override
        public DbKey newKey(Currency currency) {
            return currency.dbKey == null ? this.newKey(currency.currencyId) : currency.dbKey;
        }
    };
    private static final VersionedEntityDbTable<Currency> currencyTable = new VersionedEntityDbTable<Currency>("public.currency", currencyDbKeyFactory, "code,name,description"){

        @Override
        protected Currency load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Currency(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Currency currency) throws SQLException {
            currency.save(connection);
        }

        @Override
        public String defaultSort() {
            return " ORDER BY creation_height DESC ";
        }
    };
    private static final DbKey.LongKeyFactory<CurrencySupply> currencySupplyDbKeyFactory = new DbKey.LongKeyFactory<CurrencySupply>("id"){

        @Override
        public DbKey newKey(CurrencySupply currencySupply) {
            return currencySupply.dbKey;
        }
    };
    private static final VersionedEntityDbTable<CurrencySupply> currencySupplyTable = new VersionedEntityDbTable<CurrencySupply>("public.currency_supply", currencySupplyDbKeyFactory){

        @Override
        protected CurrencySupply load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new CurrencySupply(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, CurrencySupply currencySupply) throws SQLException {
            currencySupply.save(connection);
        }
    };
    private static final Listeners<Currency, Event> listeners = new Listeners();
    private static final DbClause excludeDeleted = new DbClause.BooleanClause("is_deleted", false);
    private final long currencyId;
    private final DbKey dbKey;
    private final long accountId;
    private final String name;
    private final String code;
    private final String description;
    private final int type;
    private final ChildChain childChain;
    private final long maxSupplyQNT;
    private final long reserveSupplyQNT;
    private final int creationHeight;
    private final int issuanceHeight;
    private final long minReservePerUnitNQT;
    private final int minDifficulty;
    private final int maxDifficulty;
    private final byte ruleset;
    private final byte algorithm;
    private final byte decimals;
    private final long initialSupplyQNT;
    private CurrencySupply currencySupply;
    private boolean isDeleted;

    public static boolean addListener(Listener<Currency> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Currency> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    public static DbIterator<Currency> getAllCurrencies(int n, int n2) {
        return currencyTable.getManyBy(excludeDeleted, n, n2);
    }

    public static int getCount() {
        return currencyTable.getCount(excludeDeleted);
    }

    public static Currency getCurrency(long l) {
        return Currency.getCurrency(l, false);
    }

    public static Currency getCurrency(long l, boolean bl) {
        Currency currency = (Currency)currencyTable.get(currencyDbKeyFactory.newKey(l));
        if (currency != null && currency.isDeleted() && !bl) {
            return null;
        }
        return currency;
    }

    public static Currency getCurrencyByName(ChildChain childChain, String string) {
        return (Currency)currencyTable.getBy(new DbClause.StringClause("name_lower", string.toLowerCase(Locale.ROOT)).and(new DbClause.IntClause("chain", childChain.getId())).and(excludeDeleted));
    }

    public static Currency getCurrencyByCode(ChildChain childChain, String string) {
        return (Currency)currencyTable.getBy(new DbClause.StringClause("code", string.toUpperCase(Locale.ROOT)).and(new DbClause.IntClause("chain", childChain.getId())).and(excludeDeleted));
    }

    public static DbIterator<Currency> getCurrencyIssuedBy(long l, int n, int n2) {
        return currencyTable.getManyBy(new DbClause.LongClause("account_id", l).and(excludeDeleted), n, n2);
    }

    public static DbIterator<Currency> searchCurrencies(String string, int n, int n2) {
        return currencyTable.search(string, excludeDeleted, n, n2, " ORDER BY ft.score DESC, currency.creation_height DESC ");
    }

    static void addCurrency(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, Transaction transaction, Account account, CurrencyIssuanceAttachment currencyIssuanceAttachment) {
        ChildChain childChain = (ChildChain)transaction.getChain();
        Currency currency = Currency.getCurrencyByCode(childChain, currencyIssuanceAttachment.getCode());
        if (currency != null) {
            currency.delete(ledgerEvent, ledgerEventId, account);
        }
        if ((currency = Currency.getCurrencyByCode(childChain, currencyIssuanceAttachment.getName())) != null) {
            currency.delete(ledgerEvent, ledgerEventId, account);
        }
        if ((currency = Currency.getCurrencyByName(childChain, currencyIssuanceAttachment.getName())) != null) {
            currency.delete(ledgerEvent, ledgerEventId, account);
        }
        if ((currency = Currency.getCurrencyByName(childChain, currencyIssuanceAttachment.getCode())) != null) {
            currency.delete(ledgerEvent, ledgerEventId, account);
        }
        Currency currency2 = new Currency(transaction, currencyIssuanceAttachment);
        currencyTable.insert(currency2);
        if (currency2.is(CurrencyType.MINTABLE) || currency2.is(CurrencyType.RESERVABLE)) {
            CurrencySupply currencySupply = currency2.getSupplyData();
            currencySupply.currentSupplyQNT = currencyIssuanceAttachment.getInitialSupplyQNT();
            currencySupplyTable.insert(currencySupply);
        }
    }

    public static void importCurrency(long l, long l2, String string, String string2) {
        Currency currency = new Currency(l, l2, string, string2);
        currencyTable.insert(currency);
    }

    public static void init() {
        CurrencyFreezeMonitor.init();
        CurrencyMigrateMonitor.init();
    }

    private Currency(Transaction transaction, CurrencyIssuanceAttachment currencyIssuanceAttachment) {
        this.currencyId = transaction.getId();
        this.dbKey = currencyDbKeyFactory.newKey(this.currencyId);
        this.accountId = transaction.getSenderId();
        this.name = currencyIssuanceAttachment.getName();
        this.code = currencyIssuanceAttachment.getCode();
        this.description = currencyIssuanceAttachment.getDescription();
        this.type = currencyIssuanceAttachment.getType();
        this.childChain = (ChildChain)transaction.getChain();
        this.initialSupplyQNT = currencyIssuanceAttachment.getInitialSupplyQNT();
        this.reserveSupplyQNT = currencyIssuanceAttachment.getReserveSupplyQNT();
        this.maxSupplyQNT = currencyIssuanceAttachment.getMaxSupplyQNT();
        this.creationHeight = Nxt.getBlockchain().getHeight();
        this.issuanceHeight = currencyIssuanceAttachment.getIssuanceHeight();
        this.minReservePerUnitNQT = currencyIssuanceAttachment.getMinReservePerUnitNQT();
        this.minDifficulty = currencyIssuanceAttachment.getMinDifficulty();
        this.maxDifficulty = currencyIssuanceAttachment.getMaxDifficulty();
        this.ruleset = currencyIssuanceAttachment.getRuleset();
        this.algorithm = currencyIssuanceAttachment.getAlgorithm();
        this.decimals = currencyIssuanceAttachment.getDecimals();
        this.isDeleted = false;
    }

    private Currency(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.currencyId = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.accountId = resultSet.getLong("account_id");
        this.name = resultSet.getString("name");
        this.code = resultSet.getString("code");
        this.description = resultSet.getString("description");
        this.type = resultSet.getInt("type");
        this.childChain = ChildChain.getChildChain(resultSet.getInt("chain"));
        this.initialSupplyQNT = resultSet.getLong("initial_supply");
        this.reserveSupplyQNT = resultSet.getLong("reserve_supply");
        this.maxSupplyQNT = resultSet.getLong("max_supply");
        this.creationHeight = resultSet.getInt("creation_height");
        this.issuanceHeight = resultSet.getInt("issuance_height");
        this.minReservePerUnitNQT = resultSet.getLong("min_reserve_per_unit_nqt");
        this.minDifficulty = resultSet.getByte("min_difficulty") & 0xFF;
        this.maxDifficulty = resultSet.getByte("max_difficulty") & 0xFF;
        this.ruleset = resultSet.getByte("ruleset");
        this.algorithm = resultSet.getByte("algorithm");
        this.decimals = resultSet.getByte("decimals");
        this.isDeleted = resultSet.getBoolean("is_deleted");
    }

    private Currency(long l, long l2, String string, String string2) {
        this.currencyId = l;
        this.dbKey = currencyDbKeyFactory.newKey(this.currencyId);
        this.accountId = l2;
        this.name = string2;
        this.code = string;
        this.description = string2;
        this.type = CurrencyType.EXCHANGEABLE.getCode();
        this.childChain = ChildChain.IGNIS;
        this.initialSupplyQNT = 1L;
        this.reserveSupplyQNT = 0L;
        this.maxSupplyQNT = 1L;
        this.creationHeight = 0;
        this.issuanceHeight = 0;
        this.minReservePerUnitNQT = 0L;
        this.minDifficulty = 0;
        this.maxDifficulty = 0;
        this.ruleset = 0;
        this.algorithm = 0;
        this.decimals = 0;
        this.isDeleted = false;
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO currency (id, account_id, name, name_lower, code, description, type, chain, initial_supply, reserve_supply, max_supply, creation_height, issuance_height, min_reserve_per_unit_nqt, min_difficulty, max_difficulty, ruleset, algorithm, decimals, is_deleted, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.currencyId);
            preparedStatement.setLong(++n, this.accountId);
            preparedStatement.setString(++n, this.name);
            preparedStatement.setString(++n, this.name.toLowerCase(Locale.ROOT));
            preparedStatement.setString(++n, this.code);
            preparedStatement.setString(++n, this.description);
            preparedStatement.setInt(++n, this.type);
            preparedStatement.setInt(++n, this.childChain.getId());
            preparedStatement.setLong(++n, this.initialSupplyQNT);
            preparedStatement.setLong(++n, this.reserveSupplyQNT);
            preparedStatement.setLong(++n, this.maxSupplyQNT);
            preparedStatement.setInt(++n, this.creationHeight);
            preparedStatement.setInt(++n, this.issuanceHeight);
            preparedStatement.setLong(++n, this.minReservePerUnitNQT);
            preparedStatement.setByte(++n, (byte)this.minDifficulty);
            preparedStatement.setByte(++n, (byte)this.maxDifficulty);
            preparedStatement.setByte(++n, this.ruleset);
            preparedStatement.setByte(++n, this.algorithm);
            preparedStatement.setByte(++n, this.decimals);
            preparedStatement.setBoolean(++n, this.isDeleted);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.currencyId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.type;
    }

    public ChildChain getChildChain() {
        return this.childChain;
    }

    public long getInitialSupplyQNT() {
        return this.initialSupplyQNT;
    }

    public long getCurrentSupplyQNT() {
        if (!this.is(CurrencyType.RESERVABLE) && !this.is(CurrencyType.MINTABLE)) {
            return this.initialSupplyQNT;
        }
        if (this.getSupplyData() == null) {
            return 0L;
        }
        return this.currencySupply.currentSupplyQNT;
    }

    public long getReserveSupplyQNT() {
        return this.reserveSupplyQNT;
    }

    public long getMaxSupplyQNT() {
        return this.maxSupplyQNT;
    }

    public int getCreationHeight() {
        return this.creationHeight;
    }

    public int getIssuanceHeight() {
        return this.issuanceHeight;
    }

    public long getMinReservePerUnitNQT() {
        return this.minReservePerUnitNQT;
    }

    public int getMinDifficulty() {
        return this.minDifficulty;
    }

    public int getMaxDifficulty() {
        return this.maxDifficulty;
    }

    public byte getRuleset() {
        return this.ruleset;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public byte getDecimals() {
        return this.decimals;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public long getCurrentReservePerUnitNQT() {
        if (!this.is(CurrencyType.RESERVABLE) || this.getSupplyData() == null) {
            return 0L;
        }
        return this.currencySupply.currentReservePerUnitNQT;
    }

    public boolean isActive() {
        return this.issuanceHeight <= Nxt.getBlockchain().getHeight();
    }

    private CurrencySupply getSupplyData() {
        if (!this.is(CurrencyType.RESERVABLE) && !this.is(CurrencyType.MINTABLE)) {
            return null;
        }
        if (this.currencySupply == null) {
            this.currencySupply = (CurrencySupply)currencySupplyTable.get(currencyDbKeyFactory.newKey(this));
            if (this.currencySupply == null) {
                this.currencySupply = new CurrencySupply(this);
            }
        }
        return this.currencySupply;
    }

    void increaseReserve(long l) {
        this.getSupplyData();
        CurrencySupply currencySupply = this.currencySupply;
        currencySupply.currentReservePerUnitNQT = currencySupply.currentReservePerUnitNQT + l;
        currencySupplyTable.insert(this.currencySupply);
    }

    static void claimReserve(ChildChain childChain, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, Account account, long l, long l2) {
        account.addToCurrencyUnits(ledgerEvent, ledgerEventId, l, -l2);
        Currency currency = Currency.getCurrency(l);
        currency.increaseSupply(-l2);
        long l3 = Convert.unitRateToAmount(l2, currency.getDecimals(), currency.getCurrentReservePerUnitNQT(), childChain.getDecimals());
        account.addToBalanceAndUnconfirmedBalance(childChain, ledgerEvent, ledgerEventId, l3);
    }

    static void transferCurrency(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, Account account, Account account2, long l, long l2) {
        account.addToCurrencyUnits(ledgerEvent, ledgerEventId, l, -l2);
        account2.addToCurrencyAndUnconfirmedCurrencyUnits(ledgerEvent, ledgerEventId, l, l2);
    }

    void increaseSupply(long l) {
        this.getSupplyData();
        CurrencySupply currencySupply = this.currencySupply;
        currencySupply.currentSupplyQNT = currencySupply.currentSupplyQNT + l;
        if (this.currencySupply.currentSupplyQNT > this.maxSupplyQNT || this.currencySupply.currentSupplyQNT < 0L) {
            currencySupply = this.currencySupply;
            currencySupply.currentSupplyQNT = currencySupply.currentSupplyQNT - l;
            throw new IllegalArgumentException("Cannot add " + l + " to current supply of " + this.currencySupply.currentSupplyQNT);
        }
        currencySupplyTable.insert(this.currencySupply);
    }

    public DbIterator<Account.AccountCurrency> getAccounts(int n, int n2) {
        return Account.getCurrencyAccounts(this.currencyId, n, n2);
    }

    public DbIterator<Account.AccountCurrency> getAccounts(int n, int n2, int n3) {
        return Account.getCurrencyAccounts(this.currencyId, n, n2, n3);
    }

    public DbIterator<ExchangeHome.Exchange> getExchanges(ChildChain childChain, int n, int n2) {
        return childChain.getExchangeHome().getCurrencyExchanges(this.currencyId, n, n2);
    }

    public DbIterator<CurrencyTransfer> getTransfers(int n, int n2) {
        return CurrencyTransfer.getCurrencyTransfers(this.currencyId, n, n2);
    }

    public boolean is(CurrencyType currencyType) {
        return (this.type & currencyType.getCode()) != 0;
    }

    public boolean canBeDeletedBy(long l) {
        if (!this.isActive()) {
            return l == this.accountId;
        }
        if (this.is(CurrencyType.MINTABLE) && this.getCurrentSupplyQNT() < this.maxSupplyQNT && l != this.accountId) {
            return false;
        }
        try (DbIterator<Account.AccountCurrency> dbIterator = Account.getCurrencyAccounts(this.currencyId, 0, -1);){
            if (!dbIterator.hasNext()) {
                boolean bl = true;
                return bl;
            }
            Account.AccountCurrency accountCurrency = dbIterator.next();
            boolean bl = !dbIterator.hasNext() && accountCurrency.getAccountId() == l && accountCurrency.getUnconfirmedUnits() == accountCurrency.getUnits();
            return bl;
        }
    }

    void delete(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, Account account) {
        if (!this.canBeDeletedBy(account.getId())) {
            throw new IllegalStateException("Currency " + Long.toUnsignedString(this.currencyId) + " not entirely owned by " + Long.toUnsignedString(account.getId()));
        }
        listeners.notify(this, Event.BEFORE_DELETE);
        if (this.is(CurrencyType.RESERVABLE)) {
            if (this.is(CurrencyType.CLAIMABLE) && this.isActive()) {
                account.addToUnconfirmedCurrencyUnits(ledgerEvent, ledgerEventId, this.currencyId, -account.getCurrencyUnits(this.currencyId));
                Currency.claimReserve(this.childChain, ledgerEvent, ledgerEventId, account, this.currencyId, account.getCurrencyUnits(this.currencyId));
            }
            if (!this.isActive()) {
                BalanceHome balanceHome = this.childChain.getBalanceHome();
                try (DbIterator<CurrencyFounderHome.CurrencyFounder> dbIterator = this.childChain.getCurrencyFounderHome().getCurrencyFounders(this.currencyId, 0, Integer.MAX_VALUE);){
                    for (CurrencyFounderHome.CurrencyFounder currencyFounder : dbIterator) {
                        balanceHome.getBalance(currencyFounder.getAccountId()).addToBalanceAndUnconfirmedBalance(ledgerEvent, ledgerEventId, currencyFounder.getAmountNQT());
                    }
                }
            }
            this.childChain.getCurrencyFounderHome().remove(this.currencyId);
        }
        if (this.is(CurrencyType.MINTABLE)) {
            CurrencyMint.deleteCurrency(this);
        }
        account.addToUnconfirmedCurrencyUnits(ledgerEvent, ledgerEventId, this.currencyId, -account.getUnconfirmedCurrencyUnits(this.currencyId));
        account.addToCurrencyUnits(ledgerEvent, ledgerEventId, this.currencyId, -account.getCurrencyUnits(this.currencyId));
        this.isDeleted = true;
        currencyTable.insert(this);
    }

    static {
        Nxt.getBlockchainProcessor().addListener(new CrowdFundingListener(), BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
    }

    private static final class CrowdFundingListener
    implements Listener<Block> {
        private CrowdFundingListener() {
        }

        @Override
        public void notify(Block block) {
            try (DbIterator dbIterator = currencyTable.getManyBy(new DbClause.IntClause("issuance_height", block.getHeight()).and(excludeDeleted), 0, -1);){
                for (Currency currency : dbIterator) {
                    if (currency.getCurrentReservePerUnitNQT() < currency.getMinReservePerUnitNQT()) {
                        listeners.notify(currency, Event.BEFORE_UNDO_CROWDFUNDING);
                        this.undoCrowdFunding(currency);
                        continue;
                    }
                    listeners.notify(currency, Event.BEFORE_DISTRIBUTE_CROWDFUNDING);
                    this.distributeCurrency(currency);
                }
            }
        }

        private void undoCrowdFunding(Currency currency) {
            ChildChain childChain = currency.getChildChain();
            BalanceHome balanceHome = childChain.getBalanceHome();
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(currency.getId(), null, childChain);
            try (DbIterator<CurrencyFounderHome.CurrencyFounder> dbIterator = childChain.getCurrencyFounderHome().getCurrencyFounders(currency.getId(), 0, Integer.MAX_VALUE);){
                for (CurrencyFounderHome.CurrencyFounder currencyFounder : dbIterator) {
                    balanceHome.getBalance(currencyFounder.getAccountId()).addToBalanceAndUnconfirmedBalance(AccountLedger.LedgerEvent.CURRENCY_UNDO_CROWDFUNDING, ledgerEventId, currencyFounder.getAmountNQT());
                }
            }
            Account.getAccount(currency.getAccountId()).addToCurrencyAndUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_UNDO_CROWDFUNDING, ledgerEventId, currency.getId(), -currency.getInitialSupplyQNT());
            currency.isDeleted = true;
            currencyTable.insert(currency);
            childChain.getCurrencyFounderHome().remove(currency.getId());
        }

        private void distributeCurrency(Currency currency) {
            Object object;
            Object object2;
            ChildChain childChain = currency.getChildChain();
            long l = 0L;
            long l2 = currency.getReserveSupplyQNT() - currency.getInitialSupplyQNT();
            ArrayList<CurrencyFounderHome.CurrencyFounder> arrayList = new ArrayList<CurrencyFounderHome.CurrencyFounder>();
            Object object3 = childChain.getCurrencyFounderHome().getCurrencyFounders(currency.getId(), 0, Integer.MAX_VALUE);
            Object object4 = null;
            try {
                object2 = ((DbIterator)object3).iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    l += ((CurrencyFounderHome.CurrencyFounder)object).getAmountPerUnitNQT();
                    arrayList.add((CurrencyFounderHome.CurrencyFounder)object);
                }
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (object4 != null) {
                        try {
                            ((DbIterator)object3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object4).addSuppressed(throwable);
                        }
                    } else {
                        ((DbIterator)object3).close();
                    }
                }
            }
            object3 = AccountLedger.newEventId(currency.getId(), null, childChain);
            object4 = currency.getSupplyData();
            object2 = new BigDecimal(l2).movePointLeft(currency.getDecimals());
            object = new BigDecimal(l).movePointLeft(childChain.getDecimals());
            long l3 = 0L;
            for (CurrencyFounderHome.CurrencyFounder currencyFounder : arrayList) {
                long l4 = ((BigDecimal)object2).multiply(new BigDecimal(currencyFounder.getAmountPerUnitNQT()).movePointLeft(childChain.getDecimals()).divide((BigDecimal)object, MathContext.DECIMAL128)).movePointRight(currency.getDecimals()).longValue();
                Object object5 = object4;
                ((CurrencySupply)object5).currentSupplyQNT = ((CurrencySupply)object5).currentSupplyQNT + l4;
                Account.getAccount(currencyFounder.getAccountId()).addToCurrencyAndUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_DISTRIBUTION, (AccountLedger.LedgerEventId)object3, currency.getId(), l4);
                l3 += currencyFounder.getAmountNQT();
            }
            Account account = Account.getAccount(currency.getAccountId());
            account.addToCurrencyAndUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_DISTRIBUTION, (AccountLedger.LedgerEventId)object3, currency.getId(), currency.getReserveSupplyQNT() - currency.getCurrentSupplyQNT());
            if (!currency.is(CurrencyType.CLAIMABLE)) {
                account.addToBalanceAndUnconfirmedBalance(childChain, AccountLedger.LedgerEvent.CURRENCY_DISTRIBUTION, (AccountLedger.LedgerEventId)object3, l3);
            }
            ((CurrencySupply)object4).currentSupplyQNT = currency.getReserveSupplyQNT();
            currencySupplyTable.insert(object4);
        }
    }

    private static final class CurrencySupply {
        private final DbKey dbKey;
        private final long currencyId;
        private long currentSupplyQNT;
        private long currentReservePerUnitNQT;

        private CurrencySupply(Currency currency) {
            this.currencyId = currency.currencyId;
            this.dbKey = currencySupplyDbKeyFactory.newKey(this.currencyId);
        }

        private CurrencySupply(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.currencyId = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.currentSupplyQNT = resultSet.getLong("current_supply");
            this.currentReservePerUnitNQT = resultSet.getLong("current_reserve_per_unit_nqt");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO currency_supply (id, current_supply, current_reserve_per_unit_nqt, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.currencyId);
                preparedStatement.setLong(++n, this.currentSupplyQNT);
                preparedStatement.setLong(++n, this.currentReservePerUnitNQT);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    }

    public static enum Event {
        BEFORE_DISTRIBUTE_CROWDFUNDING,
        BEFORE_UNDO_CROWDFUNDING,
        BEFORE_DELETE;

    }
}

