/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.HoldingType;
import nxt.blockchain.BlockchainProcessor;
import nxt.db.DbIterator;
import nxt.dbschema.Db;
import nxt.freeze.AbstractFreezeBlockHandler;
import nxt.freeze.FreezeMonitor;
import nxt.ms.Currency;
import nxt.ms.ExchangeOfferHome;
import nxt.util.Listener;
import nxt.util.Logger;

public class CurrencyFreezeMonitor {
    private static final FreezeMonitor freezeMonitor = new FreezeMonitor(HoldingType.CURRENCY);

    public static void init() {
        Nxt.getBlockchainProcessor().addListener(new CancelOffersBlockHandler(), BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
        Account.addPropertyListener(new AccountPropertyEventHandler(), Account.Event.SET_PROPERTY);
    }

    public static void enableFreeze(long l, int n, int n2) {
        freezeMonitor.enableFreeze(l, n, n2);
    }

    static void checkLiquid(long l) throws NxtException.NotCurrentlyValidException {
        if (freezeMonitor.isFrozen(l)) {
            throw new NxtException.NotCurrentlyValidException("Currency " + Long.toUnsignedString(l) + " is frozen, no transaction is possible.");
        }
    }

    private static class AccountPropertyEventHandler
    implements Listener<Account.AccountProperty> {
        private AccountPropertyEventHandler() {
        }

        @Override
        public void notify(Account.AccountProperty accountProperty) {
            long l;
            int n;
            if (!accountProperty.getProperty().startsWith("Freeze")) {
                return;
            }
            if (accountProperty.getSetterId() != accountProperty.getRecipientId()) {
                return;
            }
            try {
                n = Integer.parseInt(accountProperty.getValue());
                l = Long.parseUnsignedLong(accountProperty.getProperty().substring("Freeze".length()));
            }
            catch (NumberFormatException numberFormatException) {
                Logger.logDebugMessage("Invalid height or currencyId value", numberFormatException);
                return;
            }
            Currency currency = Currency.getCurrency(l);
            if (currency == null || currency.getAccountId() != accountProperty.getSetterId()) {
                return;
            }
            freezeMonitor.scheduleFreeze(l, n);
        }
    }

    private static class CancelOffersBlockHandler
    extends AbstractFreezeBlockHandler {
        private CancelOffersBlockHandler() {
            super(HoldingType.CURRENCY);
        }

        @Override
        protected void handleFreeze(long l) {
            this.cancelOffers(Currency.getCurrency(l));
        }

        private void cancelOffers(Currency currency) {
            ExchangeOfferHome exchangeOfferHome = currency.getChildChain().getExchangeOfferHome();
            try (DbIterator<ExchangeOfferHome.BuyOffer> dbIterator = exchangeOfferHome.getCurrencyBuyOffers(currency.getId(), true, -1, -1);){
                int n = 0;
                for (ExchangeOfferHome.BuyOffer buyOffer : dbIterator) {
                    exchangeOfferHome.removeOffer(null, buyOffer);
                    if (++n % Constants.BATCH_COMMIT_SIZE != 0) continue;
                    Db.db.commitTransaction();
                }
            }
        }
    }
}

