/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.ms.MonetarySystemTransactionType;
import nxt.util.Convert;
import nxt.util.bbh.LengthRwPrimitiveType;
import nxt.util.bbh.StringRw;
import org.json.simple.JSONObject;

public final class CurrencyIssuanceAttachment
extends Attachment.AbstractAttachment {
    public static final StringRw NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 10);
    public static final StringRw CODE_RW = new StringRw(LengthRwPrimitiveType.BYTE, 5);
    public static final StringRw DESCRIPTION_RW = new StringRw(LengthRwPrimitiveType.SHORT, 1000);
    private final String name;
    private final String code;
    private final String description;
    private final byte type;
    private final long initialSupplyQNT;
    private final long reserveSupplyQNT;
    private final long maxSupplyQNT;
    private final int issuanceHeight;
    private final long minReservePerUnitNQT;
    private final int minDifficulty;
    private final int maxDifficulty;
    private final byte ruleset;
    private final byte algorithm;
    private final byte decimals;

    public CurrencyIssuanceAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.name = NAME_RW.readFromBuffer(byteBuffer);
        this.code = CODE_RW.readFromBuffer(byteBuffer);
        this.description = DESCRIPTION_RW.readFromBuffer(byteBuffer);
        this.type = byteBuffer.get();
        this.initialSupplyQNT = byteBuffer.getLong();
        this.reserveSupplyQNT = byteBuffer.getLong();
        this.maxSupplyQNT = byteBuffer.getLong();
        this.issuanceHeight = byteBuffer.getInt();
        this.minReservePerUnitNQT = byteBuffer.getLong();
        this.minDifficulty = byteBuffer.get() & 0xFF;
        this.maxDifficulty = byteBuffer.get() & 0xFF;
        this.ruleset = byteBuffer.get();
        this.algorithm = byteBuffer.get();
        this.decimals = byteBuffer.get();
    }

    public CurrencyIssuanceAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.name = (String)jSONObject.get((Object)"name");
        this.code = (String)jSONObject.get((Object)"code");
        this.description = (String)jSONObject.get((Object)"description");
        this.type = ((Long)jSONObject.get((Object)"type")).byteValue();
        this.initialSupplyQNT = Convert.parseLong(jSONObject.get((Object)"initialSupplyQNT"));
        this.reserveSupplyQNT = Convert.parseLong(jSONObject.get((Object)"reserveSupplyQNT"));
        this.maxSupplyQNT = Convert.parseLong(jSONObject.get((Object)"maxSupplyQNT"));
        this.issuanceHeight = ((Long)jSONObject.get((Object)"issuanceHeight")).intValue();
        this.minReservePerUnitNQT = Convert.parseLong(jSONObject.get((Object)"minReservePerUnitNQT"));
        this.minDifficulty = ((Long)jSONObject.get((Object)"minDifficulty")).intValue();
        this.maxDifficulty = ((Long)jSONObject.get((Object)"maxDifficulty")).intValue();
        this.ruleset = ((Long)jSONObject.get((Object)"ruleset")).byteValue();
        this.algorithm = ((Long)jSONObject.get((Object)"algorithm")).byteValue();
        this.decimals = ((Long)jSONObject.get((Object)"decimals")).byteValue();
    }

    public CurrencyIssuanceAttachment(String string, String string2, String string3, byte by, long l, long l2, long l3, int n, long l4, int n2, int n3, byte by2, byte by3, byte by4) {
        this.name = string;
        this.code = string2;
        this.description = string3;
        this.type = by;
        this.initialSupplyQNT = l;
        this.reserveSupplyQNT = l2;
        this.maxSupplyQNT = l3;
        this.issuanceHeight = n;
        this.minReservePerUnitNQT = l4;
        this.minDifficulty = n2;
        this.maxDifficulty = n3;
        this.ruleset = by2;
        this.algorithm = by3;
        this.decimals = by4;
    }

    @Override
    protected int getMySize() {
        return NAME_RW.getSize(this.name) + CODE_RW.getSize(this.code) + DESCRIPTION_RW.getSize(this.description) + 1 + 8 + 8 + 8 + 4 + 8 + 1 + 1 + 1 + 1 + 1;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        NAME_RW.writeToBuffer(this.name, byteBuffer);
        CODE_RW.writeToBuffer(this.code, byteBuffer);
        DESCRIPTION_RW.writeToBuffer(this.description, byteBuffer);
        byteBuffer.put(this.type);
        byteBuffer.putLong(this.initialSupplyQNT);
        byteBuffer.putLong(this.reserveSupplyQNT);
        byteBuffer.putLong(this.maxSupplyQNT);
        byteBuffer.putInt(this.issuanceHeight);
        byteBuffer.putLong(this.minReservePerUnitNQT);
        byteBuffer.put((byte)this.minDifficulty);
        byteBuffer.put((byte)this.maxDifficulty);
        byteBuffer.put(this.ruleset);
        byteBuffer.put(this.algorithm);
        byteBuffer.put(this.decimals);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"name", (Object)this.name);
        jSONObject.put((Object)"code", (Object)this.code);
        jSONObject.put((Object)"description", (Object)this.description);
        jSONObject.put((Object)"type", (Object)this.type);
        jSONObject.put((Object)"initialSupplyQNT", (Object)this.initialSupplyQNT);
        jSONObject.put((Object)"reserveSupplyQNT", (Object)this.reserveSupplyQNT);
        jSONObject.put((Object)"maxSupplyQNT", (Object)this.maxSupplyQNT);
        jSONObject.put((Object)"issuanceHeight", (Object)this.issuanceHeight);
        jSONObject.put((Object)"minReservePerUnitNQT", (Object)this.minReservePerUnitNQT);
        jSONObject.put((Object)"minDifficulty", (Object)this.minDifficulty);
        jSONObject.put((Object)"maxDifficulty", (Object)this.maxDifficulty);
        jSONObject.put((Object)"ruleset", (Object)this.ruleset);
        jSONObject.put((Object)"algorithm", (Object)this.algorithm);
        jSONObject.put((Object)"decimals", (Object)this.decimals);
    }

    @Override
    public TransactionType getTransactionType() {
        return MonetarySystemTransactionType.CURRENCY_ISSUANCE;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public byte getType() {
        return this.type;
    }

    public long getInitialSupplyQNT() {
        return this.initialSupplyQNT;
    }

    public long getReserveSupplyQNT() {
        return this.reserveSupplyQNT;
    }

    public long getMaxSupplyQNT() {
        return this.maxSupplyQNT;
    }

    public int getIssuanceHeight() {
        return this.issuanceHeight;
    }

    public long getMinReservePerUnitNQT() {
        return this.minReservePerUnitNQT;
    }

    public int getMinDifficulty() {
        return this.minDifficulty;
    }

    public int getMaxDifficulty() {
        return this.maxDifficulty;
    }

    public byte getRuleset() {
        return this.ruleset;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public byte getDecimals() {
        return this.decimals;
    }
}

