/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.ms.MonetarySystemAttachment;
import nxt.ms.MonetarySystemTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class CurrencyMintingAttachment
extends Attachment.AbstractAttachment
implements MonetarySystemAttachment {
    private final long nonce;
    private final long currencyId;
    private final long unitsQNT;
    private final long counter;

    public CurrencyMintingAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.nonce = byteBuffer.getLong();
        this.currencyId = byteBuffer.getLong();
        this.unitsQNT = byteBuffer.getLong();
        this.counter = byteBuffer.getLong();
    }

    public CurrencyMintingAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.nonce = Convert.parseLong(jSONObject.get((Object)"nonce"));
        this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"currency"));
        this.unitsQNT = Convert.parseLong(jSONObject.get((Object)"unitsQNT"));
        this.counter = Convert.parseLong(jSONObject.get((Object)"counter"));
    }

    public CurrencyMintingAttachment(long l, long l2, long l3, long l4) {
        this.nonce = l;
        this.currencyId = l2;
        this.unitsQNT = l3;
        this.counter = l4;
    }

    @Override
    protected int getMySize() {
        return 32;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.nonce);
        byteBuffer.putLong(this.currencyId);
        byteBuffer.putLong(this.unitsQNT);
        byteBuffer.putLong(this.counter);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"nonce", (Object)this.nonce);
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(this.currencyId));
        jSONObject.put((Object)"unitsQNT", (Object)this.unitsQNT);
        jSONObject.put((Object)"counter", (Object)this.counter);
    }

    @Override
    public TransactionType getTransactionType() {
        return MonetarySystemTransactionType.CURRENCY_MINTING;
    }

    public long getNonce() {
        return this.nonce;
    }

    @Override
    public long getCurrencyId() {
        return this.currencyId;
    }

    public long getUnitsQNT() {
        return this.unitsQNT;
    }

    public long getCounter() {
        return this.counter;
    }
}

