/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import nxt.Nxt;
import nxt.blockchain.Block;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.EntityDbTable;
import nxt.ms.ExchangeOfferHome;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class ExchangeHome {
    private static final Listeners<Exchange, Event> listeners = new Listeners();
    private final ChildChain childChain;
    private final DbKey.HashHashKeyFactory<Exchange> exchangeDbKeyFactory;
    private final EntityDbTable<Exchange> exchangeTable;

    public static ExchangeHome forChain(ChildChain childChain) {
        if (childChain.getExchangeHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new ExchangeHome(childChain);
    }

    public static boolean addListener(Listener<Exchange> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Exchange> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    private ExchangeHome(ChildChain childChain) {
        this.childChain = childChain;
        this.exchangeDbKeyFactory = new DbKey.HashHashKeyFactory<Exchange>("transaction_full_hash", "transaction_id", "offer_full_hash", "offer_id"){

            @Override
            public DbKey newKey(Exchange exchange) {
                return exchange.dbKey;
            }
        };
        this.exchangeTable = new EntityDbTable<Exchange>(childChain.getSchemaTable("exchange"), this.exchangeDbKeyFactory){

            @Override
            protected Exchange load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Exchange(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Exchange exchange) throws SQLException {
                exchange.save(connection);
            }
        };
    }

    public DbIterator<Exchange> getAllExchanges(int n, int n2) {
        return this.exchangeTable.getAll(n, n2);
    }

    public int getCount() {
        return this.exchangeTable.getCount();
    }

    public DbIterator<Exchange> getCurrencyExchanges(long l, int n, int n2) {
        return this.exchangeTable.getManyBy(new DbClause.LongClause("currency_id", l), n, n2);
    }

    /*
     * Exception decompiling
     */
    public List<Exchange> getLastExchanges(long[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DbIterator<Exchange> getAccountExchanges(long l, int n, int n2) {
        Connection connection = null;
        try {
            connection = this.exchangeTable.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM exchange WHERE seller_id = ? UNION ALL SELECT * FROM exchange WHERE buyer_id = ? AND seller_id <> ? ORDER BY height DESC, db_id DESC" + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return this.exchangeTable.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public DbIterator<Exchange> getAccountCurrencyExchanges(long l, long l2, int n, int n2) {
        Connection connection = null;
        try {
            connection = this.exchangeTable.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM exchange WHERE seller_id = ? AND currency_id = ? UNION ALL SELECT * FROM exchange WHERE buyer_id = ? AND seller_id <> ? AND currency_id = ? ORDER BY height DESC, db_id DESC" + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l2);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l2);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return this.exchangeTable.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public DbIterator<Exchange> getExchanges(long l) {
        return this.exchangeTable.getManyBy(new DbClause.LongClause("transaction_id", l), 0, -1);
    }

    public DbIterator<Exchange> getOfferExchanges(long l, int n, int n2) {
        return this.exchangeTable.getManyBy(new DbClause.LongClause("offer_id", l), n, n2);
    }

    public int getExchangeCount(long l) {
        return this.exchangeTable.getCount(new DbClause.LongClause("currency_id", l));
    }

    Exchange addExchange(Transaction transaction, long l, ExchangeOfferHome.ExchangeOffer exchangeOffer, long l2, long l3, long l4) {
        Exchange exchange = new Exchange(transaction.getId(), transaction.getFullHash(), l, exchangeOffer, l2, l3, l4);
        this.exchangeTable.insert(exchange);
        listeners.notify(exchange, Event.EXCHANGE);
        return exchange;
    }

    public final class Exchange {
        private final long transactionId;
        private final byte[] transactionHash;
        private final int timestamp;
        private final long currencyId;
        private final long blockId;
        private final int height;
        private final long offerId;
        private final byte[] offerHash;
        private final long sellerId;
        private final long buyerId;
        private final DbKey dbKey;
        private final long unitsQNT;
        private final long rateNQT;

        private Exchange(long l, byte[] byArray, long l2, ExchangeOfferHome.ExchangeOffer exchangeOffer, long l3, long l4, long l5) {
            Block block = Nxt.getBlockchain().getLastBlock();
            this.transactionId = l;
            this.transactionHash = byArray;
            this.blockId = block.getId();
            this.height = block.getHeight();
            this.currencyId = l2;
            this.timestamp = block.getTimestamp();
            this.offerId = exchangeOffer.getId();
            this.offerHash = exchangeOffer.getFullHash();
            this.sellerId = l3;
            this.buyerId = l4;
            this.dbKey = ExchangeHome.this.exchangeDbKeyFactory.newKey(this.transactionHash, this.transactionId, this.offerHash, this.offerId);
            this.unitsQNT = l5;
            this.rateNQT = exchangeOffer.getRateNQT();
        }

        private Exchange(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.transactionId = resultSet.getLong("transaction_id");
            this.transactionHash = resultSet.getBytes("transaction_full_hash");
            this.currencyId = resultSet.getLong("currency_id");
            this.blockId = resultSet.getLong("block_id");
            this.offerId = resultSet.getLong("offer_id");
            this.offerHash = resultSet.getBytes("offer_full_hash");
            this.sellerId = resultSet.getLong("seller_id");
            this.buyerId = resultSet.getLong("buyer_id");
            this.dbKey = dbKey;
            this.unitsQNT = resultSet.getLong("units");
            this.rateNQT = resultSet.getLong("rate");
            this.timestamp = resultSet.getInt("timestamp");
            this.height = resultSet.getInt("height");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO exchange (transaction_id, transaction_full_hash, currency_id, block_id, offer_id, offer_full_hash, seller_id, buyer_id, units, rate, timestamp, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.transactionId);
                preparedStatement.setBytes(++n, this.transactionHash);
                preparedStatement.setLong(++n, this.currencyId);
                preparedStatement.setLong(++n, this.blockId);
                preparedStatement.setLong(++n, this.offerId);
                preparedStatement.setBytes(++n, this.offerHash);
                preparedStatement.setLong(++n, this.sellerId);
                preparedStatement.setLong(++n, this.buyerId);
                preparedStatement.setLong(++n, this.unitsQNT);
                preparedStatement.setLong(++n, this.rateNQT);
                preparedStatement.setInt(++n, this.timestamp);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.executeUpdate();
            }
        }

        public long getTransactionId() {
            return this.transactionId;
        }

        public byte[] getTransactionFullHash() {
            return this.transactionHash;
        }

        public long getBlockId() {
            return this.blockId;
        }

        public long getOfferId() {
            return this.offerId;
        }

        public byte[] getOfferFullHash() {
            return this.offerHash;
        }

        public long getSellerId() {
            return this.sellerId;
        }

        public long getBuyerId() {
            return this.buyerId;
        }

        public long getUnitsQNT() {
            return this.unitsQNT;
        }

        public long getRateNQT() {
            return this.rateNQT;
        }

        public long getCurrencyId() {
            return this.currencyId;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public int getHeight() {
            return this.height;
        }

        public ChildChain getChildChain() {
            return ExchangeHome.this.childChain;
        }

        public String toString() {
            return "Exchange currency: " + Long.toUnsignedString(this.currencyId) + " offer: " + Long.toUnsignedString(this.offerId) + " rate: " + this.rateNQT + " units: " + this.unitsQNT + " height: " + this.height + " transaction: " + Long.toUnsignedString(this.transactionId);
        }
    }

    public static enum Event {
        EXCHANGE;

    }
}

