/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nxt.Nxt;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;
import nxt.ms.Currency;
import nxt.ms.ExchangeHome;
import nxt.ms.PublishExchangeOfferAttachment;
import nxt.util.Convert;

public final class ExchangeOfferHome {
    private final ChildChain childChain;
    private final ExchangeHome exchangeHome;
    private final DbKey.LongKeyFactory<BuyOffer> buyOfferDbKeyFactory;
    private final VersionedEntityDbTable<BuyOffer> buyOfferTable;
    private final DbKey.LongKeyFactory<SellOffer> sellOfferDbKeyFactory;
    private final VersionedEntityDbTable<SellOffer> sellOfferTable;
    private static final DbClause availableOnlyDbClause = new DbClause.LongClause("unit_limit", DbClause.Op.NE, 0L).and(new DbClause.LongClause("supply", DbClause.Op.NE, 0L));

    public static ExchangeOfferHome forChain(ChildChain childChain) {
        if (childChain.getExchangeOfferHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new ExchangeOfferHome(childChain);
    }

    private ExchangeOfferHome(ChildChain childChain) {
        this.childChain = childChain;
        this.exchangeHome = childChain.getExchangeHome();
        this.buyOfferDbKeyFactory = new DbKey.LongKeyFactory<BuyOffer>("id"){

            @Override
            public DbKey newKey(BuyOffer buyOffer) {
                return buyOffer.dbKey;
            }
        };
        this.buyOfferTable = new VersionedEntityDbTable<BuyOffer>(childChain.getSchemaTable("buy_offer"), this.buyOfferDbKeyFactory){

            @Override
            protected BuyOffer load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new BuyOffer(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, BuyOffer buyOffer) throws SQLException {
                buyOffer.save(connection, this.schemaTable);
            }
        };
        this.sellOfferDbKeyFactory = new DbKey.LongKeyFactory<SellOffer>("id"){

            @Override
            public DbKey newKey(SellOffer sellOffer) {
                return sellOffer.dbKey;
            }
        };
        this.sellOfferTable = new VersionedEntityDbTable<SellOffer>(childChain.getSchemaTable("sell_offer"), this.sellOfferDbKeyFactory){

            @Override
            protected SellOffer load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new SellOffer(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, SellOffer sellOffer) throws SQLException {
                sellOffer.save(connection, this.schemaTable);
            }
        };
        Nxt.getBlockchainProcessor().addListener(block -> {
            ArrayList<BuyOffer> arrayList = new ArrayList<BuyOffer>();
            try (DbIterator<BuyOffer> dbIterator = this.getBuyOffers(new DbClause.IntClause("expiration_height", block.getHeight()), 0, -1);){
                for (BuyOffer buyOffer2 : dbIterator) {
                    arrayList.add(buyOffer2);
                }
            }
            arrayList.forEach(buyOffer -> this.removeOffer(AccountLedger.LedgerEvent.CURRENCY_OFFER_EXPIRED, (BuyOffer)buyOffer));
        }, BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
    }

    void publishOffer(Transaction transaction, PublishExchangeOfferAttachment publishExchangeOfferAttachment) {
        BuyOffer buyOffer = this.getBuyOffer(publishExchangeOfferAttachment.getCurrencyId(), transaction.getSenderId());
        if (buyOffer != null) {
            this.removeOffer(AccountLedger.LedgerEvent.CURRENCY_OFFER_REPLACED, buyOffer);
        }
        this.addBuyOffer(transaction, publishExchangeOfferAttachment);
        this.addSellOffer(transaction, publishExchangeOfferAttachment);
    }

    private AvailableOffers calculateTotal(long l, List<? extends ExchangeOffer> list, long l2) {
        Currency currency = Currency.getCurrency(l);
        long l3 = 0L;
        long l4 = l2;
        long l5 = 0L;
        for (ExchangeOffer exchangeOffer : list) {
            if (l4 == 0L) break;
            l5 = exchangeOffer.getRateNQT();
            long l6 = Math.min(Math.min(l4, exchangeOffer.getSupplyQNT()), exchangeOffer.getLimitQNT());
            long l7 = Convert.unitRateToAmount(l6, currency.getDecimals(), l5, this.childChain.getDecimals());
            l3 = Math.addExact(l3, l7);
            l4 = Math.subtractExact(l4, l6);
        }
        return new AvailableOffers(l5, Math.subtractExact(l2, l4), l3);
    }

    public AvailableOffers getAvailableToSell(long l, long l2) {
        return this.calculateTotal(l, this.getAvailableBuyOffers(l, 0L), l2);
    }

    private List<BuyOffer> getAvailableBuyOffers(long l, long l2) {
        ArrayList<BuyOffer> arrayList = new ArrayList<BuyOffer>();
        DbClause dbClause = new DbClause.LongClause("currency_id", l).and(availableOnlyDbClause);
        if (l2 > 0L) {
            dbClause = dbClause.and(new DbClause.LongClause("rate", DbClause.Op.GTE, l2));
        }
        try (DbIterator<BuyOffer> dbIterator = this.getBuyOffers(dbClause, 0, -1, " ORDER BY rate DESC, creation_height ASC, transaction_height ASC, transaction_index ASC ");){
            for (BuyOffer buyOffer : dbIterator) {
                arrayList.add(buyOffer);
            }
        }
        return arrayList;
    }

    void exchangeCurrencyForNXT(Transaction transaction, Account account, long l, long l2, long l3) {
        List<BuyOffer> list = this.getAvailableBuyOffers(l, l2);
        Currency currency = Currency.getCurrency(l);
        long l4 = 0L;
        long l5 = l3;
        for (BuyOffer buyOffer : list) {
            if (l5 == 0L) break;
            long l6 = Math.min(Math.min(l5, buyOffer.getSupplyQNT()), buyOffer.getLimitQNT());
            long l7 = Convert.unitRateToAmount(l6, currency.getDecimals(), buyOffer.getRateNQT(), this.childChain.getDecimals());
            l4 = Math.addExact(l4, l7);
            l5 = Math.subtractExact(l5, l6);
            long l8 = buyOffer.decreaseLimitAndSupply(l6, l7);
            long l9 = buyOffer.getCounterOffer().increaseSupply(l6);
            Account account2 = Account.getAccount(buyOffer.getAccountId());
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(buyOffer.getId(), buyOffer.getFullHash(), this.childChain);
            if (l8 != 0L) {
                account2.addToUnconfirmedBalance(this.childChain, AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, -l8);
            }
            account2.addToBalance(this.childChain, AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, -l7);
            account2.addToCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, l, l6);
            account2.addToUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, l, l9);
            this.exchangeHome.addExchange(transaction, l, buyOffer, account.getId(), buyOffer.getAccountId(), l6);
        }
        AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(transaction);
        account.addToBalanceAndUnconfirmedBalance(this.childChain, AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, l4);
        account.addToCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, l, -(l3 - l5));
        account.addToUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, l, l5);
    }

    public AvailableOffers getAvailableToBuy(long l, long l2) {
        return this.calculateTotal(l, this.getAvailableSellOffers(l, 0L), l2);
    }

    private List<SellOffer> getAvailableSellOffers(long l, long l2) {
        ArrayList<SellOffer> arrayList = new ArrayList<SellOffer>();
        DbClause dbClause = new DbClause.LongClause("currency_id", l).and(availableOnlyDbClause);
        if (l2 > 0L) {
            dbClause = dbClause.and(new DbClause.LongClause("rate", DbClause.Op.LTE, l2));
        }
        try (DbIterator<SellOffer> dbIterator = this.getSellOffers(dbClause, 0, -1, " ORDER BY rate ASC, creation_height ASC, transaction_height ASC, transaction_index ASC ");){
            for (SellOffer sellOffer : dbIterator) {
                arrayList.add(sellOffer);
            }
        }
        return arrayList;
    }

    void exchangeNXTForCurrency(Transaction transaction, Account account, long l, long l2, long l3) {
        List<SellOffer> list = this.getAvailableSellOffers(l, l2);
        Currency currency = Currency.getCurrency(l);
        long l4 = 0L;
        long l5 = l3;
        long l6 = Convert.unitRateToAmount(l3, currency.getDecimals(), l2, this.childChain.getDecimals());
        for (SellOffer sellOffer : list) {
            if (l5 == 0L) break;
            long l7 = Math.min(Math.min(l5, sellOffer.getSupplyQNT()), sellOffer.getLimitQNT());
            long l8 = Convert.unitRateToAmount(l7, currency.getDecimals(), sellOffer.getRateNQT(), this.childChain.getDecimals());
            l4 = Math.addExact(l4, l8);
            l5 = Math.subtractExact(l5, l7);
            sellOffer.decreaseLimitAndSupply(l7);
            BuyOffer buyOffer = sellOffer.getCounterOffer();
            long l9 = buyOffer.getAmountNQT();
            buyOffer.increaseSupply(l7);
            Account account2 = Account.getAccount(sellOffer.getAccountId());
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(sellOffer.getId(), sellOffer.getFullHash(), this.childChain);
            account2.addToBalance(this.childChain, AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, l8);
            account2.addToUnconfirmedBalance(this.childChain, AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, Math.addExact(l8, l9 - buyOffer.getAmountNQT()));
            account2.addToCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, l, -l7);
            this.exchangeHome.addExchange(transaction, l, sellOffer, sellOffer.getAccountId(), account.getId(), l7);
        }
        AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(transaction);
        account.addToCurrencyAndUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, l, Math.subtractExact(l3, l5));
        account.addToBalance(this.childChain, AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, -l4);
        account.addToUnconfirmedBalance(this.childChain, AccountLedger.LedgerEvent.CURRENCY_EXCHANGE, ledgerEventId, l6 - l4);
    }

    public void removeOffer(AccountLedger.LedgerEvent ledgerEvent, BuyOffer buyOffer) {
        SellOffer sellOffer = buyOffer.getCounterOffer();
        this.removeBuyOffer(buyOffer);
        this.removeSellOffer(sellOffer);
        Account account = Account.getAccount(buyOffer.getAccountId());
        AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(buyOffer.getId(), buyOffer.getFullHash(), this.childChain);
        if (buyOffer.getAmountNQT() != 0L) {
            account.addToUnconfirmedBalance(this.childChain, ledgerEvent, ledgerEventId, buyOffer.getAmountNQT());
        }
        if (sellOffer.getSupplyQNT() != 0L) {
            account.addToUnconfirmedCurrencyUnits(ledgerEvent, ledgerEventId, buyOffer.getCurrencyId(), sellOffer.getSupplyQNT());
        }
    }

    public int getBuyOfferCount() {
        return this.buyOfferTable.getCount();
    }

    public BuyOffer getBuyOffer(long l) {
        return (BuyOffer)this.buyOfferTable.get(this.buyOfferDbKeyFactory.newKey(l));
    }

    public DbIterator<BuyOffer> getAllBuyOffers(int n, int n2) {
        return this.buyOfferTable.getAll(n, n2);
    }

    public DbIterator<BuyOffer> getBuyOffers(Currency currency, int n, int n2) {
        return this.getCurrencyBuyOffers(currency.getId(), false, n, n2);
    }

    public DbIterator<BuyOffer> getCurrencyBuyOffers(long l, boolean bl, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("currency_id", l);
        if (bl) {
            dbClause = dbClause.and(availableOnlyDbClause);
        }
        return this.buyOfferTable.getManyBy(dbClause, n, n2, " ORDER BY rate DESC, creation_height ASC, transaction_height ASC, transaction_index ASC ");
    }

    public DbIterator<BuyOffer> getAccountBuyOffers(long l, boolean bl, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("account_id", l);
        if (bl) {
            dbClause = dbClause.and(availableOnlyDbClause);
        }
        return this.buyOfferTable.getManyBy(dbClause, n, n2, " ORDER BY rate DESC, creation_height ASC, transaction_height ASC, transaction_index ASC ");
    }

    public BuyOffer getBuyOffer(Currency currency, Account account) {
        return this.getBuyOffer(currency.getId(), account.getId());
    }

    public BuyOffer getBuyOffer(long l, long l2) {
        return (BuyOffer)this.buyOfferTable.getBy(new DbClause.LongClause("currency_id", l).and(new DbClause.LongClause("account_id", l2)));
    }

    public DbIterator<BuyOffer> getBuyOffers(DbClause dbClause, int n, int n2) {
        return this.buyOfferTable.getManyBy(dbClause, n, n2);
    }

    public DbIterator<BuyOffer> getBuyOffers(DbClause dbClause, int n, int n2, String string) {
        return this.buyOfferTable.getManyBy(dbClause, n, n2, string);
    }

    private void addBuyOffer(Transaction transaction, PublishExchangeOfferAttachment publishExchangeOfferAttachment) {
        this.buyOfferTable.insert(new BuyOffer(transaction, publishExchangeOfferAttachment));
    }

    private void removeBuyOffer(BuyOffer buyOffer) {
        this.buyOfferTable.delete(buyOffer);
    }

    public int getSellOfferCount() {
        return this.sellOfferTable.getCount();
    }

    public SellOffer getSellOffer(long l) {
        return (SellOffer)this.sellOfferTable.get(this.sellOfferDbKeyFactory.newKey(l));
    }

    public DbIterator<SellOffer> getAllSellOffers(int n, int n2) {
        return this.sellOfferTable.getAll(n, n2);
    }

    public DbIterator<SellOffer> getSellOffers(Currency currency, int n, int n2) {
        return this.getCurrencySellOffers(currency.getId(), false, n, n2);
    }

    public DbIterator<SellOffer> getCurrencySellOffers(long l, boolean bl, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("currency_id", l);
        if (bl) {
            dbClause = dbClause.and(availableOnlyDbClause);
        }
        return this.sellOfferTable.getManyBy(dbClause, n, n2, " ORDER BY rate ASC, creation_height ASC, transaction_height ASC, transaction_index ASC ");
    }

    public DbIterator<SellOffer> getAccountSellOffers(long l, boolean bl, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("account_id", l);
        if (bl) {
            dbClause = dbClause.and(availableOnlyDbClause);
        }
        return this.sellOfferTable.getManyBy(dbClause, n, n2, " ORDER BY rate ASC, creation_height ASC, transaction_height ASC, transaction_index ASC ");
    }

    public SellOffer getSellOffer(Currency currency, Account account) {
        return this.getSellOffer(currency.getId(), account.getId());
    }

    public SellOffer getSellOffer(long l, long l2) {
        return (SellOffer)this.sellOfferTable.getBy(new DbClause.LongClause("currency_id", l).and(new DbClause.LongClause("account_id", l2)));
    }

    public DbIterator<SellOffer> getSellOffers(DbClause dbClause, int n, int n2) {
        return this.sellOfferTable.getManyBy(dbClause, n, n2);
    }

    public DbIterator<SellOffer> getSellOffers(DbClause dbClause, int n, int n2, String string) {
        return this.sellOfferTable.getManyBy(dbClause, n, n2, string);
    }

    private void addSellOffer(Transaction transaction, PublishExchangeOfferAttachment publishExchangeOfferAttachment) {
        this.sellOfferTable.insert(new SellOffer(transaction, publishExchangeOfferAttachment));
    }

    private void removeSellOffer(SellOffer sellOffer) {
        this.sellOfferTable.delete(sellOffer);
    }

    public final class SellOffer
    extends ExchangeOffer {
        private final DbKey dbKey;

        private SellOffer(Transaction transaction, PublishExchangeOfferAttachment publishExchangeOfferAttachment) {
            super(transaction.getId(), transaction.getFullHash(), publishExchangeOfferAttachment.getCurrencyId(), transaction.getSenderId(), publishExchangeOfferAttachment.getSellRateNQT(), publishExchangeOfferAttachment.getTotalSellLimitQNT(), publishExchangeOfferAttachment.getInitialSellSupplyQNT(), publishExchangeOfferAttachment.getExpirationHeight(), transaction.getHeight(), transaction.getIndex());
            this.dbKey = ExchangeOfferHome.this.sellOfferDbKeyFactory.newKey(this.id);
        }

        private SellOffer(ResultSet resultSet, DbKey dbKey) throws SQLException {
            super(resultSet);
            this.dbKey = dbKey;
        }

        void save(Connection connection, String string) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO " + string + " (id, full_hash, currency_id, account_id, rate, unit_limit, supply, expiration_height, creation_height, transaction_index, transaction_height, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.getId());
                preparedStatement.setBytes(++n, this.getFullHash());
                preparedStatement.setLong(++n, this.getCurrencyId());
                preparedStatement.setLong(++n, this.getAccountId());
                preparedStatement.setLong(++n, this.getRateNQT());
                preparedStatement.setLong(++n, this.getLimitQNT());
                preparedStatement.setLong(++n, this.getSupplyQNT());
                preparedStatement.setInt(++n, this.getExpirationHeight());
                preparedStatement.setInt(++n, this.getHeight());
                preparedStatement.setShort(++n, this.getTransactionIndex());
                preparedStatement.setInt(++n, this.getTransactionHeight());
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        @Override
        public BuyOffer getCounterOffer() {
            return ExchangeOfferHome.this.getBuyOffer(this.id);
        }

        @Override
        long increaseSupply(long l) {
            long l2 = super.increaseSupply(l);
            ExchangeOfferHome.this.sellOfferTable.insert(this);
            return l2;
        }

        @Override
        void decreaseLimitAndSupply(long l) {
            super.decreaseLimitAndSupply(l);
            ExchangeOfferHome.this.sellOfferTable.insert(this);
        }
    }

    public final class BuyOffer
    extends ExchangeOffer {
        private final DbKey dbKey;
        private long amountNQT;

        private BuyOffer(Transaction transaction, PublishExchangeOfferAttachment publishExchangeOfferAttachment) {
            super(transaction.getId(), transaction.getFullHash(), publishExchangeOfferAttachment.getCurrencyId(), transaction.getSenderId(), publishExchangeOfferAttachment.getBuyRateNQT(), publishExchangeOfferAttachment.getTotalBuyLimitQNT(), publishExchangeOfferAttachment.getInitialBuySupplyQNT(), publishExchangeOfferAttachment.getExpirationHeight(), transaction.getHeight(), transaction.getIndex());
            this.dbKey = ExchangeOfferHome.this.buyOfferDbKeyFactory.newKey(this.id);
            Currency currency = Currency.getCurrency(publishExchangeOfferAttachment.getCurrencyId());
            this.amountNQT = Convert.unitRateToAmount(publishExchangeOfferAttachment.getInitialBuySupplyQNT(), currency.getDecimals(), publishExchangeOfferAttachment.getBuyRateNQT(), ExchangeOfferHome.this.childChain.getDecimals());
        }

        private BuyOffer(ResultSet resultSet, DbKey dbKey) throws SQLException {
            super(resultSet);
            this.amountNQT = resultSet.getLong("amount");
            this.dbKey = dbKey;
        }

        void save(Connection connection, String string) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO " + string + " (id, full_hash, currency_id, account_id, rate, unit_limit, supply, amount, expiration_height, creation_height, transaction_index, transaction_height, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.getId());
                preparedStatement.setBytes(++n, this.getFullHash());
                preparedStatement.setLong(++n, this.getCurrencyId());
                preparedStatement.setLong(++n, this.getAccountId());
                preparedStatement.setLong(++n, this.getRateNQT());
                preparedStatement.setLong(++n, this.getLimitQNT());
                preparedStatement.setLong(++n, this.getSupplyQNT());
                preparedStatement.setLong(++n, this.amountNQT);
                preparedStatement.setInt(++n, this.getExpirationHeight());
                preparedStatement.setInt(++n, this.getHeight());
                preparedStatement.setShort(++n, this.getTransactionIndex());
                preparedStatement.setInt(++n, this.getTransactionHeight());
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        @Override
        public SellOffer getCounterOffer() {
            return ExchangeOfferHome.this.getSellOffer(this.id);
        }

        @Override
        long increaseSupply(long l) {
            long l2 = super.increaseSupply(l);
            Currency currency = Currency.getCurrency(this.getCurrencyId());
            this.amountNQT = Convert.unitRateToAmount(this.getSupplyQNT(), currency.getDecimals(), this.getRateNQT(), ExchangeOfferHome.this.childChain.getDecimals());
            ExchangeOfferHome.this.buyOfferTable.insert(this);
            return l2;
        }

        long decreaseLimitAndSupply(long l, long l2) {
            super.decreaseLimitAndSupply(l);
            long l3 = Math.max(l2 - this.amountNQT, 0L);
            this.amountNQT -= l2 - l3;
            ExchangeOfferHome.this.buyOfferTable.insert(this);
            return l3;
        }

        long getAmountNQT() {
            return this.amountNQT;
        }
    }

    public abstract class ExchangeOffer {
        final long id;
        private final byte[] hash;
        private final long currencyId;
        private final long accountId;
        private final long rateNQT;
        private long limitQNT;
        private long supplyQNT;
        private final int expirationHeight;
        private final int creationHeight;
        private final short transactionIndex;
        private final int transactionHeight;

        ExchangeOffer(long l, byte[] byArray, long l2, long l3, long l4, long l5, long l6, int n, int n2, short s) {
            this.id = l;
            this.hash = byArray;
            this.currencyId = l2;
            this.accountId = l3;
            this.rateNQT = l4;
            this.limitQNT = l5;
            this.supplyQNT = l6;
            this.expirationHeight = n;
            this.creationHeight = Nxt.getBlockchain().getHeight();
            this.transactionIndex = s;
            this.transactionHeight = n2;
        }

        ExchangeOffer(ResultSet resultSet) throws SQLException {
            this.id = resultSet.getLong("id");
            this.hash = resultSet.getBytes("full_hash");
            this.currencyId = resultSet.getLong("currency_id");
            this.accountId = resultSet.getLong("account_id");
            this.rateNQT = resultSet.getLong("rate");
            this.limitQNT = resultSet.getLong("unit_limit");
            this.supplyQNT = resultSet.getLong("supply");
            this.expirationHeight = resultSet.getInt("expiration_height");
            this.creationHeight = resultSet.getInt("creation_height");
            this.transactionIndex = resultSet.getShort("transaction_index");
            this.transactionHeight = resultSet.getInt("transaction_height");
        }

        public long getId() {
            return this.id;
        }

        public byte[] getFullHash() {
            return this.hash;
        }

        public long getCurrencyId() {
            return this.currencyId;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public long getRateNQT() {
            return this.rateNQT;
        }

        public long getLimitQNT() {
            return this.limitQNT;
        }

        public long getSupplyQNT() {
            return this.supplyQNT;
        }

        public int getExpirationHeight() {
            return this.expirationHeight;
        }

        public int getHeight() {
            return this.creationHeight;
        }

        public short getTransactionIndex() {
            return this.transactionIndex;
        }

        public int getTransactionHeight() {
            return this.transactionHeight;
        }

        public abstract ExchangeOffer getCounterOffer();

        public ChildChain getChildChain() {
            return ExchangeOfferHome.this.childChain;
        }

        long increaseSupply(long l) {
            long l2 = Math.max(Math.addExact(this.supplyQNT, Math.subtractExact(l, this.limitQNT)), 0L);
            this.supplyQNT += l - l2;
            return l2;
        }

        void decreaseLimitAndSupply(long l) {
            this.limitQNT -= l;
            this.supplyQNT -= l;
        }
    }

    public static final class AvailableOffers {
        private final long rateNQT;
        private final long unitsQNT;
        private final long amountNQT;

        private AvailableOffers(long l, long l2, long l3) {
            this.rateNQT = l;
            this.unitsQNT = l2;
            this.amountNQT = l3;
        }

        public long getRateNQT() {
            return this.rateNQT;
        }

        public long getUnitsQNT() {
            return this.unitsQNT;
        }

        public long getAmountNQT() {
            return this.amountNQT;
        }
    }
}

