/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Nxt;
import nxt.blockchain.Block;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.EntityDbTable;
import nxt.ms.ExchangeAttachment;
import nxt.ms.ExchangeBuyAttachment;
import nxt.ms.ExchangeSellAttachment;

public final class ExchangeRequestHome {
    private final ChildChain childChain;
    private final DbKey.HashKeyFactory<ExchangeRequest> exchangeRequestDbKeyFactory;
    private final EntityDbTable<ExchangeRequest> exchangeRequestTable;

    public static ExchangeRequestHome forChain(ChildChain childChain) {
        if (childChain.getExchangeRequestHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new ExchangeRequestHome(childChain);
    }

    private ExchangeRequestHome(ChildChain childChain) {
        this.childChain = childChain;
        this.exchangeRequestDbKeyFactory = new DbKey.HashKeyFactory<ExchangeRequest>("full_hash", "id"){

            @Override
            public DbKey newKey(ExchangeRequest exchangeRequest) {
                return exchangeRequest.dbKey;
            }
        };
        this.exchangeRequestTable = new EntityDbTable<ExchangeRequest>(childChain.getSchemaTable("exchange_request"), this.exchangeRequestDbKeyFactory){

            @Override
            protected ExchangeRequest load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new ExchangeRequest(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, ExchangeRequest exchangeRequest) throws SQLException {
                exchangeRequest.save(connection);
            }
        };
    }

    public DbIterator<ExchangeRequest> getAllExchangeRequests(int n, int n2) {
        return this.exchangeRequestTable.getAll(n, n2);
    }

    public int getCount() {
        return this.exchangeRequestTable.getCount();
    }

    public DbIterator<ExchangeRequest> getCurrencyExchangeRequests(long l, int n, int n2) {
        return this.exchangeRequestTable.getManyBy(new DbClause.LongClause("currency_id", l), n, n2);
    }

    public DbIterator<ExchangeRequest> getAccountExchangeRequests(long l, int n, int n2) {
        return this.exchangeRequestTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
    }

    public DbIterator<ExchangeRequest> getAccountCurrencyExchangeRequests(long l, long l2, int n, int n2) {
        return this.exchangeRequestTable.getManyBy(new DbClause.LongClause("account_id", l).and(new DbClause.LongClause("currency_id", l2)), n, n2);
    }

    void addExchangeRequest(Transaction transaction, ExchangeBuyAttachment exchangeBuyAttachment) {
        ExchangeRequest exchangeRequest = new ExchangeRequest(transaction, exchangeBuyAttachment);
        this.exchangeRequestTable.insert(exchangeRequest);
    }

    void addExchangeRequest(Transaction transaction, ExchangeSellAttachment exchangeSellAttachment) {
        ExchangeRequest exchangeRequest = new ExchangeRequest(transaction, exchangeSellAttachment);
        this.exchangeRequestTable.insert(exchangeRequest);
    }

    public final class ExchangeRequest {
        private final long id;
        private final byte[] hash;
        private final long accountId;
        private final long currencyId;
        private final int height;
        private final int timestamp;
        private final DbKey dbKey;
        private final long unitsQNT;
        private final long rateNQT;
        private final boolean isBuy;

        private ExchangeRequest(Transaction transaction, ExchangeBuyAttachment exchangeBuyAttachment) {
            this(transaction, (ExchangeAttachment)exchangeBuyAttachment, true);
        }

        private ExchangeRequest(Transaction transaction, ExchangeSellAttachment exchangeSellAttachment) {
            this(transaction, (ExchangeAttachment)exchangeSellAttachment, false);
        }

        private ExchangeRequest(Transaction transaction, ExchangeAttachment exchangeAttachment, boolean bl) {
            this.id = transaction.getId();
            this.hash = transaction.getFullHash();
            this.dbKey = ExchangeRequestHome.this.exchangeRequestDbKeyFactory.newKey(this.hash, this.id);
            this.accountId = transaction.getSenderId();
            this.currencyId = exchangeAttachment.getCurrencyId();
            this.unitsQNT = exchangeAttachment.getUnitsQNT();
            this.rateNQT = exchangeAttachment.getRateNQT();
            this.isBuy = bl;
            Block block = Nxt.getBlockchain().getLastBlock();
            this.height = block.getHeight();
            this.timestamp = block.getTimestamp();
        }

        private ExchangeRequest(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.hash = resultSet.getBytes("full_hash");
            this.dbKey = dbKey;
            this.accountId = resultSet.getLong("account_id");
            this.currencyId = resultSet.getLong("currency_id");
            this.unitsQNT = resultSet.getLong("units");
            this.rateNQT = resultSet.getLong("rate");
            this.isBuy = resultSet.getBoolean("is_buy");
            this.timestamp = resultSet.getInt("timestamp");
            this.height = resultSet.getInt("height");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO exchange_request (id, full_hash, account_id, currency_id, units, rate, is_buy, timestamp, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setBytes(++n, this.hash);
                preparedStatement.setLong(++n, this.accountId);
                preparedStatement.setLong(++n, this.currencyId);
                preparedStatement.setLong(++n, this.unitsQNT);
                preparedStatement.setLong(++n, this.rateNQT);
                preparedStatement.setBoolean(++n, this.isBuy);
                preparedStatement.setInt(++n, this.timestamp);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.id;
        }

        public byte[] getFullHash() {
            return this.hash;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public long getCurrencyId() {
            return this.currencyId;
        }

        public long getUnitsQNT() {
            return this.unitsQNT;
        }

        public long getRateNQT() {
            return this.rateNQT;
        }

        public boolean isBuy() {
            return this.isBuy;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public int getHeight() {
            return this.height;
        }

        public ChildChain getChildChain() {
            return ExchangeRequestHome.this.childChain;
        }
    }
}

