/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms.mint;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.HttpsURLConnection;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.crypto.Crypto;
import nxt.crypto.HashFunction;
import nxt.http.API;
import nxt.ms.CurrencyMinting;
import nxt.ms.CurrencyMintingAttachment;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Logger;
import nxt.util.TrustAllSSLProvider;
import nxt.util.security.BlockchainPermission;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class MintWorker {
    public static void main(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("mint"));
        }
        MintWorker mintWorker = new MintWorker();
        mintWorker.mint();
    }

    private void mint() {
        int n;
        String string = Convert.emptyToNull(Nxt.getStringProperty("nxt.mint.currencyCode"));
        if (string == null) {
            throw new IllegalArgumentException("nxt.mint.currencyCode not specified");
        }
        String string2 = Convert.emptyToNull(Nxt.getStringProperty("nxt.mint.secretPhrase", null, true));
        if (string2 == null) {
            throw new IllegalArgumentException("nxt.mint.secretPhrase not specified");
        }
        boolean bl = Nxt.getBooleanProperty("nxt.mint.isSubmitted");
        boolean bl2 = Nxt.getBooleanProperty("nxt.mint.stopOnError");
        String string3 = Nxt.getStringProperty("nxt.mint.chain");
        ChildChain childChain = ChildChain.getChildChain(string3);
        if (childChain == null) {
            throw new IllegalArgumentException("Invalid nxt.mint.chain childchain " + string3);
        }
        long l = Nxt.getIntProperty("nxt.mint.feeNQT");
        byte[] byArray = Crypto.sha256().digest(Crypto.getPublicKey(string2));
        long l2 = Convert.fullHashToId(byArray);
        String string4 = Convert.rsAccount(l2);
        JSONObject jSONObject = this.getCurrency(string, childChain);
        if (jSONObject.get((Object)"currency") == null) {
            throw new IllegalArgumentException("Invalid currency code " + string);
        }
        long l3 = Convert.parseUnsignedLong((String)jSONObject.get((Object)"currency"));
        if (jSONObject.get((Object)"algorithm") == null) {
            throw new IllegalArgumentException("Minting algorithm not specified, currency " + string + " is not mintable");
        }
        byte by = (byte)((Long)jSONObject.get((Object)"algorithm")).longValue();
        byte by2 = (byte)((Long)jSONObject.get((Object)"decimals")).longValue();
        String string5 = Nxt.getStringProperty("nxt.mint.unitsPerMint");
        double d = 1.0;
        if (string5 != null && string5.length() > 0) {
            d = Double.parseDouble(string5);
        }
        long l4 = (long)(d * Math.pow(10.0, by2));
        JSONObject jSONObject2 = this.getMintingTarget(l3, string4, l4);
        long l5 = (Long)jSONObject2.get((Object)"counter");
        byte[] byArray2 = Convert.parseHexString((String)jSONObject2.get((Object)"targetBytes"));
        BigInteger bigInteger = new BigInteger((String)jSONObject2.get((Object)"difficulty"));
        long l6 = Nxt.getIntProperty("nxt.mint.initialNonce");
        if (l6 == 0L) {
            l6 = new Random().nextLong();
        }
        if ((n = Nxt.getIntProperty("nxt.mint.threadPoolSize")) == 0) {
            n = Runtime.getRuntime().availableProcessors();
            Logger.logDebugMessage("Thread pool size " + n);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        Logger.logInfoMessage("Mint worker started");
        while (true) {
            ++l5;
            try {
                JSONObject jSONObject3 = this.mintImpl(childChain, l, string2, l2, l4, l3, by, l5, byArray2, l6, n, executorService, bigInteger, bl);
                Logger.logInfoMessage("currency mint response:" + JSON.toJSONString((JSONAware)jSONObject3));
            }
            catch (Exception exception) {
                Logger.logInfoMessage("mint error", exception);
                if (bl2) {
                    Logger.logInfoMessage("stopping on error");
                    break;
                }
                Logger.logInfoMessage("continue");
            }
            jSONObject2 = this.getMintingTarget(l3, string4, l4);
            byArray2 = Convert.parseHexString((String)jSONObject2.get((Object)"targetBytes"));
            bigInteger = new BigInteger((String)jSONObject2.get((Object)"difficulty"));
        }
    }

    private JSONObject mintImpl(ChildChain childChain, long l, String string, long l2, long l3, long l4, byte by, long l5, byte[] byArray, long l6, int n, ExecutorService executorService, BigInteger bigInteger, boolean bl) {
        JSONObject jSONObject;
        long l7 = System.currentTimeMillis();
        ArrayList<Callable<Long>> arrayList = new ArrayList<Callable<Long>>();
        for (int i = 0; i < n; ++i) {
            HashSolver hashSolver = new HashSolver(by, l4, l2, l5, l3, l6 + (long)i, byArray, n);
            arrayList.add(hashSolver);
        }
        long l8 = this.solve(executorService, arrayList);
        long l9 = System.currentTimeMillis() - l7;
        if (l9 == 0L) {
            l9 = 1L;
        }
        long l10 = l8 - l6;
        float f = BigInteger.valueOf(-1L).equals(bigInteger) ? 0.0f : (float)l10 / bigInteger.floatValue();
        Logger.logInfoMessage("solution nonce %d unitsNQT %d counter %d computed hashes %d time [sec] %.2f hash rate [KH/Sec] %d actual time vs. expected %.2f is submitted %b", l8, l3, l5, l10, Float.valueOf((float)l9 / 1000.0f), l10 / l9, Float.valueOf(f), bl);
        if (bl) {
            jSONObject = this.currencyMint(childChain, l, string, l4, l8, l3, l5);
        } else {
            jSONObject = new JSONObject();
            jSONObject.put((Object)"message", (Object)"nxt.ms.mint.isSubmitted=false therefore currency mint transaction is not submitted");
        }
        return jSONObject;
    }

    private long solve(Executor executor, Collection<Callable<Long>> collection) {
        ExecutorCompletionService executorCompletionService = new ExecutorCompletionService(executor);
        ArrayList arrayList = new ArrayList(collection.size());
        collection.forEach(callable -> arrayList.add(executorCompletionService.submit(callable)));
        try {
            long l = (Long)executorCompletionService.take().get();
            return l;
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new IllegalStateException(exception);
        }
        finally {
            for (Future future : arrayList) {
                future.cancel(true);
            }
        }
    }

    private JSONObject currencyMint(ChildChain childChain, long l, String string, long l2, long l3, long l4, long l5) {
        try {
            JSONObject jSONObject = this.getECBlock();
            CurrencyMintingAttachment currencyMintingAttachment = new CurrencyMintingAttachment(l3, l2, l4, l5);
            TransactionImpl.BuilderImpl builderImpl = childChain.newTransactionBuilder(Crypto.getPublicKey(string), 0L, l, (short)15, currencyMintingAttachment).timestamp(((Long)jSONObject.get((Object)"timestamp")).intValue()).ecBlockHeight(((Long)jSONObject.get((Object)"ecBlockHeight")).intValue()).ecBlockId(Convert.parseUnsignedLong((String)jSONObject.get((Object)"ecBlockId")));
            Transaction transaction = builderImpl.build(string);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("requestType", "broadcastTransaction");
            hashMap.put("transactionBytes", Convert.toHexString(transaction.getBytes()));
            return this.getJsonResponse(hashMap);
        }
        catch (NxtException.NotValidException notValidException) {
            Logger.logInfoMessage("local signing failed", notValidException);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"error", (Object)notValidException.toString());
            return jSONObject;
        }
    }

    private JSONObject getCurrency(String string, ChildChain childChain) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("requestType", "getCurrency");
        hashMap.put("code", string);
        hashMap.put("chain", childChain.getName());
        return this.getJsonResponse(hashMap);
    }

    private JSONObject getMintingTarget(long l, String string, long l2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("requestType", "getMintingTarget");
        hashMap.put("currency", Long.toUnsignedString(l));
        hashMap.put("account", string);
        hashMap.put("unitsQNT", Long.toString(l2));
        return this.getJsonResponse(hashMap);
    }

    private JSONObject getECBlock() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("requestType", "getECBlock");
        return this.getJsonResponse(hashMap);
    }

    private JSONObject getJsonResponse(Map<String, String> map) {
        JSONObject jSONObject;
        URL uRL;
        block25: {
            HttpURLConnection httpURLConnection = null;
            String string = Convert.emptyToNull(Nxt.getStringProperty("nxt.mint.serverAddress"));
            if (string == null) {
                try {
                    string = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    string = "localhost";
                }
            }
            String string2 = "http";
            boolean bl = Nxt.getBooleanProperty("nxt.mint.useHttps");
            if (bl) {
                string2 = "https";
                HttpsURLConnection.setDefaultSSLSocketFactory(TrustAllSSLProvider.getSslSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(TrustAllSSLProvider.getHostNameVerifier());
            }
            int n = Constants.isTestnet ? API.TESTNET_API_PORT : Nxt.getIntProperty("nxt.apiServerPort");
            String string3 = MintWorker.getUrlParams(map);
            try {
                uRL = new URL(string2, string, n, "/nxt?" + string3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalStateException(malformedURLException);
            }
            try {
                Logger.logDebugMessage("Sending request to server: " + uRL.toString());
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                if (httpURLConnection.getResponseCode() == 200) {
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));){
                        jSONObject = (JSONObject)JSONValue.parse((Reader)bufferedReader);
                        break block25;
                    }
                }
                jSONObject = null;
            }
            catch (IOException | RuntimeException exception) {
                Logger.logInfoMessage("Error connecting to server", exception);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                throw new IllegalStateException(exception);
            }
        }
        if (jSONObject == null) {
            throw new IllegalStateException(String.format("Request %s response error", uRL));
        }
        if (jSONObject.get((Object)"errorCode") != null) {
            throw new IllegalStateException(String.format("Request %s produced error response code %s message \"%s\"", uRL, jSONObject.get((Object)"errorCode"), jSONObject.get((Object)"errorDescription")));
        }
        if (jSONObject.get((Object)"error") != null) {
            throw new IllegalStateException(String.format("Request %s produced error %s", uRL, jSONObject.get((Object)"error")));
        }
        return jSONObject;
    }

    private static String getUrlParams(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : map.keySet()) {
            try {
                stringBuilder.append(string).append("=").append(URLEncoder.encode(map.get(string), "utf8")).append("&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException(unsupportedEncodingException);
            }
        }
        Object object = stringBuilder.toString();
        if (((String)object).endsWith("&")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return object;
    }

    private static class HashSolver
    implements Callable<Long> {
        private final HashFunction hashFunction;
        private final long currencyId;
        private final long accountId;
        private final long counter;
        private final long unitsQNT;
        private final long nonce;
        private final byte[] target;
        private final int poolSize;

        private HashSolver(byte by, long l, long l2, long l3, long l4, long l5, byte[] byArray, int n) {
            this.hashFunction = HashFunction.getHashFunction(by);
            this.currencyId = l;
            this.accountId = l2;
            this.counter = l3;
            this.unitsQNT = l4;
            this.nonce = l5;
            this.target = byArray;
            this.poolSize = n;
        }

        @Override
        public Long call() {
            long l = this.nonce;
            while (!Thread.currentThread().isInterrupted()) {
                byte[] byArray = CurrencyMinting.getHash(this.hashFunction, l, this.currencyId, this.unitsQNT, this.counter, this.accountId);
                if (CurrencyMinting.meetsTarget(byArray, this.target)) {
                    Logger.logDebugMessage("%s found solution hash %s nonce %d currencyId %d units %d counter %d accountId %d hash %s meets target %s", new Object[]{Thread.currentThread().getName(), this.hashFunction, l, this.currencyId, this.unitsQNT, this.counter, this.accountId, Arrays.toString(byArray), Arrays.toString(this.target)});
                    return l;
                }
                if (((l += (long)this.poolSize) - this.nonce) % (long)(this.poolSize * 1000000) != 0L) continue;
                Logger.logInfoMessage("%s computed %d [MH]", Thread.currentThread().getName(), (l - this.nonce) / (long)this.poolSize / 1000000L);
            }
            return null;
        }
    }
}

