/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nxt.Nxt;
import nxt.account.Account;
import nxt.blockchain.ChildChain;
import nxt.crypto.Crypto;
import nxt.peer.NetworkException;
import nxt.peer.NetworkMessage;
import nxt.peer.PeerImpl;
import nxt.peer.Peers;
import nxt.util.Logger;

public final class BundlerRate {
    private static final byte[] emptyPublicKey = new byte[32];
    private static final byte[] emptySignature = new byte[64];
    private final ChildChain chain;
    private final long rate;
    private final long feeLimit;
    private final long accountId;
    private final byte[] publicKey;
    private final int timestamp;
    private final byte[] signature;
    private long accountBalance;

    static NetworkMessage processRequest(PeerImpl peerImpl, NetworkMessage.BundlerRateMessage bundlerRateMessage) {
        List<BundlerRate> list = bundlerRateMessage.getRates();
        ArrayList<BundlerRate> arrayList = new ArrayList<BundlerRate>();
        long l = 0L;
        byte[] byArray = null;
        long l2 = 0L;
        for (BundlerRate bundlerRate : list) {
            long l3 = bundlerRate.getAccountId();
            if (l != l3) {
                Account account = Account.getAccount(l3);
                if (account == null) {
                    Logger.logDebugMessage("Bundler account " + Long.toUnsignedString(l3) + " does not exist");
                    byArray = null;
                } else {
                    byArray = Account.getPublicKey(l3);
                    if (byArray == null) {
                        Logger.logDebugMessage("Bundler account " + Long.toUnsignedString(l3) + " does not have a public key");
                    } else {
                        l2 = account.getEffectiveBalanceFXT();
                    }
                }
                l = l3;
            }
            if (byArray == null || Peers.isBundlerBlacklisted(l3)) continue;
            if (!Crypto.verify(bundlerRate.getSignature(), bundlerRate.getUnsignedBytes(), bundlerRate.getPublicKey()) || !Arrays.equals(bundlerRate.getPublicKey(), byArray)) {
                Logger.logDebugMessage("Bundler rate for account " + Long.toUnsignedString(l3) + " failed signature verification");
                continue;
            }
            bundlerRate.setBalance(l2);
            arrayList.add(bundlerRate);
        }
        Peers.updateBundlerRates(peerImpl, bundlerRateMessage, arrayList);
        return null;
    }

    public BundlerRate(ChildChain childChain, long l, long l2, long l3) {
        this.chain = childChain;
        this.publicKey = emptyPublicKey;
        this.accountId = l;
        this.rate = l2;
        this.feeLimit = l3;
        this.timestamp = 0;
        this.signature = emptySignature;
    }

    public BundlerRate(ChildChain childChain, long l, long l2, String string) {
        this.chain = childChain;
        this.publicKey = Crypto.getPublicKey(string);
        this.accountId = Account.getId(this.publicKey);
        this.rate = l;
        this.feeLimit = l2;
        this.timestamp = Nxt.getEpochTime() / 600 * 600;
        this.signature = Crypto.sign(this.getUnsignedBytes(), string);
    }

    public BundlerRate(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
        int n = byteBuffer.getInt();
        this.chain = ChildChain.getChildChain(n);
        if (this.chain == null) {
            throw new NetworkException("Child chain '" + n + "' is not valid");
        }
        this.publicKey = new byte[32];
        byteBuffer.get(this.publicKey);
        this.accountId = Account.getId(this.publicKey);
        this.rate = byteBuffer.getLong();
        this.feeLimit = byteBuffer.getLong();
        this.timestamp = byteBuffer.getInt();
        this.signature = new byte[64];
        byteBuffer.get(this.signature);
    }

    public int getLength() {
        return 120;
    }

    public void getBytes(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.chain.getId()).put(this.publicKey).putLong(this.rate).putLong(this.feeLimit).putInt(this.timestamp).put(this.signature);
    }

    public byte[] getUnsignedBytes() {
        byte[] byArray = new byte[this.getLength() - 64];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(this.chain.getId()).put(this.publicKey).putLong(this.rate).putLong(this.feeLimit).putInt(this.timestamp);
        return byArray;
    }

    public ChildChain getChain() {
        return this.chain;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public long getRate() {
        return this.rate;
    }

    public long getFeeLimit() {
        return this.feeLimit;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public long getBalance() {
        return this.accountBalance;
    }

    public void setBalance(long l) {
        this.accountBalance = l;
    }

    public int hashCode() {
        return Integer.hashCode(this.chain.getId()) ^ Long.hashCode(this.accountId) ^ Long.hashCode(this.rate) ^ Integer.hashCode(this.timestamp);
    }

    public boolean equals(Object object) {
        return object instanceof BundlerRate && this.chain == ((BundlerRate)object).chain && this.accountId == ((BundlerRate)object).accountId && this.rate == ((BundlerRate)object).rate && this.timestamp == ((BundlerRate)object).timestamp;
    }
}

