/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.util.Collections;
import java.util.List;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.authentication.Role;
import nxt.authentication.RoleMapperFactory;
import nxt.authentication.SecurityToken;
import nxt.blockchain.Transaction;
import nxt.crypto.Crypto;
import nxt.peer.NetworkHandler;
import nxt.peer.NetworkMessage;
import nxt.peer.PeerImpl;
import nxt.peer.Peers;
import nxt.peer.TransactionsInventory;
import nxt.util.Logger;

final class GetInfo {
    private static final byte[] sessionKeyId = new byte[]{-34, -83, -66, -17};

    private GetInfo() {
    }

    static NetworkMessage processRequest(PeerImpl peerImpl, NetworkMessage.GetInfoMessage getInfoMessage) {
        String string;
        if (!Peers.ignorePeerAnnouncedAddress) {
            string = getInfoMessage.getAnnouncedAddress();
            if (string != null) {
                if (!peerImpl.verifyAnnouncedAddress(string = string.toLowerCase().trim())) {
                    Logger.logDebugMessage("GetInfo: ignoring invalid announced address for " + peerImpl.getHost());
                    String string2 = peerImpl.getAnnouncedAddress();
                    if (!peerImpl.verifyAnnouncedAddress(string2)) {
                        Logger.logDebugMessage("GetInfo: old announced address for " + peerImpl.getHost() + " no longer valid");
                        Peers.changePeerAnnouncedAddress(peerImpl, null);
                    }
                    peerImpl.disconnectPeer();
                    return null;
                }
                if (!string.equals(peerImpl.getAnnouncedAddress())) {
                    Logger.logDebugMessage("GetInfo: peer " + peerImpl.getHost() + " changed announced address from " + peerImpl.getAnnouncedAddress() + " to " + string);
                    Peers.changePeerAnnouncedAddress(peerImpl, string);
                }
            } else if (!peerImpl.getHost().equals(peerImpl.getAnnouncedAddress())) {
                Peers.changePeerAnnouncedAddress(peerImpl, null);
            }
        }
        if ((string = getInfoMessage.getApplicationName()) == null) {
            string = "?";
        }
        peerImpl.setApplication(string.trim());
        String string3 = getInfoMessage.getApplicationVersion();
        if (string3 == null) {
            string3 = "?";
        }
        if (!peerImpl.setVersion(string3.trim())) {
            return null;
        }
        String string4 = getInfoMessage.getApplicationPlatform();
        if (string4 == null) {
            string4 = "?";
        }
        peerImpl.setPlatform(string4.trim());
        peerImpl.setShareAddress(getInfoMessage.getShareAddress());
        peerImpl.setApiPort(getInfoMessage.getApiPort());
        peerImpl.setApiSSLPort(getInfoMessage.getSslPort());
        peerImpl.setDisabledAPIs(getInfoMessage.getDisabledAPIs());
        peerImpl.setApiServerIdleTimeout(getInfoMessage.getApiServerIdleTimeout());
        peerImpl.setBlockchainState(getInfoMessage.getBlockchainState());
        long l = peerImpl.getServices();
        peerImpl.setServices(getInfoMessage.getServices());
        if (peerImpl.getServices() != l) {
            Peers.notifyListeners(peerImpl, Peers.Event.CHANGE_SERVICES);
        }
        SecurityToken securityToken = null;
        if (Constants.isPermissioned) {
            securityToken = getInfoMessage.getSecurityToken();
            if (securityToken == null) {
                Logger.logDebugMessage("GetInfo: No security token provided by peer " + peerImpl.getHost());
                peerImpl.disconnectPeer();
                return null;
            }
            long l2 = securityToken.getPeerAccountId();
            if (!RoleMapperFactory.getRoleMapper().isUserInRole(l2, Role.WRITER)) {
                Logger.logDebugMessage("GetInfo: Peer " + peerImpl.getHost() + " does not have WRITER permission");
                peerImpl.disconnectPeer();
                return null;
            }
        }
        if (peerImpl.isInbound()) {
            if (securityToken != null) {
                byte[] byArray = new byte[32];
                Crypto.getSecureRandom().nextBytes(byArray);
                byte[] byArray2 = new byte[32 + sessionKeyId.length];
                System.arraycopy(sessionKeyId, 0, byArray2, 0, sessionKeyId.length);
                System.arraycopy(byArray, 0, byArray2, sessionKeyId.length, 32);
                NetworkHandler.sendGetInfoMessage(peerImpl, securityToken.getPeerPublicKey(), byArray2);
                peerImpl.setSessionKey(byArray);
            } else {
                NetworkHandler.sendGetInfoMessage(peerImpl);
            }
        } else if (securityToken != null) {
            byte[] byArray = securityToken.getSessionKey(Peers.peerSecretPhrase, securityToken.getPeerPublicKey());
            if (byArray == null) {
                Logger.logDebugMessage("GetInfo: Peer " + peerImpl.getHost() + " did not provide a session key");
                peerImpl.disconnectPeer();
                return null;
            }
            if (byArray.length != sessionKeyId.length + 32) {
                Logger.logDebugMessage("GetInfo: Session key provided by " + peerImpl.getHost() + " is not valid");
                peerImpl.disconnectPeer();
                return null;
            }
            for (int i = 0; i < sessionKeyId.length; ++i) {
                if (byArray[i] == sessionKeyId[i]) continue;
                Logger.logDebugMessage("GetInfo: Session key provided by " + peerImpl.getHost() + " is not valid");
                peerImpl.disconnectPeer();
                return null;
            }
            byte[] byArray3 = new byte[32];
            System.arraycopy(byArray, sessionKeyId.length, byArray3, 0, 32);
            peerImpl.setSessionKey(byArray3);
        }
        peerImpl.handshakeComplete();
        Peers.sendBundlerRates(peerImpl);
        Peers.peersService.execute(() -> {
            List<Long> list = Nxt.getTransactionProcessor().getAllUnconfirmedTransactionIds();
            Collections.sort(list);
            NetworkMessage.TransactionsMessage transactionsMessage = (NetworkMessage.TransactionsMessage)peerImpl.sendRequest(new NetworkMessage.GetUnconfirmedTransactionsMessage(list));
            if (transactionsMessage == null || transactionsMessage.getTransactionCount() == 0) {
                return;
            }
            try {
                List<Transaction> list2 = transactionsMessage.getTransactions();
                List<? extends Transaction> list3 = Nxt.getTransactionProcessor().processPeerTransactions(list2);
                TransactionsInventory.cacheTransactions(list3);
            }
            catch (RuntimeException | NxtException.ValidationException exception) {
                peerImpl.blacklist(exception);
            }
        });
        return null;
    }
}

