/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.LinkedBlockingQueue;
import nxt.Constants;
import nxt.Nxt;
import nxt.crypto.Crypto;
import nxt.peer.NetworkMessage;
import nxt.peer.NetworkProtocolException;
import nxt.peer.Peer;
import nxt.peer.PeerImpl;
import nxt.peer.Peers;
import nxt.util.Logger;

class MessageHandler
implements Runnable {
    private static final LinkedBlockingQueue<QueueEntry> messageQueue = new LinkedBlockingQueue();
    private static volatile boolean messageShutdown = false;

    MessageHandler() {
    }

    static void processMessage(PeerImpl peerImpl, ByteBuffer byteBuffer) {
        byteBuffer.position(byteBuffer.position() - 4);
        int n = byteBuffer.getInt();
        messageQueue.offer(new QueueEntry(peerImpl, byteBuffer, (n & Integer.MIN_VALUE) != 0));
    }

    static void shutdown() {
        if (!messageShutdown) {
            messageShutdown = true;
            messageQueue.offer(new QueueEntry(null, null, false));
        }
    }

    @Override
    public void run() {
        Logger.logDebugMessage(Thread.currentThread().getName() + " started");
        block7: while (true) {
            try {
                while (true) {
                    int n;
                    Object object;
                    PeerImpl peerImpl;
                    block26: {
                        NetworkMessage networkMessage;
                        QueueEntry queueEntry = messageQueue.take();
                        if (messageShutdown) {
                            if (queueEntry.getPeer() != null) continue;
                            messageQueue.offer(queueEntry);
                            break block7;
                        }
                        peerImpl = queueEntry.getPeer();
                        if (peerImpl.getState() != Peer.State.CONNECTED) continue;
                        if (peerImpl.isHandshakePending() && queueEntry.isEncrypted()) {
                            peerImpl.queueInputMessage(queueEntry.getBytes());
                            continue;
                        }
                        NetworkMessage networkMessage2 = null;
                        try {
                            ByteBuffer byteBuffer = queueEntry.getBytes();
                            if (queueEntry.isEncrypted()) {
                                object = peerImpl.getSessionKey();
                                if (object == null) {
                                    throw new IllegalStateException("Encrypted message received without a session key");
                                }
                                byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
                                byteBuffer.get(byArray);
                                byte[] byArray2 = Crypto.aesGCMDecrypt(byArray, object);
                                byteBuffer = ByteBuffer.wrap(byArray2);
                                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            }
                            networkMessage2 = NetworkMessage.getMessage(byteBuffer);
                            if (Peers.isLogLevelEnabled(1)) {
                                Logger.logDebugMessage(String.format("%s[%d] message received from %s", networkMessage2.getMessageName(), networkMessage2.getMessageId(), peerImpl.getHost()));
                            }
                            if (networkMessage2.isResponse()) {
                                if (networkMessage2.getMessageId() == 0L) {
                                    Logger.logErrorMessage(networkMessage2.getMessageName() + " response message does not have a message identifier");
                                } else {
                                    peerImpl.completeRequest(networkMessage2);
                                }
                            } else {
                                if (networkMessage2.downloadNotAllowed()) {
                                    if (Nxt.getBlockchainProcessor().isDownloading()) {
                                        throw new IllegalStateException("Blockchain download in progress");
                                    }
                                    if (Constants.isLightClient) {
                                        throw new IllegalStateException("Peer is in light mode");
                                    }
                                }
                                networkMessage = networkMessage2.processMessage(peerImpl);
                                if (networkMessage2.requiresResponse()) {
                                    if (networkMessage == null) {
                                        Logger.logErrorMessage("No response for " + networkMessage2.getMessageName() + " message");
                                    } else {
                                        peerImpl.sendMessage(networkMessage);
                                    }
                                }
                            }
                        }
                        catch (NetworkProtocolException networkProtocolException) {
                            Logger.logDebugMessage("Unable to process message from " + peerImpl.getHost() + ": " + networkProtocolException.getMessage());
                            peerImpl.blacklist(networkProtocolException);
                        }
                        catch (Exception exception) {
                            boolean bl;
                            object = Peers.hideErrorDetails ? exception.getClass().getName() : (exception.getMessage() != null ? exception.getMessage() : exception.toString());
                            if (exception instanceof IllegalStateException) {
                                bl = false;
                            } else {
                                bl = true;
                                Logger.logDebugMessage("Unable to process message from " + peerImpl.getHost() + ": " + (String)object, exception);
                            }
                            if (networkMessage2 == null || !networkMessage2.requiresResponse()) break block26;
                            networkMessage = new NetworkMessage.ErrorMessage(networkMessage2.getMessageId(), bl, networkMessage2.getMessageName(), (String)object);
                            peerImpl.sendMessage(networkMessage);
                        }
                    }
                    if (peerImpl.getState() != Peer.State.CONNECTED || (n = peerImpl.decrementInputCount()) != 0) continue;
                    try {
                        object = peerImpl.getKeyEvent();
                        if (object == null || (object.getKey().interestOps() & 1) != 0) continue block7;
                        object.update(1, 0);
                        continue block7;
                    }
                    catch (IllegalStateException illegalStateException) {
                        Logger.logErrorMessage("Unable to update network selection key", illegalStateException);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Logger.logErrorMessage("Message handler abnormally terminated", throwable);
                break;
            }
        }
        Logger.logDebugMessage(Thread.currentThread().getName() + " stopped");
    }

    private static class QueueEntry {
        private final PeerImpl peer;
        private final ByteBuffer bytes;
        private final boolean isEncrypted;

        private QueueEntry(PeerImpl peerImpl, ByteBuffer byteBuffer, boolean bl) {
            this.peer = peerImpl;
            this.bytes = byteBuffer;
            this.isEncrypted = bl;
        }

        private PeerImpl getPeer() {
            return this.peer;
        }

        private ByteBuffer getBytes() {
            return this.bytes;
        }

        private boolean isEncrypted() {
            return this.isEncrypted;
        }
    }
}

