/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import nxt.Nxt;
import nxt.NxtException;
import nxt.authentication.SecurityToken;
import nxt.authentication.SecurityTokenFactory;
import nxt.blockchain.Block;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildBlockFxtTransaction;
import nxt.blockchain.ChildBlockFxtTransactionType;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.Transaction;
import nxt.crypto.Crypto;
import nxt.peer.AddPeers;
import nxt.peer.BlockInventory;
import nxt.peer.BlockchainState;
import nxt.peer.BundlerRate;
import nxt.peer.GetBlock;
import nxt.peer.GetCumulativeDifficulty;
import nxt.peer.GetInfo;
import nxt.peer.GetMilestoneBlockIds;
import nxt.peer.GetNextBlockIds;
import nxt.peer.GetNextBlocks;
import nxt.peer.GetPeers;
import nxt.peer.GetTransactions;
import nxt.peer.GetUnconfirmedTransactions;
import nxt.peer.NetworkException;
import nxt.peer.NetworkProtocolException;
import nxt.peer.Peer;
import nxt.peer.PeerImpl;
import nxt.peer.TransactionsInventory;
import nxt.util.Convert;
import nxt.util.Logger;

public abstract class NetworkMessage {
    private static final int PROTOCOL_LEVEL = 2;
    public static final int MAX_ARRAY_LENGTH = 49152;
    public static final int MAX_LIST_SIZE = 1500;
    private static final Charset UTF8;
    private static final AtomicLong nextMessageId;
    private static final Map<String, NetworkMessage> processors;
    private int protocolLevel;
    private byte[] messageNameBytes;
    protected long messageId;

    private NetworkMessage(String string) {
        this.messageNameBytes = string.getBytes(UTF8);
        this.protocolLevel = 2;
    }

    private NetworkMessage(String string, ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
        this.messageNameBytes = string.getBytes(UTF8);
        this.protocolLevel = byteBuffer.getShort() & 0xFFFF;
        if (this.protocolLevel != 2) {
            throw new NetworkProtocolException("Protocol level " + this.protocolLevel + " is not accepted");
        }
    }

    static NetworkMessage getMessage(ByteBuffer byteBuffer) throws NetworkException {
        NetworkMessage networkMessage;
        int n = byteBuffer.get() & 0xFF;
        if (n < 1) {
            throw new NetworkException("Message name missing");
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        String string = new String(byArray, UTF8);
        NetworkMessage networkMessage2 = processors.get(string);
        try {
            if (networkMessage2 == null) {
                throw new NetworkException("'" + string + "' is not a valid peer message");
            }
            networkMessage = networkMessage2.constructMessage(byteBuffer);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new NetworkException("'" + string + "' message is too short", bufferUnderflowException);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new NetworkException("'" + string + "' message buffer is too small", bufferOverflowException);
        }
        return networkMessage;
    }

    NetworkMessage processMessage(PeerImpl peerImpl) {
        return null;
    }

    protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
        throw new RuntimeException("Required message processor missing");
    }

    int getLength() {
        return 1 + this.messageNameBytes.length + 2;
    }

    void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
        byteBuffer.put((byte)this.messageNameBytes.length).put(this.messageNameBytes).putShort((short)this.protocolLevel);
    }

    long getMessageId() {
        return this.messageId;
    }

    String getMessageName() {
        return new String(this.messageNameBytes, UTF8);
    }

    boolean requiresResponse() {
        return false;
    }

    boolean isResponse() {
        return false;
    }

    boolean downloadNotAllowed() {
        return false;
    }

    boolean sendToLightClient() {
        return false;
    }

    private static int getEncodedArrayLength(byte[] byArray) {
        int n = byArray.length;
        n = n < 254 ? ++n : (n < 65536 ? (n += 3) : (n += 5));
        return n;
    }

    private static void encodeArray(ByteBuffer byteBuffer, byte[] byArray) throws BufferOverflowException {
        if (byArray.length > 49152) {
            throw new RuntimeException("Array length " + byArray.length + " exceeds the maximum of " + 49152);
        }
        if (byArray.length < 254) {
            byteBuffer.put((byte)byArray.length);
        } else if (byArray.length < 65536) {
            byteBuffer.put((byte)-2).putShort((short)byArray.length);
        } else {
            byteBuffer.put((byte)-1).putInt(byArray.length);
        }
        if (byArray.length > 0) {
            byteBuffer.put(byArray);
        }
    }

    private static byte[] decodeArray(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
        int n = byteBuffer.get() & 0xFF;
        if (n == 254) {
            n = byteBuffer.getShort() & 0xFFFF;
        } else if (n == 255) {
            n = byteBuffer.getInt();
        }
        if (n > 49152) {
            throw new NetworkException("Array length " + n + " exceeds the maximum of " + 49152);
        }
        byte[] byArray = new byte[n];
        if (n > 0) {
            byteBuffer.get(byArray);
        }
        return byArray;
    }

    static {
        try {
            UTF8 = Charset.forName("UTF-8");
        }
        catch (Exception exception) {
            Logger.logErrorMessage("Unable to create UTF-8 character set", exception);
            throw new ExceptionInInitializerError("Unable to create UTF-8 character set");
        }
        nextMessageId = new AtomicLong();
        processors = new HashMap<String, NetworkMessage>();
        processors.put("AddPeers", new AddPeersMessage());
        processors.put("BlockIds", new BlockIdsMessage());
        processors.put("BlockInventory", new BlockInventoryMessage());
        processors.put("BlockchainState", new BlockchainStateMessage());
        processors.put("Blocks", new BlocksMessage());
        processors.put("BundlerRate", new BundlerRateMessage());
        processors.put("CumulativeDifficulty", new CumulativeDifficultyMessage());
        processors.put("Error", new ErrorMessage());
        processors.put("GetBlocks", new GetBlockMessage());
        processors.put("GetCumulativeDifficulty", new GetCumulativeDifficultyMessage());
        processors.put("GetInfo", new GetInfoMessage());
        processors.put("GetMilestoneBlockIds", new GetMilestoneBlockIdsMessage());
        processors.put("GetNextBlockIds", new GetNextBlockIdsMessage());
        processors.put("GetNextBlocks", new GetNextBlocksMessage());
        processors.put("GetPeers", new GetPeersMessage());
        processors.put("GetTransactions", new GetTransactionsMessage());
        processors.put("GetUnconfirmedTransactions", new GetUnconfirmedTransactionsMessage());
        processors.put("MilestoneBlockIds", new MilestoneBlockIdsMessage());
        processors.put("Transactions", new TransactionsMessage());
        processors.put("TransactionsInventory", new TransactionsInventoryMessage());
    }

    private static class TransactionBytes {
        private static final TransactionBytes EXCLUDED = new TransactionBytes(Convert.EMPTY_BYTE);
        private final byte[] transactionBytes;

        private static TransactionBytes parse(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            byte[] byArray = NetworkMessage.decodeArray(byteBuffer);
            if (byArray.length == 0) {
                return EXCLUDED;
            }
            return new TransactionBytes(byArray);
        }

        private TransactionBytes(Transaction transaction) {
            this.transactionBytes = transaction.getPrunableBytes();
        }

        private TransactionBytes(byte[] byArray) {
            this.transactionBytes = byArray;
        }

        private TransactionBytes(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            this.transactionBytes = NetworkMessage.decodeArray(byteBuffer);
        }

        private int getLength() {
            return NetworkMessage.getEncodedArrayLength(this.transactionBytes);
        }

        private void getBytes(ByteBuffer byteBuffer) {
            NetworkMessage.encodeArray(byteBuffer, this.transactionBytes);
        }

        private Transaction getTransaction() throws NxtException.NotValidException {
            if (this.transactionBytes.length == 0) {
                throw new IllegalArgumentException("No excluded transactions provided");
            }
            return Nxt.parseTransaction(this.transactionBytes);
        }

        private Transaction getTransaction(Iterator<Transaction> iterator) throws NxtException.NotValidException {
            if (this.transactionBytes.length != 0) {
                return this.getTransaction();
            }
            return iterator.next();
        }
    }

    private static class BlockBytes {
        private final byte[] blockBytes;
        private final List<TransactionBytes> blockTransactions;
        private final int[] childCounts;
        private int length;

        private BlockBytes(Block block) {
            this.blockBytes = block.getBytes();
            this.length = NetworkMessage.getEncodedArrayLength(this.blockBytes) + 2;
            List<? extends FxtTransaction> list = block.getFxtTransactions();
            this.blockTransactions = new ArrayList<TransactionBytes>();
            this.childCounts = new int[list.size()];
            for (int i = 0; i < this.childCounts.length; ++i) {
                FxtTransaction fxtTransaction = list.get(i);
                TransactionBytes transactionBytes = new TransactionBytes(fxtTransaction);
                this.blockTransactions.add(transactionBytes);
                this.length += transactionBytes.getLength() + 2;
                this.childCounts[i] = fxtTransaction.getSortedChildTransactions().size();
                fxtTransaction.getSortedChildTransactions().forEach(childTransaction -> {
                    TransactionBytes transactionBytes = new TransactionBytes((Transaction)childTransaction);
                    this.blockTransactions.add(transactionBytes);
                    this.length += transactionBytes.getLength();
                });
            }
        }

        private BlockBytes(Block block, BitSet bitSet) {
            this.blockBytes = block.getBytes();
            this.length = NetworkMessage.getEncodedArrayLength(this.blockBytes) + 2;
            List<? extends FxtTransaction> list = block.getFxtTransactions();
            this.blockTransactions = new ArrayList<TransactionBytes>();
            this.childCounts = new int[list.size()];
            int n = 0;
            for (int i = 0; i < this.childCounts.length; ++i) {
                FxtTransaction fxtTransaction = list.get(i);
                if (!bitSet.get(n++)) {
                    TransactionBytes transactionBytes = new TransactionBytes(fxtTransaction);
                    this.blockTransactions.add(transactionBytes);
                    this.length += transactionBytes.getLength();
                } else {
                    this.blockTransactions.add(TransactionBytes.EXCLUDED);
                    this.length += TransactionBytes.EXCLUDED.getLength();
                }
                this.length += 2;
                this.childCounts[i] = fxtTransaction.getSortedChildTransactions().size();
                for (ChildTransaction childTransaction : fxtTransaction.getSortedChildTransactions()) {
                    if (!bitSet.get(n++)) {
                        TransactionBytes transactionBytes = new TransactionBytes(childTransaction);
                        this.blockTransactions.add(transactionBytes);
                        this.length += transactionBytes.getLength();
                        continue;
                    }
                    this.blockTransactions.add(TransactionBytes.EXCLUDED);
                    this.length += TransactionBytes.EXCLUDED.getLength();
                }
            }
        }

        private BlockBytes(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            this.blockBytes = NetworkMessage.decodeArray(byteBuffer);
            this.length = NetworkMessage.getEncodedArrayLength(this.blockBytes) + 2;
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 1500) {
                throw new NetworkException("Array size " + n + " exceeds the maximum size");
            }
            int n2 = n;
            this.blockTransactions = new ArrayList<TransactionBytes>();
            this.childCounts = new int[n];
            for (int i = 0; i < n; ++i) {
                int n3;
                TransactionBytes transactionBytes = TransactionBytes.parse(byteBuffer);
                this.blockTransactions.add(transactionBytes);
                this.length += transactionBytes.getLength() + 2;
                this.childCounts[i] = n3 = byteBuffer.getShort() & 0xFFFF;
                if ((n2 += n3) > 1500) {
                    throw new NetworkException("Array size " + n2 + " exceeds the maximum size");
                }
                while (n3-- > 0) {
                    TransactionBytes transactionBytes2 = TransactionBytes.parse(byteBuffer);
                    this.blockTransactions.add(transactionBytes2);
                    this.length += transactionBytes2.getLength();
                }
            }
        }

        private int getLength() {
            return this.length;
        }

        private void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            NetworkMessage.encodeArray(byteBuffer, this.blockBytes);
            byteBuffer.putShort((short)this.childCounts.length);
            Iterator<TransactionBytes> iterator = this.blockTransactions.iterator();
            for (int n : this.childCounts) {
                iterator.next().getBytes(byteBuffer);
                byteBuffer.putShort((short)n);
                while (n-- > 0) {
                    iterator.next().getBytes(byteBuffer);
                }
            }
        }

        private Block getBlock() throws NxtException.NotValidException {
            byte[] byArray = Crypto.sha256().digest(this.blockBytes);
            ArrayList<FxtTransaction> arrayList = new ArrayList<FxtTransaction>(this.childCounts.length);
            Iterator<TransactionBytes> iterator = this.blockTransactions.iterator();
            for (int n : this.childCounts) {
                FxtTransaction fxtTransaction = (FxtTransaction)iterator.next().getTransaction();
                if (n > 0) {
                    ArrayList<ChildTransaction> arrayList2 = new ArrayList<ChildTransaction>();
                    while (n-- > 0) {
                        arrayList2.add((ChildTransaction)iterator.next().getTransaction());
                    }
                    fxtTransaction.setChildTransactions(arrayList2, byArray);
                }
                arrayList.add(fxtTransaction);
            }
            return Nxt.parseBlock(this.blockBytes, arrayList);
        }

        private Block getBlock(List<Transaction> list) throws NxtException.NotValidException {
            if (list.isEmpty()) {
                return this.getBlock();
            }
            byte[] byArray = Crypto.sha256().digest(this.blockBytes);
            ArrayList<FxtTransaction> arrayList = new ArrayList<FxtTransaction>(this.childCounts.length);
            Iterator<TransactionBytes> iterator = this.blockTransactions.iterator();
            Iterator<Transaction> iterator2 = list.iterator();
            for (int n : this.childCounts) {
                FxtTransaction fxtTransaction = (FxtTransaction)iterator.next().getTransaction(iterator2);
                if (n > 0) {
                    ArrayList<ChildTransaction> arrayList2 = new ArrayList<ChildTransaction>();
                    while (n-- > 0) {
                        arrayList2.add((ChildTransaction)iterator.next().getTransaction(iterator2));
                    }
                    fxtTransaction.setChildTransactions(arrayList2, byArray);
                }
                arrayList.add(fxtTransaction);
            }
            return Nxt.parseBlock(this.blockBytes, arrayList);
        }
    }

    public static class ErrorMessage
    extends NetworkMessage {
        private final byte[] errorMessageBytes;
        private final byte[] errorNameBytes;
        private final boolean severeError;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new ErrorMessage(byteBuffer);
        }

        private ErrorMessage() {
            super("Error");
            this.messageId = 0L;
            this.severeError = false;
            this.errorNameBytes = null;
            this.errorMessageBytes = null;
        }

        public ErrorMessage(long l, boolean bl, String string, String string2) {
            super("Error");
            this.messageId = l;
            this.severeError = bl;
            this.errorNameBytes = string.getBytes(UTF8);
            this.errorMessageBytes = string2.getBytes(UTF8);
        }

        private ErrorMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("Error", byteBuffer);
            this.messageId = byteBuffer.getLong();
            this.severeError = byteBuffer.get() != 0;
            this.errorNameBytes = NetworkMessage.decodeArray(byteBuffer);
            this.errorMessageBytes = NetworkMessage.decodeArray(byteBuffer);
        }

        @Override
        int getLength() {
            return super.getLength() + 8 + 1 + NetworkMessage.getEncodedArrayLength(this.errorNameBytes) + NetworkMessage.getEncodedArrayLength(this.errorMessageBytes);
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId);
            byteBuffer.put(this.severeError ? (byte)1 : 0);
            NetworkMessage.encodeArray(byteBuffer, this.errorNameBytes);
            NetworkMessage.encodeArray(byteBuffer, this.errorMessageBytes);
        }

        @Override
        boolean isResponse() {
            return true;
        }

        public boolean isSevereError() {
            return this.severeError;
        }

        public String getErrorName() {
            return new String(this.errorNameBytes, UTF8);
        }

        public String getErrorMessage() {
            return new String(this.errorMessageBytes, UTF8);
        }
    }

    public static class TransactionsInventoryMessage
    extends NetworkMessage {
        private final List<ChainTransactionId> transactionIds;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new TransactionsInventoryMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return TransactionsInventory.processRequest(peerImpl, this);
        }

        private TransactionsInventoryMessage() {
            super("TransactionsInventory");
            this.transactionIds = null;
        }

        public TransactionsInventoryMessage(List<? extends Transaction> list) {
            super("TransactionsInventory");
            HashSet<ChainTransactionId> hashSet = new HashSet<ChainTransactionId>();
            for (Transaction transaction : list) {
                hashSet.add(ChainTransactionId.getChainTransactionId(transaction));
                if (transaction.getType() != ChildBlockFxtTransactionType.INSTANCE) continue;
                ChildBlockFxtTransaction childBlockFxtTransaction = (ChildBlockFxtTransaction)transaction;
                for (byte[] byArray : childBlockFxtTransaction.getChildTransactionFullHashes()) {
                    hashSet.add(new ChainTransactionId(childBlockFxtTransaction.getChildChain().getId(), byArray));
                }
            }
            this.transactionIds = new ArrayList<ChainTransactionId>(hashSet);
            if (this.transactionIds.size() > 1500) {
                throw new RuntimeException("List size " + list.size() + " exceeds the maximum of " + 1500);
            }
        }

        private TransactionsInventoryMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("TransactionsInventory", byteBuffer);
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 1500) {
                throw new NetworkException("List size " + n + " exceeds the maximum of " + 1500);
            }
            this.transactionIds = new ArrayList<ChainTransactionId>(n);
            for (int i = 0; i < n; ++i) {
                this.transactionIds.add(ChainTransactionId.parse(byteBuffer));
            }
        }

        @Override
        int getLength() {
            return super.getLength() + 2 + 36 * this.transactionIds.size();
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putShort((short)this.transactionIds.size());
            for (ChainTransactionId chainTransactionId : this.transactionIds) {
                chainTransactionId.put(byteBuffer);
            }
        }

        @Override
        boolean downloadNotAllowed() {
            return true;
        }

        public List<ChainTransactionId> getTransactionIds() {
            return this.transactionIds;
        }
    }

    public static class BlockInventoryMessage
    extends NetworkMessage {
        private final long blockId;
        private final long previousBlockId;
        private final int timestamp;
        private final List<ChainTransactionId> transactionIds;
        private int[] childCounts;
        private int totalLength;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new BlockInventoryMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return BlockInventory.processRequest(peerImpl, this);
        }

        private BlockInventoryMessage() {
            super("BlockInventory");
            this.blockId = 0L;
            this.previousBlockId = 0L;
            this.timestamp = 0;
            this.transactionIds = null;
            this.totalLength = 0;
        }

        public BlockInventoryMessage(Block block) {
            super("BlockInventory");
            this.blockId = block.getId();
            this.previousBlockId = block.getPreviousBlockId();
            this.timestamp = block.getTimestamp();
            this.totalLength = 22;
            List<? extends FxtTransaction> list = block.getFxtTransactions();
            if (list.size() > 1500) {
                throw new RuntimeException("List size " + list.size() + " exceeds the maximum of " + 1500);
            }
            this.childCounts = new int[list.size()];
            this.transactionIds = new ArrayList<ChainTransactionId>();
            for (int i = 0; i < this.childCounts.length; ++i) {
                FxtTransaction fxtTransaction = list.get(i);
                this.transactionIds.add(ChainTransactionId.getChainTransactionId(fxtTransaction));
                this.totalLength += 32;
                int n = fxtTransaction.getSortedChildTransactions().size();
                this.totalLength += 2;
                if (n > 0) {
                    this.totalLength += 4 + n * 32;
                }
                this.childCounts[i] = n;
                fxtTransaction.getSortedChildTransactions().forEach(childTransaction -> this.transactionIds.add(ChainTransactionId.getChainTransactionId(childTransaction)));
            }
        }

        private BlockInventoryMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("BlockInventory", byteBuffer);
            this.blockId = byteBuffer.getLong();
            this.previousBlockId = byteBuffer.getLong();
            this.timestamp = byteBuffer.getInt();
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 1500) {
                throw new NetworkException("List size " + n + " exceeds the maximum of " + 1500);
            }
            int n2 = n;
            this.transactionIds = new ArrayList<ChainTransactionId>();
            this.childCounts = new int[n];
            for (int i = 0; i < n; ++i) {
                int n3;
                byte[] byArray = new byte[32];
                byteBuffer.get(byArray);
                this.transactionIds.add(new ChainTransactionId(FxtChain.FXT.getId(), byArray));
                this.childCounts[i] = n3 = byteBuffer.getShort() & 0xFFFF;
                if (n3 <= 0) continue;
                if ((n2 += n3) > 1500) {
                    throw new NetworkException("Total list size " + n2 + " exceeds the maximum of " + 1500);
                }
                int n4 = byteBuffer.getInt();
                while (n3-- > 0) {
                    byte[] byArray2 = new byte[32];
                    byteBuffer.get(byArray2);
                    this.transactionIds.add(new ChainTransactionId(n4, byArray2));
                }
            }
        }

        @Override
        int getLength() {
            return super.getLength() + this.totalLength;
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.blockId).putLong(this.previousBlockId).putInt(this.timestamp);
            byteBuffer.putShort((short)this.childCounts.length);
            Iterator<ChainTransactionId> iterator = this.transactionIds.iterator();
            for (int i = 0; i < this.childCounts.length; ++i) {
                ChainTransactionId chainTransactionId = iterator.next();
                byteBuffer.put(chainTransactionId.getFullHash());
                int n = this.childCounts[i];
                byteBuffer.putShort((short)n);
                if (n-- > 0) {
                    ChainTransactionId chainTransactionId2 = iterator.next();
                    byteBuffer.putInt(chainTransactionId2.getChainId());
                    byteBuffer.put(chainTransactionId2.getFullHash());
                }
                while (n-- > 0) {
                    byteBuffer.put(iterator.next().getFullHash());
                }
            }
        }

        @Override
        boolean downloadNotAllowed() {
            return true;
        }

        public long getBlockId() {
            return this.blockId;
        }

        public long getPreviousBlockId() {
            return this.previousBlockId;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public List<ChainTransactionId> getTransactionIds() {
            return this.transactionIds;
        }
    }

    public static class TransactionsMessage
    extends NetworkMessage {
        private final List<TransactionBytes> transactionBytes;
        private int totalTransactionLength;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new TransactionsMessage(byteBuffer);
        }

        private TransactionsMessage() {
            super("Transactions");
            this.messageId = 0L;
            this.transactionBytes = null;
            this.totalTransactionLength = 0;
        }

        public TransactionsMessage(long l, List<? extends Transaction> list) {
            super("Transactions");
            if (list.size() > 1500) {
                throw new RuntimeException("List size " + list.size() + " exceeds the maximum of " + 1500);
            }
            this.messageId = l;
            this.transactionBytes = new ArrayList<TransactionBytes>(list.size());
            this.totalTransactionLength = 0;
            for (Transaction transaction : list) {
                TransactionBytes transactionBytes = new TransactionBytes(transaction);
                if (this.getLength() + transactionBytes.getLength() > 0x100000) {
                    ((ArrayList)this.transactionBytes).trimToSize();
                    Logger.logDebugMessage("Transactions message size exceeds 1048576");
                    break;
                }
                this.transactionBytes.add(transactionBytes);
                this.totalTransactionLength += transactionBytes.getLength();
            }
        }

        private TransactionsMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("Transactions", byteBuffer);
            this.messageId = byteBuffer.getLong();
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 1500) {
                throw new NetworkException("List size " + n + " exceeds the maximum of " + 1500);
            }
            this.transactionBytes = new ArrayList<TransactionBytes>(n);
            this.totalTransactionLength = 0;
            for (int i = 0; i < n; ++i) {
                TransactionBytes transactionBytes = new TransactionBytes(byteBuffer);
                this.transactionBytes.add(transactionBytes);
                this.totalTransactionLength += transactionBytes.getLength();
            }
        }

        @Override
        int getLength() {
            return super.getLength() + 8 + 2 + this.totalTransactionLength;
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId);
            byteBuffer.putShort((short)this.transactionBytes.size());
            this.transactionBytes.forEach(transactionBytes -> ((TransactionBytes)transactionBytes).getBytes(byteBuffer));
        }

        @Override
        boolean isResponse() {
            return true;
        }

        public int getTransactionCount() {
            return this.transactionBytes.size();
        }

        public List<Transaction> getTransactions() throws NxtException.NotValidException {
            ArrayList<Transaction> arrayList = new ArrayList<Transaction>(this.transactionBytes.size());
            for (TransactionBytes transactionBytes : this.transactionBytes) {
                arrayList.add(transactionBytes.getTransaction());
            }
            return arrayList;
        }
    }

    public static class GetUnconfirmedTransactionsMessage
    extends NetworkMessage {
        private final List<Long> exclusionIds;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new GetUnconfirmedTransactionsMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return GetUnconfirmedTransactions.processRequest(peerImpl, this);
        }

        private GetUnconfirmedTransactionsMessage() {
            super("GetUnconfirmedTransactions");
            this.messageId = 0L;
            this.exclusionIds = null;
        }

        public GetUnconfirmedTransactionsMessage(List<Long> list) {
            super("GetUnconfirmedTransactions");
            if (list.size() > 1500) {
                throw new RuntimeException("List size " + list.size() + " exceeds the maximum of " + 1500);
            }
            this.messageId = nextMessageId.incrementAndGet();
            this.exclusionIds = list;
        }

        private GetUnconfirmedTransactionsMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("GetUnconfirmedTransactions", byteBuffer);
            this.messageId = byteBuffer.getLong();
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 1500) {
                throw new NetworkException("List size " + n + " exceeds the maximum of " + 1500);
            }
            this.exclusionIds = new ArrayList<Long>(n);
            for (int i = 0; i < n; ++i) {
                this.exclusionIds.add(byteBuffer.getLong());
            }
        }

        @Override
        int getLength() {
            return super.getLength() + 8 + 2 + 8 * this.exclusionIds.size();
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId);
            byteBuffer.putShort((short)this.exclusionIds.size());
            this.exclusionIds.forEach(byteBuffer::putLong);
        }

        @Override
        boolean requiresResponse() {
            return true;
        }

        @Override
        boolean downloadNotAllowed() {
            return true;
        }

        public List<Long> getExclusions() {
            return this.exclusionIds;
        }
    }

    public static class GetTransactionsMessage
    extends NetworkMessage {
        private final List<ChainTransactionId> transactionIds;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new GetTransactionsMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return GetTransactions.processRequest(peerImpl, this);
        }

        private GetTransactionsMessage() {
            super("GetTransactions");
            this.messageId = 0L;
            this.transactionIds = null;
        }

        public GetTransactionsMessage(List<ChainTransactionId> list) {
            super("GetTransactions");
            if (list.size() > 1500) {
                throw new RuntimeException("List size " + list.size() + " exceeds the maximum of " + 1500);
            }
            this.messageId = nextMessageId.incrementAndGet();
            this.transactionIds = list;
        }

        private GetTransactionsMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("GetTransactions", byteBuffer);
            this.messageId = byteBuffer.getLong();
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 1500) {
                throw new NetworkException("List size " + n + " exceeds the maximum of " + 1500);
            }
            this.transactionIds = new ArrayList<ChainTransactionId>(n);
            for (int i = 0; i < n; ++i) {
                this.transactionIds.add(ChainTransactionId.parse(byteBuffer));
            }
        }

        @Override
        public int getLength() {
            return super.getLength() + 8 + 2 + 36 * this.transactionIds.size();
        }

        @Override
        public void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId);
            byteBuffer.putShort((short)this.transactionIds.size());
            this.transactionIds.forEach(chainTransactionId -> chainTransactionId.put(byteBuffer));
        }

        @Override
        boolean requiresResponse() {
            return true;
        }

        public List<ChainTransactionId> getTransactionIds() {
            return this.transactionIds;
        }
    }

    public static class BlocksMessage
    extends NetworkMessage {
        private final List<BlockBytes> blockBytes;
        private int totalBlockLength;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new BlocksMessage(byteBuffer);
        }

        private BlocksMessage() {
            super("Blocks");
            this.messageId = 0L;
            this.blockBytes = null;
            this.totalBlockLength = 0;
        }

        public BlocksMessage(long l, List<? extends Block> list) {
            super("Blocks");
            if (list.size() > 1500) {
                throw new RuntimeException("List size " + list.size() + " exceeds the maximum of " + 1500);
            }
            this.messageId = l;
            this.blockBytes = new ArrayList<BlockBytes>(list.size());
            this.totalBlockLength = 0;
            for (Block block : list) {
                BlockBytes blockBytes = new BlockBytes(block);
                if (this.getLength() + blockBytes.getLength() > 0x100000) {
                    ((ArrayList)this.blockBytes).trimToSize();
                    Logger.logDebugMessage("Blocks message size exceeds 1048576");
                    break;
                }
                this.blockBytes.add(blockBytes);
                this.totalBlockLength += blockBytes.getLength();
            }
        }

        public BlocksMessage(long l, Block block, byte[] byArray) {
            super("Blocks");
            this.messageId = l;
            this.totalBlockLength = 0;
            if (block == null) {
                this.blockBytes = Collections.emptyList();
            } else {
                BlockBytes blockBytes = byArray == null ? new BlockBytes(block) : new BlockBytes(block, BitSet.valueOf(byArray));
                this.blockBytes = Collections.singletonList(blockBytes);
                this.totalBlockLength += blockBytes.getLength();
            }
        }

        private BlocksMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("Blocks", byteBuffer);
            this.messageId = byteBuffer.getLong();
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 1500) {
                throw new NetworkException("List size " + n + " exceeds the maximum of " + 1500);
            }
            this.blockBytes = new ArrayList<BlockBytes>(n);
            this.totalBlockLength = 0;
            for (int i = 0; i < n; ++i) {
                BlockBytes blockBytes = new BlockBytes(byteBuffer);
                this.blockBytes.add(blockBytes);
                this.totalBlockLength += blockBytes.getLength();
            }
        }

        @Override
        int getLength() {
            return super.getLength() + 8 + 2 + this.totalBlockLength;
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId);
            byteBuffer.putShort((short)this.blockBytes.size());
            this.blockBytes.forEach(blockBytes -> ((BlockBytes)blockBytes).getBytes(byteBuffer));
        }

        @Override
        boolean isResponse() {
            return true;
        }

        public int getBlockCount() {
            return this.blockBytes.size();
        }

        public List<Block> getBlocks() throws NxtException.NotValidException {
            ArrayList<Block> arrayList = new ArrayList<Block>(this.blockBytes.size());
            for (BlockBytes blockBytes : this.blockBytes) {
                arrayList.add(blockBytes.getBlock());
            }
            return arrayList;
        }

        public Block getBlock(List<Transaction> list) throws NxtException.NotValidException {
            if (this.blockBytes.size() > 1) {
                throw new IllegalArgumentException("BlocksMessage of more than one block does not support excludedTransactions");
            }
            if (this.blockBytes.isEmpty()) {
                return null;
            }
            return this.blockBytes.get(0).getBlock(list);
        }
    }

    public static class GetBlockMessage
    extends NetworkMessage {
        private final long blockId;
        private final byte[] excludedTransactions;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new GetBlockMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return GetBlock.processRequest(peerImpl, this);
        }

        private GetBlockMessage() {
            super("GetBlocks");
            this.messageId = 0L;
            this.blockId = 0L;
            this.excludedTransactions = null;
        }

        public GetBlockMessage(long l) {
            this(l, null);
        }

        public GetBlockMessage(long l, BitSet bitSet) {
            super("GetBlocks");
            this.excludedTransactions = bitSet == null ? null : bitSet.toByteArray();
            this.messageId = nextMessageId.incrementAndGet();
            this.blockId = l;
        }

        private GetBlockMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("GetBlocks", byteBuffer);
            this.messageId = byteBuffer.getLong();
            this.blockId = byteBuffer.getLong();
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 49152) {
                throw new NetworkException("Excluded transactions size " + n + " exceeds the maximum of " + 49152);
            }
            if (n > 0) {
                this.excludedTransactions = new byte[n];
                byteBuffer.get(this.excludedTransactions);
            } else {
                this.excludedTransactions = null;
            }
        }

        @Override
        int getLength() {
            return super.getLength() + 8 + 8 + 2 + this.excludedTransactions.length;
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId);
            byteBuffer.putLong(this.blockId);
            if (this.excludedTransactions != null) {
                byteBuffer.putShort((short)this.excludedTransactions.length);
                byteBuffer.put(this.excludedTransactions);
            } else {
                byteBuffer.putShort((short)0);
            }
        }

        @Override
        boolean requiresResponse() {
            return true;
        }

        @Override
        boolean downloadNotAllowed() {
            return true;
        }

        public long getBlockId() {
            return this.blockId;
        }

        public byte[] getExcludedTransactions() {
            return this.excludedTransactions;
        }
    }

    public static class GetNextBlocksMessage
    extends NetworkMessage {
        private final long blockId;
        private final int limit;
        private final List<Long> blockIds;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new GetNextBlocksMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return GetNextBlocks.processRequest(peerImpl, this);
        }

        private GetNextBlocksMessage() {
            super("GetNextBlocks");
            this.messageId = 0L;
            this.blockId = 0L;
            this.limit = 0;
            this.blockIds = null;
        }

        public GetNextBlocksMessage(long l, int n, List<Long> list) {
            super("GetNextBlocks");
            if (list != null && list.size() > 1500) {
                throw new RuntimeException("List size " + list.size() + " exceeds the maximum of " + 1500);
            }
            this.messageId = nextMessageId.incrementAndGet();
            this.blockId = l;
            this.limit = n;
            this.blockIds = list != null ? list : Collections.emptyList();
        }

        private GetNextBlocksMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("GetNextBlocks", byteBuffer);
            this.messageId = byteBuffer.getLong();
            this.blockId = byteBuffer.getLong();
            this.limit = byteBuffer.getInt();
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 1500) {
                throw new NetworkException("List size " + n + " exceeds the maximum of " + 1500);
            }
            this.blockIds = new ArrayList<Long>(n);
            for (int i = 0; i < n; ++i) {
                this.blockIds.add(byteBuffer.getLong());
            }
        }

        @Override
        int getLength() {
            return super.getLength() + 8 + 8 + 4 + 2 + 8 * this.blockIds.size();
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId);
            byteBuffer.putLong(this.blockId).putInt(this.limit).putShort((short)this.blockIds.size());
            this.blockIds.forEach(byteBuffer::putLong);
        }

        @Override
        boolean requiresResponse() {
            return true;
        }

        @Override
        boolean downloadNotAllowed() {
            return true;
        }

        public long getBlockId() {
            return this.blockId;
        }

        public int getLimit() {
            return this.limit;
        }

        public List<Long> getBlockIds() {
            return this.blockIds;
        }
    }

    public static class BlockIdsMessage
    extends NetworkMessage {
        private final List<Long> blockIds;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new BlockIdsMessage(byteBuffer);
        }

        private BlockIdsMessage() {
            super("BlockIds");
            this.messageId = 0L;
            this.blockIds = null;
        }

        public BlockIdsMessage(long l, List<Long> list) {
            super("BlockIds");
            if (list.size() > 1500) {
                throw new RuntimeException("List size " + list.size() + " exceeds the maximum of " + 1500);
            }
            this.messageId = l;
            this.blockIds = list;
        }

        private BlockIdsMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("BlockIds", byteBuffer);
            this.messageId = byteBuffer.getLong();
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 1500) {
                throw new NetworkException("List size " + n + " exceeds the maximum of " + 1500);
            }
            this.blockIds = new ArrayList<Long>(n);
            for (int i = 0; i < n; ++i) {
                this.blockIds.add(byteBuffer.getLong());
            }
        }

        @Override
        int getLength() {
            return super.getLength() + 8 + 2 + 8 * this.blockIds.size();
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId);
            byteBuffer.putShort((short)this.blockIds.size());
            this.blockIds.forEach(byteBuffer::putLong);
        }

        @Override
        boolean isResponse() {
            return true;
        }

        public List<Long> getBlockIds() {
            return this.blockIds;
        }
    }

    public static class GetNextBlockIdsMessage
    extends NetworkMessage {
        private final long blockId;
        private final int limit;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new GetNextBlockIdsMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return GetNextBlockIds.processRequest(peerImpl, this);
        }

        private GetNextBlockIdsMessage() {
            super("GetNextBlockIds");
            this.messageId = 0L;
            this.blockId = 0L;
            this.limit = 0;
        }

        public GetNextBlockIdsMessage(long l, int n) {
            super("GetNextBlockIds");
            this.messageId = nextMessageId.incrementAndGet();
            this.blockId = l;
            this.limit = n;
        }

        private GetNextBlockIdsMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("GetNextBlockIds", byteBuffer);
            this.messageId = byteBuffer.getLong();
            this.blockId = byteBuffer.getLong();
            this.limit = byteBuffer.getInt();
        }

        @Override
        int getLength() {
            return super.getLength() + 8 + 8 + 4;
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId).putLong(this.blockId).putInt(this.limit);
        }

        @Override
        boolean requiresResponse() {
            return true;
        }

        @Override
        boolean downloadNotAllowed() {
            return true;
        }

        public long getBlockId() {
            return this.blockId;
        }

        public int getLimit() {
            return this.limit;
        }
    }

    public static class MilestoneBlockIdsMessage
    extends NetworkMessage {
        private final boolean isLastBlock;
        private final List<Long> blockIds;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new MilestoneBlockIdsMessage(byteBuffer);
        }

        private MilestoneBlockIdsMessage() {
            super("MilestoneBlockIds");
            this.messageId = 0L;
            this.isLastBlock = false;
            this.blockIds = null;
        }

        public MilestoneBlockIdsMessage(long l, boolean bl, List<Long> list) {
            super("MilestoneBlockIds");
            if (list.size() > 1500) {
                throw new RuntimeException("List size " + list.size() + " exceeds the maximum of " + 1500);
            }
            this.messageId = l;
            this.isLastBlock = bl;
            this.blockIds = list;
        }

        private MilestoneBlockIdsMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("MilestoneBlockIds", byteBuffer);
            this.messageId = byteBuffer.getLong();
            this.isLastBlock = byteBuffer.get() != 0;
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 1500) {
                throw new NetworkException("List size " + n + " exceeds the maximum of " + 1500);
            }
            this.blockIds = new ArrayList<Long>(n);
            for (int i = 0; i < n; ++i) {
                this.blockIds.add(byteBuffer.getLong());
            }
        }

        @Override
        int getLength() {
            return super.getLength() + 8 + 1 + 2 + 8 * this.blockIds.size();
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId);
            byteBuffer.put(this.isLastBlock ? (byte)1 : 0);
            byteBuffer.putShort((short)this.blockIds.size());
            this.blockIds.forEach(byteBuffer::putLong);
        }

        @Override
        boolean isResponse() {
            return true;
        }

        public boolean isLastBlock() {
            return this.isLastBlock;
        }

        public List<Long> getBlockIds() {
            return this.blockIds;
        }
    }

    public static class GetMilestoneBlockIdsMessage
    extends NetworkMessage {
        private final long lastBlockId;
        private final long lastMilestoneBlockId;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new GetMilestoneBlockIdsMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return GetMilestoneBlockIds.processRequest(peerImpl, this);
        }

        private GetMilestoneBlockIdsMessage() {
            super("GetMilestoneBlockIds");
            this.messageId = 0L;
            this.lastBlockId = 0L;
            this.lastMilestoneBlockId = 0L;
        }

        public GetMilestoneBlockIdsMessage(long l, long l2) {
            super("GetMilestoneBlockIds");
            this.messageId = nextMessageId.incrementAndGet();
            this.lastBlockId = l;
            this.lastMilestoneBlockId = l2;
        }

        private GetMilestoneBlockIdsMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("GetMilestoneBlockIds", byteBuffer);
            this.messageId = byteBuffer.getLong();
            this.lastBlockId = byteBuffer.getLong();
            this.lastMilestoneBlockId = byteBuffer.getLong();
        }

        @Override
        int getLength() {
            return super.getLength() + 8 + 8 + 8;
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId).putLong(this.lastBlockId).putLong(this.lastMilestoneBlockId);
        }

        @Override
        boolean requiresResponse() {
            return true;
        }

        @Override
        boolean downloadNotAllowed() {
            return true;
        }

        public long getLastBlockId() {
            return this.lastBlockId;
        }

        public long getLastMilestoneBlockIdentifier() {
            return this.lastMilestoneBlockId;
        }
    }

    public static class AddPeersMessage
    extends NetworkMessage {
        private final List<byte[]> announcedAddressesBytes;
        private int announcedAddressesLength;
        private final List<Long> services;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new AddPeersMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return AddPeers.processRequest(peerImpl, this);
        }

        private AddPeersMessage() {
            super("AddPeers");
            this.announcedAddressesBytes = null;
            this.announcedAddressesLength = 0;
            this.services = null;
        }

        public AddPeersMessage(List<? extends Peer> list) {
            super("AddPeers");
            if (list.size() > 1500) {
                throw new RuntimeException("List size " + list.size() + " exceeds the maximum of " + 1500);
            }
            this.announcedAddressesBytes = new ArrayList<byte[]>(list.size());
            this.announcedAddressesLength = 0;
            this.services = new ArrayList<Long>(list.size());
            list.forEach(peer -> {
                String string = peer.getAnnouncedAddress();
                if (string != null) {
                    byte[] byArray = string.getBytes(UTF8);
                    this.announcedAddressesBytes.add(byArray);
                    this.announcedAddressesLength += NetworkMessage.getEncodedArrayLength(byArray);
                    this.services.add(((PeerImpl)peer).getServices());
                }
            });
        }

        private AddPeersMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("AddPeers", byteBuffer);
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 1500) {
                throw new NetworkException("List size " + n + "exceeds the maximum of " + 1500);
            }
            this.announcedAddressesBytes = new ArrayList<byte[]>(n);
            this.announcedAddressesLength = 0;
            this.services = new ArrayList<Long>(n);
            for (int i = 0; i < n; ++i) {
                byte[] byArray = NetworkMessage.decodeArray(byteBuffer);
                this.announcedAddressesBytes.add(byArray);
                this.announcedAddressesLength += NetworkMessage.getEncodedArrayLength(byArray);
                this.services.add(byteBuffer.getLong());
            }
        }

        @Override
        int getLength() {
            return super.getLength() + 2 + this.announcedAddressesLength + 8 * this.services.size();
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putShort((short)this.announcedAddressesBytes.size());
            for (int i = 0; i < this.announcedAddressesBytes.size(); ++i) {
                NetworkMessage.encodeArray(byteBuffer, this.announcedAddressesBytes.get(i));
                byteBuffer.putLong(this.services.get(i));
            }
        }

        public List<String> getAnnouncedAddresses() {
            ArrayList<String> arrayList = new ArrayList<String>(this.announcedAddressesBytes.size());
            this.announcedAddressesBytes.forEach(byArray -> arrayList.add(new String((byte[])byArray, UTF8)));
            return arrayList;
        }

        public List<Long> getServices() {
            return this.services;
        }
    }

    public static class GetPeersMessage
    extends NetworkMessage {
        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new GetPeersMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return GetPeers.processRequest(peerImpl, this);
        }

        public GetPeersMessage() {
            super("GetPeers");
        }

        private GetPeersMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("GetPeers", byteBuffer);
        }
    }

    public static class CumulativeDifficultyMessage
    extends NetworkMessage {
        private final byte[] cumulativeDifficultyBytes;
        private final int blockHeight;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new CumulativeDifficultyMessage(byteBuffer);
        }

        private CumulativeDifficultyMessage() {
            super("CumulativeDifficulty");
            this.messageId = 0L;
            this.cumulativeDifficultyBytes = null;
            this.blockHeight = 0;
        }

        public CumulativeDifficultyMessage(long l, BigInteger bigInteger, int n) {
            super("CumulativeDifficulty");
            this.messageId = l;
            this.cumulativeDifficultyBytes = bigInteger.toByteArray();
            this.blockHeight = n;
        }

        private CumulativeDifficultyMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("CumulativeDifficulty", byteBuffer);
            this.messageId = byteBuffer.getLong();
            this.cumulativeDifficultyBytes = NetworkMessage.decodeArray(byteBuffer);
            this.blockHeight = byteBuffer.getInt();
        }

        @Override
        int getLength() {
            return super.getLength() + 8 + NetworkMessage.getEncodedArrayLength(this.cumulativeDifficultyBytes) + 4;
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId);
            NetworkMessage.encodeArray(byteBuffer, this.cumulativeDifficultyBytes);
            byteBuffer.putInt(this.blockHeight);
        }

        @Override
        boolean isResponse() {
            return true;
        }

        public BigInteger getCumulativeDifficulty() {
            return new BigInteger(this.cumulativeDifficultyBytes);
        }

        public int getBlockHeight() {
            return this.blockHeight;
        }
    }

    public static class GetCumulativeDifficultyMessage
    extends NetworkMessage {
        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new GetCumulativeDifficultyMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return GetCumulativeDifficulty.processRequest(peerImpl, this);
        }

        public GetCumulativeDifficultyMessage() {
            super("GetCumulativeDifficulty");
            this.messageId = nextMessageId.incrementAndGet();
        }

        private GetCumulativeDifficultyMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("GetCumulativeDifficulty", byteBuffer);
            this.messageId = byteBuffer.getLong();
        }

        @Override
        int getLength() {
            return super.getLength() + 8;
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putLong(this.messageId);
        }

        @Override
        boolean requiresResponse() {
            return true;
        }

        @Override
        boolean downloadNotAllowed() {
            return true;
        }
    }

    public static class BundlerRateMessage
    extends NetworkMessage {
        private List<BundlerRate> rates;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new BundlerRateMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return BundlerRate.processRequest(peerImpl, this);
        }

        private BundlerRateMessage() {
            super("BundlerRate");
            this.rates = null;
        }

        public BundlerRateMessage(List<BundlerRate> list) {
            super("BundlerRate");
            list.sort(Comparator.comparingLong(BundlerRate::getAccountId));
            this.rates = list;
        }

        private BundlerRateMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("BundlerRate", byteBuffer);
            int n = byteBuffer.getShort() & 0xFFFF;
            if (n > 1500) {
                throw new NetworkException("Rate count " + n + " exceeds the maximum of " + 1500);
            }
            this.rates = new ArrayList<BundlerRate>(n);
            for (int i = 0; i < n; ++i) {
                this.rates.add(new BundlerRate(byteBuffer));
            }
        }

        @Override
        int getLength() {
            int n = super.getLength() + 2;
            for (BundlerRate bundlerRate : this.rates) {
                n += bundlerRate.getLength();
            }
            return n;
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putShort((short)this.rates.size());
            this.rates.forEach(bundlerRate -> bundlerRate.getBytes(byteBuffer));
        }

        public List<BundlerRate> getRates() {
            return this.rates;
        }

        @Override
        boolean sendToLightClient() {
            return false;
        }

        @Override
        boolean downloadNotAllowed() {
            return true;
        }
    }

    public static class BlockchainStateMessage
    extends NetworkMessage {
        private final Peer.BlockchainState blockchainState;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new BlockchainStateMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return BlockchainState.processRequest(peerImpl, this);
        }

        private BlockchainStateMessage() {
            super("BlockchainState");
            this.blockchainState = Peer.BlockchainState.UP_TO_DATE;
        }

        public BlockchainStateMessage(Peer.BlockchainState blockchainState) {
            super("BlockchainState");
            this.blockchainState = blockchainState;
        }

        private BlockchainStateMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("BlockchainState", byteBuffer);
            int n = byteBuffer.getInt();
            if (n < 0 || n >= Peer.BlockchainState.values().length) {
                throw new NetworkException("Blockchain state '" + n + "' is not valid");
            }
            this.blockchainState = Peer.BlockchainState.values()[n];
        }

        @Override
        int getLength() {
            return super.getLength() + 4;
        }

        @Override
        void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            byteBuffer.putInt(this.blockchainState.ordinal());
        }

        public Peer.BlockchainState getBlockchainState() {
            return this.blockchainState;
        }

        @Override
        boolean sendToLightClient() {
            return true;
        }
    }

    public static class GetInfoMessage
    extends NetworkMessage {
        private static final SecurityTokenFactory securityTokenFactory = SecurityTokenFactory.getSecurityTokenFactory();
        private final byte[] appNameBytes;
        private final byte[] appPlatformBytes;
        private final byte[] appVersionBytes;
        private final boolean shareAddress;
        private final byte[] announcedAddressBytes;
        private final int apiPort;
        private final int sslPort;
        private final long services;
        private final byte[] disabledAPIsBytes;
        private final int apiServerIdleTimeout;
        private final SecurityToken securityToken;
        private Peer.BlockchainState blockchainState;

        @Override
        protected NetworkMessage constructMessage(ByteBuffer byteBuffer) throws BufferOverflowException, BufferUnderflowException, NetworkException {
            return new GetInfoMessage(byteBuffer);
        }

        @Override
        NetworkMessage processMessage(PeerImpl peerImpl) {
            return GetInfo.processRequest(peerImpl, this);
        }

        private GetInfoMessage() {
            super("GetInfo");
            this.appNameBytes = null;
            this.appVersionBytes = null;
            this.appPlatformBytes = null;
            this.shareAddress = false;
            this.announcedAddressBytes = null;
            this.apiPort = 0;
            this.sslPort = 0;
            this.services = 0L;
            this.disabledAPIsBytes = null;
            this.apiServerIdleTimeout = 0;
            this.securityToken = null;
            this.blockchainState = Peer.BlockchainState.UP_TO_DATE;
        }

        public GetInfoMessage(String string, String string2, String string3, boolean bl, String string4, int n, int n2, long l, String string5, int n3, byte[] byArray) {
            super("GetInfo");
            this.appNameBytes = string.getBytes(UTF8);
            this.appVersionBytes = string2.getBytes(UTF8);
            this.appPlatformBytes = string3.getBytes(UTF8);
            this.shareAddress = bl;
            this.announcedAddressBytes = string4 != null ? string4.getBytes(UTF8) : Convert.EMPTY_BYTE;
            this.apiPort = n;
            this.sslPort = n2;
            this.services = l;
            this.disabledAPIsBytes = string5 != null ? string5.getBytes(UTF8) : Convert.EMPTY_BYTE;
            this.apiServerIdleTimeout = n3;
            this.blockchainState = Peer.BlockchainState.UP_TO_DATE;
            this.securityToken = byArray != null && securityTokenFactory != null ? securityTokenFactory.getSecurityToken(byArray) : null;
        }

        private GetInfoMessage(ByteBuffer byteBuffer) throws BufferUnderflowException, NetworkException {
            super("GetInfo", byteBuffer);
            this.appNameBytes = NetworkMessage.decodeArray(byteBuffer);
            this.appVersionBytes = NetworkMessage.decodeArray(byteBuffer);
            this.appPlatformBytes = NetworkMessage.decodeArray(byteBuffer);
            this.shareAddress = byteBuffer.get() != 0;
            this.announcedAddressBytes = NetworkMessage.decodeArray(byteBuffer);
            this.apiPort = byteBuffer.getShort() & 0xFFFF;
            this.sslPort = byteBuffer.getShort() & 0xFFFF;
            this.services = byteBuffer.getLong();
            this.disabledAPIsBytes = NetworkMessage.decodeArray(byteBuffer);
            this.apiServerIdleTimeout = byteBuffer.getInt();
            int n = byteBuffer.getInt();
            if (n < 0 || n >= Peer.BlockchainState.values().length) {
                throw new NetworkException("Blockchain state '" + n + "' is not valid");
            }
            this.blockchainState = Peer.BlockchainState.values()[n];
            if (byteBuffer.hasRemaining()) {
                short s = byteBuffer.getShort();
                if (s != 0) {
                    if (securityTokenFactory != null) {
                        this.securityToken = securityTokenFactory.getSecurityToken(byteBuffer);
                    } else {
                        byteBuffer.position(byteBuffer.position() + s);
                        this.securityToken = null;
                    }
                } else {
                    this.securityToken = null;
                }
            } else {
                this.securityToken = null;
            }
        }

        @Override
        int getLength() {
            return super.getLength() + NetworkMessage.getEncodedArrayLength(this.appNameBytes) + NetworkMessage.getEncodedArrayLength(this.appVersionBytes) + NetworkMessage.getEncodedArrayLength(this.appPlatformBytes) + 1 + NetworkMessage.getEncodedArrayLength(this.announcedAddressBytes) + 2 + 2 + 8 + NetworkMessage.getEncodedArrayLength(this.disabledAPIsBytes) + 4 + 4 + 2 + (this.securityToken != null ? this.securityToken.getLength() : 0);
        }

        @Override
        synchronized void getBytes(ByteBuffer byteBuffer) throws BufferOverflowException {
            super.getBytes(byteBuffer);
            NetworkMessage.encodeArray(byteBuffer, this.appNameBytes);
            NetworkMessage.encodeArray(byteBuffer, this.appVersionBytes);
            NetworkMessage.encodeArray(byteBuffer, this.appPlatformBytes);
            byteBuffer.put(this.shareAddress ? (byte)1 : 0);
            NetworkMessage.encodeArray(byteBuffer, this.announcedAddressBytes);
            byteBuffer.putShort((short)this.apiPort).putShort((short)this.sslPort).putLong(this.services);
            NetworkMessage.encodeArray(byteBuffer, this.disabledAPIsBytes);
            byteBuffer.putInt(this.apiServerIdleTimeout);
            byteBuffer.putInt(this.blockchainState.ordinal());
            if (this.securityToken != null) {
                byteBuffer.putShort((short)this.securityToken.getLength());
                this.securityToken.getBytes(byteBuffer);
            } else {
                byteBuffer.putShort((short)0);
            }
        }

        public String getApplicationName() {
            return this.appNameBytes.length > 0 ? new String(this.appNameBytes, UTF8) : null;
        }

        public String getApplicationVersion() {
            return this.appVersionBytes.length > 0 ? new String(this.appVersionBytes, UTF8) : null;
        }

        public String getApplicationPlatform() {
            return this.appPlatformBytes.length > 0 ? new String(this.appPlatformBytes, UTF8) : null;
        }

        public boolean getShareAddress() {
            return this.shareAddress;
        }

        public String getAnnouncedAddress() {
            return this.announcedAddressBytes.length > 0 ? new String(this.announcedAddressBytes, UTF8) : null;
        }

        public int getApiPort() {
            return this.apiPort;
        }

        public int getSslPort() {
            return this.sslPort;
        }

        public long getServices() {
            return this.services;
        }

        public String getDisabledAPIs() {
            return this.disabledAPIsBytes.length > 0 ? new String(this.disabledAPIsBytes, UTF8) : null;
        }

        public int getApiServerIdleTimeout() {
            return this.apiServerIdleTimeout;
        }

        public synchronized Peer.BlockchainState getBlockchainState() {
            return this.blockchainState;
        }

        public synchronized void setBlockchainState(Peer.BlockchainState blockchainState) {
            this.blockchainState = blockchainState;
        }

        public SecurityToken getSecurityToken() {
            return this.securityToken;
        }
    }
}

