/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nxt.db.Table;
import nxt.peer.PeerImpl;

final class PeerDb {
    private static final Table peerTable = new Table("PUBLIC.PEER");

    PeerDb() {
    }

    static List<Entry> loadPeers() {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        try (Connection connection = peerTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM peer");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                arrayList.add(new Entry(resultSet.getString("address"), resultSet.getLong("services"), resultSet.getInt("last_updated")));
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        return arrayList;
    }

    static void deletePeers(Collection<Entry> collection) {
        try (Connection connection = peerTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM peer WHERE address = ?");){
            for (Entry entry : collection) {
                preparedStatement.setString(1, entry.getAddress());
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    static void updatePeers(Collection<Entry> collection) {
        try (Connection connection = peerTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO peer (address, services, last_updated) KEY(address) VALUES(?, ?, ?)");){
            for (Entry entry : collection) {
                preparedStatement.setString(1, entry.getAddress());
                preparedStatement.setLong(2, entry.getServices());
                preparedStatement.setInt(3, entry.getLastUpdated());
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    static void updatePeer(PeerImpl peerImpl) {
        try (Connection connection = peerTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO peer (address, services, last_updated) KEY(address) VALUES(?, ?, ?)");){
            preparedStatement.setString(1, peerImpl.getAnnouncedAddress());
            preparedStatement.setLong(2, peerImpl.getServices());
            preparedStatement.setInt(3, peerImpl.getLastUpdated());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    static class Entry {
        private final String address;
        private final long services;
        private final int lastUpdated;

        Entry(String string, long l, int n) {
            this.address = string;
            this.services = l;
            this.lastUpdated = n;
        }

        public String getAddress() {
            return this.address;
        }

        public long getServices() {
            return this.services;
        }

        public int getLastUpdated() {
            return this.lastUpdated;
        }

        public int hashCode() {
            return this.address.hashCode();
        }

        public boolean equals(Object object) {
            return object != null && object instanceof Entry && this.address.equals(((Entry)object).address);
        }
    }
}

