/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import nxt.Constants;
import nxt.Nxt;
import nxt.account.Account;
import nxt.authentication.Role;
import nxt.authentication.RoleMapperFactory;
import nxt.blockchain.Bundler;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.configuration.SubSystem;
import nxt.crypto.Crypto;
import nxt.dbschema.Db;
import nxt.http.API;
import nxt.peer.BundlerRate;
import nxt.peer.NetworkHandler;
import nxt.peer.NetworkMessage;
import nxt.peer.Peer;
import nxt.peer.PeerDb;
import nxt.peer.PeerImpl;
import nxt.util.Convert;
import nxt.util.Filter;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;
import nxt.util.QueuedThreadPool;
import nxt.util.ThreadPool;
import nxt.util.security.BlockchainPermission;

public final class Peers {
    static final int MAX_VERSION_LENGTH = 10;
    static final int MAX_APPLICATION_LENGTH = 20;
    static final int MAX_PLATFORM_LENGTH = 30;
    static final int MAX_ANNOUNCED_ADDRESS_LENGTH = 100;
    static final int BUNDLER_RATE_BROADCAST_INTERVAL = 1800;
    public static final int LOG_LEVEL_NAMES = 1;
    public static final int LOG_LEVEL_DETAILS = 2;
    static final int blacklistingPeriod = Nxt.getIntProperty("nxt.blacklistingPeriod", 600);
    private static int communicationLogging = Nxt.getIntProperty("nxt.communicationLogging", 0);
    private static final boolean getMorePeers = Nxt.getBooleanProperty("nxt.getMorePeers");
    private static final int maxNumberOfKnownPeers = Math.max(100, Nxt.getIntProperty("nxt.maxNumberOfKnownPeers", 2000));
    private static final int minNumberOfKnownPeers = Math.max(100, Math.min(maxNumberOfKnownPeers, Nxt.getIntProperty("nxt.minNumberOfKnownPeers", 1000)));
    private static final boolean usePeersDb = Nxt.getBooleanProperty("nxt.usePeersDb");
    private static final boolean savePeers = Nxt.getBooleanProperty("nxt.savePeers");
    static final boolean hideErrorDetails = Nxt.getBooleanProperty("nxt.hideErrorDetails");
    static final boolean ignorePeerAnnouncedAddress = Nxt.getBooleanProperty("nxt.ignorePeerAnnouncedAddress");
    private static final Set<Long> blacklistedBundlerAccounts = new HashSet<Long>();
    private static final Set<Long> bestBundlerRateWhitelist;
    static final String peerSecretPhrase;
    static final List<Peer.Service> myServices;
    private static final List<String> wellKnownPeers;
    static final Set<String> knownBlacklistedPeers;
    private static final Listeners<Peer, Event> listeners;
    private static final ConcurrentMap<String, PeerImpl> peers;
    private static final ConcurrentMap<String, String> selfAnnouncedAddresses;
    private static final Collection<Peer> allPeers;
    static final ExecutorService peersService;
    private static final int startTime;
    private static Peer.BlockchainState broadcastBlockchainState;
    private static int ratesTime;
    private static volatile boolean bundlersChanged;
    private static final Map<Long, List<BundlerRate>> bundlerRates;
    private static volatile boolean isNetworkingEnabled;
    private static final Runnable peerUnBlacklistingThread;
    private static final Runnable peerConnectingThread;
    private static final Runnable getMorePeersThread;
    private static final Runnable updatePeerDbThread;
    private static final int[] MAX_VERSION;

    public static Set<Long> getBestBundlerRateWhitelist() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("getBundlerRates"));
        }
        return bestBundlerRateWhitelist;
    }

    public static void init() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        if (Constants.isOffline) {
            Logger.logInfoMessage("Peer services are offline");
            return;
        }
        final List<String> list = Constants.isTestnet ? Nxt.getStringListProperty("nxt.defaultTestnetPeers") : Nxt.getStringListProperty("nxt.defaultPeers");
        final List list2 = Collections.synchronizedList(new ArrayList());
        if (Constants.isPermissioned && peerSecretPhrase != null) {
            byte[] byArray = Crypto.getPublicKey(peerSecretPhrase);
            long l = Account.getId(byArray);
            if (!RoleMapperFactory.getRoleMapper().isUserInRole(l, Role.WRITER)) {
                Logger.logWarningMessage("WARNING: Account " + Convert.rsAccount(l) + " does not have WRITER permission");
            }
        }
        ThreadPool.runBeforeStart(new Runnable(){
            private final Set<PeerDb.Entry> entries = new HashSet<PeerDb.Entry>();

            @Override
            public void run() {
                wellKnownPeers.forEach(string -> this.entries.add(new PeerDb.Entry((String)string, 0L, startTime - 1)));
                if (usePeersDb) {
                    Logger.logDebugMessage("Loading known peers from the database...");
                    list.forEach(string -> this.entries.add(new PeerDb.Entry((String)string, 0L, startTime - 1)));
                    if (savePeers) {
                        List<PeerDb.Entry> list3 = PeerDb.loadPeers();
                        list3.forEach(entry -> {
                            if (!this.entries.add((PeerDb.Entry)entry)) {
                                this.entries.remove(entry);
                                this.entries.add((PeerDb.Entry)entry);
                            }
                        });
                    }
                }
                this.entries.forEach(entry -> {
                    Future<String> future = peersService.submit(() -> {
                        PeerImpl peerImpl = (PeerImpl)Peers.findOrCreatePeer(entry.getAddress(), true);
                        if (peerImpl != null) {
                            peerImpl.setShareAddress(true);
                            peerImpl.setLastUpdated(entry.getLastUpdated());
                            peerImpl.setServices(entry.getServices());
                            Peers.addPeer(peerImpl);
                            return null;
                        }
                        return entry.getAddress();
                    });
                    list2.add(future);
                });
            }
        }, false);
        ThreadPool.runAfterStart(() -> {
            for (Future future : list2) {
                try {
                    String string = (String)future.get(5L, TimeUnit.SECONDS);
                    if (string == null) continue;
                    Logger.logDebugMessage("Failed to resolve peer address: " + string);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    Logger.logDebugMessage("Failed to add peer", executionException);
                }
                catch (TimeoutException timeoutException) {}
            }
            Logger.logDebugMessage("Known peers: " + peers.size());
        });
        ThreadPool.scheduleThread("PeerUnBlacklisting", peerUnBlacklistingThread, 60);
        ThreadPool.scheduleThread("PeerConnecting", peerConnectingThread, 15);
        if (getMorePeers) {
            ThreadPool.scheduleThread("GetMorePeers", getMorePeersThread, 600);
        }
        if (savePeers) {
            ThreadPool.scheduleThread("UpdatePeerDb", updatePeerDbThread, 3600);
        }
    }

    public static void shutdown() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        ThreadPool.shutdownExecutor("peersService", peersService, 5);
    }

    public static void disableNetworking() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        isNetworkingEnabled = false;
        Peers.getConnectedPeersInternal().forEach(PeerImpl::disconnectPeer);
    }

    public static void enableNetworking() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        isNetworkingEnabled = true;
    }

    public static boolean isNetworkingEnabled() {
        return isNetworkingEnabled;
    }

    public static boolean addListener(Listener<Peer> listener, Event event) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Peer> listener, Event event) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        return listeners.removeListener(listener, event);
    }

    static void notifyListeners(Peer peer, Event event) {
        listeners.notify(peer, event);
    }

    public static boolean addPeer(Peer peer) {
        Peer peer2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        if ((peer2 = (Peer)peers.put(peer.getHost(), (PeerImpl)peer)) != null) {
            return false;
        }
        selfAnnouncedAddresses.put(peer.getAnnouncedAddress(), peer.getHost());
        listeners.notify(peer, Event.ADD_PEER);
        return true;
    }

    static void changePeerAnnouncedAddress(PeerImpl peerImpl, String string) {
        selfAnnouncedAddresses.remove(peerImpl.getAnnouncedAddress());
        peerImpl.setAnnouncedAddress(string);
        selfAnnouncedAddresses.put(peerImpl.getAnnouncedAddress(), peerImpl.getHost());
        listeners.notify(peerImpl, Event.CHANGE_ANNOUNCED_ADDRESS);
    }

    public static boolean removePeer(Peer peer) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        if (peer.getAnnouncedAddress() != null) {
            selfAnnouncedAddresses.remove(peer.getAnnouncedAddress());
        }
        if (peers.remove(peer.getHost()) == null) {
            return false;
        }
        Peers.notifyListeners(peer, Event.REMOVE_PEER);
        return true;
    }

    public static List<Peer.Service> getServices() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        return myServices;
    }

    public static Peer findOrCreatePeer(String string, boolean bl) {
        InetAddress inetAddress;
        int n;
        String string2;
        PeerImpl peerImpl;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        if (string == null) {
            return null;
        }
        String string3 = string.toLowerCase().trim();
        String string4 = (String)selfAnnouncedAddresses.get(string3);
        if (string4 != null && (peerImpl = (PeerImpl)peers.get(string4)) != null) {
            return peerImpl;
        }
        try {
            URI uRI = new URI("http://" + string3);
            string2 = uRI.getHost();
            if (string2 == null) {
                return null;
            }
            n = uRI.getPort() == -1 ? NetworkHandler.getDefaultPeerPort() : uRI.getPort();
            inetAddress = InetAddress.getByName(string2);
        }
        catch (URISyntaxException | UnknownHostException exception) {
            return null;
        }
        if (Constants.isTestnet && n != NetworkHandler.TESTNET_PEER_PORT) {
            Logger.logDebugMessage("Peer " + string2 + " on testnet is not using port " + NetworkHandler.TESTNET_PEER_PORT + ", ignoring");
            return null;
        }
        if (!Constants.isTestnet && n == NetworkHandler.TESTNET_PEER_PORT) {
            Logger.logDebugMessage("Peer " + string2 + " is using testnet port " + NetworkHandler.TESTNET_PEER_PORT + ", ignoring");
            return null;
        }
        return Peers.findOrCreatePeer(inetAddress, string3, bl);
    }

    static PeerImpl findOrCreatePeer(InetAddress inetAddress) {
        return Peers.findOrCreatePeer(inetAddress, inetAddress.getHostAddress(), true);
    }

    private static PeerImpl findOrCreatePeer(InetAddress inetAddress, String string, boolean bl) {
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) {
            return null;
        }
        String string2 = inetAddress.getHostAddress();
        PeerImpl peerImpl = (PeerImpl)peers.get(string2);
        if (peerImpl != null) {
            return peerImpl;
        }
        if (!bl) {
            return null;
        }
        if (NetworkHandler.announcedAddress != null && NetworkHandler.announcedAddress.equalsIgnoreCase(string)) {
            return null;
        }
        if (string != null && string.length() > 100) {
            return null;
        }
        peerImpl = new PeerImpl(inetAddress, string);
        return peerImpl;
    }

    public static Peer getPeer(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        return (Peer)peers.get(string);
    }

    public static Peer getAnyPeer(Filter<Peer> filter) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        ArrayList arrayList = new ArrayList(peers.values());
        return Peers.getAnyPeer(arrayList, filter);
    }

    public static Peer getAnyPeer(List<? extends Peer> list) {
        return Peers.getAnyPeer(list, null);
    }

    public static Peer getAnyPeer(List<? extends Peer> list, Filter<Peer> filter) {
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        if (list.isEmpty()) {
            return null;
        }
        Peer peer = null;
        int n2 = ThreadLocalRandom.current().nextInt(list.size());
        boolean bl = false;
        for (n = n2; n < list.size(); ++n) {
            peer = list.get(n);
            if (filter != null && !filter.ok(peer)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (n = 0; n < n2; ++n) {
                peer = list.get(n);
                if (filter != null && !filter.ok(peer)) continue;
                bl = true;
                break;
            }
        }
        return bl ? peer : null;
    }

    public static List<Peer> getPeers(Filter<Peer> filter) {
        return Peers.getPeers(filter, Integer.MAX_VALUE);
    }

    public static List<Peer> getPeers(Filter<Peer> filter, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        ArrayList<Peer> arrayList = new ArrayList<Peer>();
        for (Peer peer : peers.values()) {
            if (!filter.ok(peer)) continue;
            arrayList.add(peer);
            if (arrayList.size() < n) continue;
            break;
        }
        return arrayList;
    }

    public static Collection<Peer> getAllPeers() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        return allPeers;
    }

    public static List<Peer> getConnectedPeers() {
        return new ArrayList<Peer>(Peers.getConnectedPeersInternal());
    }

    public static int getConnectedPeersCount() {
        return Peers.getConnectedPeersInternal().size();
    }

    private static Collection<PeerImpl> getConnectedPeersInternal() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        if (Nxt.isEnabled(SubSystem.PEER_NETWORKING)) {
            return NetworkHandler.connectionMap.values();
        }
        return Collections.emptyList();
    }

    static boolean shouldGetMorePeers() {
        return getMorePeers;
    }

    static boolean hasTooManyKnownPeers() {
        return peers.size() >= maxNumberOfKnownPeers;
    }

    public static boolean isOldVersion(String string, int[] nArray) {
        if (string == null) {
            return true;
        }
        String[] stringArray = string.endsWith("e") ? string.substring(0, string.length() - 1).split("\\.") : string.split("\\.");
        for (int i = 0; i < nArray.length && i < stringArray.length; ++i) {
            try {
                int n = Integer.parseInt(stringArray[i]);
                if (n > nArray[i]) {
                    return false;
                }
                if (n >= nArray[i]) continue;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
        }
        return stringArray.length < nArray.length;
    }

    static boolean isNewVersion(String string) {
        if (string == null) {
            return true;
        }
        String[] stringArray = string.endsWith("e") ? string.substring(0, string.length() - 1).split("\\.") : string.split("\\.");
        for (int i = 0; i < MAX_VERSION.length && i < stringArray.length; ++i) {
            try {
                int n = Integer.parseInt(stringArray[i]);
                if (n > MAX_VERSION[i]) {
                    return true;
                }
                if (n >= MAX_VERSION[i]) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
        }
        return stringArray.length > MAX_VERSION.length;
    }

    public static Peer.BlockchainState getMyBlockchainState() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        return Constants.isLightClient ? Peer.BlockchainState.LIGHT_CLIENT : (Nxt.getBlockchainProcessor().isDownloading() || Nxt.getBlockchain().getLastBlockTimestamp() < Nxt.getEpochTime() - 600 ? Peer.BlockchainState.DOWNLOADING : (Nxt.getBlockchain().getLastBlock().getBaseTarget() / Constants.INITIAL_BASE_TARGET > 10L && !Constants.isTestnet ? Peer.BlockchainState.FORK : Peer.BlockchainState.UP_TO_DATE));
    }

    static void updateBundlerRates(Peer peer, NetworkMessage.BundlerRateMessage bundlerRateMessage, List<BundlerRate> list) {
        if (!list.isEmpty() && Peers.updateAccountRates(list)) {
            Logger.logDebugMessage("Relaying bundler rates from " + peer.getHost());
            NetworkHandler.broadcastMessage(peer, bundlerRateMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMyBundlerRates() {
        int n = Nxt.getEpochTime();
        Object object = bundlerRates;
        synchronized (object) {
            Iterator<Map.Entry<Long, List<BundlerRate>>> iterator = bundlerRates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, List<BundlerRate>> entry = iterator.next();
                List<BundlerRate> list = entry.getValue();
                list.removeIf(bundlerRate -> bundlerRate.getTimestamp() < n - 2700);
                if (!list.isEmpty()) continue;
                iterator.remove();
            }
        }
        object = Bundler.getBundlerRates();
        if (!object.isEmpty()) {
            object.sort(Comparator.comparingLong(BundlerRate::getAccountId));
            long l = 0L;
            long l2 = 0L;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                BundlerRate bundlerRate2 = (BundlerRate)iterator.next();
                if (bundlerRate2.getAccountId() != l) {
                    Account account = Account.getAccount(bundlerRate2.getAccountId());
                    if (account == null) {
                        Logger.logDebugMessage("Local bundler account " + Long.toUnsignedString(bundlerRate2.getAccountId()) + " does not exist");
                        continue;
                    }
                    l2 = account.getEffectiveBalanceFXT();
                    l = bundlerRate2.getAccountId();
                }
                bundlerRate2.setBalance(l2);
            }
            Peers.updateAccountRates((List<BundlerRate>)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateAccountRates(List<BundlerRate> list) {
        boolean bl = false;
        Map<Long, List<BundlerRate>> map = bundlerRates;
        synchronized (map) {
            for (BundlerRate bundlerRate : list) {
                long l = bundlerRate.getAccountId();
                List<BundlerRate> list2 = bundlerRates.get(l);
                BundlerRate bundlerRate2 = null;
                if (list2 != null) {
                    for (BundlerRate bundlerRate3 : list2) {
                        if (bundlerRate3.getChain() != bundlerRate.getChain()) continue;
                        bundlerRate2 = bundlerRate3;
                        break;
                    }
                }
                if (list2 == null) {
                    list2 = new ArrayList<BundlerRate>();
                    bundlerRates.put(l, list2);
                }
                if (bundlerRate2 == null || bundlerRate2.getTimestamp() < bundlerRate.getTimestamp()) {
                    if (bundlerRate2 != null) {
                        list2.remove(bundlerRate2);
                        bl = true;
                    }
                    if (bundlerRate.getRate() >= 0L) {
                        list2.add(bundlerRate);
                        bl = true;
                    }
                }
                if (!list2.isEmpty()) continue;
                bundlerRates.remove(l);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forEachBundlerRate(Consumer<BundlerRate> consumer, Set<Long> set) {
        int n = Nxt.getEpochTime();
        Map<Long, List<BundlerRate>> map = bundlerRates;
        synchronized (map) {
            Iterator<Map.Entry<Long, List<BundlerRate>>> iterator = bundlerRates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, List<BundlerRate>> entry = iterator.next();
                if (set != null && !set.isEmpty() && !set.contains(entry.getKey())) continue;
                List<BundlerRate> list = entry.getValue();
                Iterator<BundlerRate> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    BundlerRate bundlerRate = iterator2.next();
                    if (bundlerRate.getTimestamp() < n - 2700) {
                        iterator2.remove();
                        continue;
                    }
                    consumer.accept(bundlerRate);
                }
                if (!list.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    public static List<BundlerRate> getBestBundlerRates(long l, long l2, Set<Long> set) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("getBundlerRates"));
        }
        HashMap<ChildChain, BundlerRate> hashMap = new HashMap<ChildChain, BundlerRate>();
        Peers.forEachBundlerRate(bundlerRate -> {
            BundlerRate bundlerRate2 = (BundlerRate)hashMap.get(bundlerRate.getChain());
            if (bundlerRate.getBalance() >= l && bundlerRate.getFeeLimit() >= l2 && (bundlerRate2 == null || bundlerRate.getRate() < bundlerRate2.getRate()) && FxtChain.FXT.getBalanceHome().getBalance(bundlerRate.getAccountId()).getUnconfirmedBalance() >= l2) {
                hashMap.put(bundlerRate.getChain(), (BundlerRate)bundlerRate);
            }
        }, set);
        ArrayList<BundlerRate> arrayList = new ArrayList<BundlerRate>();
        hashMap.forEach((childChain, bundlerRate) -> arrayList.add(new BundlerRate((ChildChain)childChain, bundlerRate.getAccountId(), bundlerRate.getRate(), bundlerRate.getFeeLimit())));
        return arrayList;
    }

    public static List<BundlerRate> getAllBundlerRates(long l) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("getBundlerRates"));
        }
        ArrayList<BundlerRate> arrayList = new ArrayList<BundlerRate>();
        Peers.forEachBundlerRate(bundlerRate -> {
            if (bundlerRate.getBalance() >= l) {
                arrayList.add((BundlerRate)bundlerRate);
            }
        }, null);
        return arrayList;
    }

    public static long getBestBundlerRate(Chain chain, long l, long l2, Set<Long> set) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("getBundlerRates"));
        }
        AtomicLong atomicLong = new AtomicLong(-1L);
        Peers.forEachBundlerRate(bundlerRate -> {
            if (bundlerRate.getChain() == chain && bundlerRate.getBalance() >= l && bundlerRate.getFeeLimit() >= l2 && (atomicLong.get() < 0L || bundlerRate.getRate() < atomicLong.get()) && FxtChain.FXT.getBalanceHome().getBalance(bundlerRate.getAccountId()).getUnconfirmedBalance() >= l2) {
                atomicLong.set(bundlerRate.getRate());
            }
        }, set);
        return atomicLong.get();
    }

    public static void broadcastBundlerRates() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        bundlersChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBundlerRates(Peer peer) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        ArrayList<BundlerRate> arrayList = new ArrayList<BundlerRate>();
        int n = Nxt.getEpochTime();
        Map<Long, List<BundlerRate>> map = bundlerRates;
        synchronized (map) {
            Iterator<Map.Entry<Long, List<BundlerRate>>> iterator = bundlerRates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, List<BundlerRate>> entry = iterator.next();
                List<BundlerRate> list = entry.getValue();
                Iterator<BundlerRate> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    BundlerRate bundlerRate = iterator2.next();
                    if (bundlerRate.getTimestamp() < n - 2700) {
                        iterator2.remove();
                        continue;
                    }
                    arrayList.add(bundlerRate);
                }
                if (!list.isEmpty()) continue;
                iterator.remove();
            }
        }
        if (!arrayList.isEmpty()) {
            peer.sendMessage(new NetworkMessage.BundlerRateMessage(arrayList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBundlerBlacklisted(long l) {
        boolean bl;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        Set<Long> set = blacklistedBundlerAccounts;
        synchronized (set) {
            bl = blacklistedBundlerAccounts.contains(l);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blacklistBundler(long l) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        Object object = blacklistedBundlerAccounts;
        synchronized (object) {
            blacklistedBundlerAccounts.add(l);
            Logger.logInfoMessage("Bundler " + Convert.rsAccount(l) + " blacklisted");
        }
        object = bundlerRates;
        synchronized (object) {
            bundlerRates.remove(l);
        }
    }

    public static boolean isLogLevelEnabled(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        return (communicationLogging & n) != 0;
    }

    public static void setCommunicationLogging(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        communicationLogging = n;
    }

    private Peers() {
    }

    static {
        Object object = Nxt.getStringListProperty("nxt.blacklistedBundlerAccounts");
        object.forEach(string -> {
            try {
                long l = Convert.parseAccountId(string);
                blacklistedBundlerAccounts.add(l);
                Logger.logInfoMessage("Bundler " + Convert.rsAccount(l) + " blacklisted");
            }
            catch (Exception exception) {
                Logger.logDebugMessage("'" + string + "' is not a valid bundler account");
            }
        });
        object = Nxt.getStringListProperty("nxt.bestBundlerRateWhitelist");
        String[] stringArray = new HashSet(object.size());
        object.forEach(string -> {
            try {
                long l = Convert.parseAccountId(string);
                stringArray.add(l);
                Logger.logInfoMessage("Added best bundler rate account " + Convert.rsAccount(l));
            }
            catch (Exception exception) {
                Logger.logDebugMessage("'" + string + "' is not a valid bundler account");
            }
        });
        bestBundlerRateWhitelist = Collections.unmodifiableSet(stringArray);
        peerSecretPhrase = Nxt.getStringProperty("nxt.credentials.secretPhrase", null, true);
        object = new ArrayList<String>();
        if (!Constants.ENABLE_PRUNING && Constants.INCLUDE_EXPIRED_PRUNABLE) {
            object.add((String)((Object)Peer.Service.PRUNABLE));
        }
        if (API.getOpenAPIPort() > 0) {
            object.add((String)((Object)Peer.Service.API));
        }
        if (API.getOpenAPISSLPort() > 0) {
            object.add((String)((Object)Peer.Service.API_SSL));
        }
        if (API.apiServerCORS) {
            object.add((String)((Object)Peer.Service.CORS));
        }
        myServices = Collections.unmodifiableList(object);
        wellKnownPeers = Constants.isTestnet ? Nxt.getStringListProperty("nxt.testnetPeers") : Nxt.getStringListProperty("nxt.wellKnownPeers");
        object = Nxt.getStringListProperty("nxt.knownBlacklistedPeers");
        knownBlacklistedPeers = object.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>((Collection<String>)object));
        listeners = new Listeners();
        peers = new ConcurrentHashMap<String, PeerImpl>();
        selfAnnouncedAddresses = new ConcurrentHashMap<String, String>();
        allPeers = Collections.unmodifiableCollection(peers.values());
        peersService = new QueuedThreadPool(2, 15);
        startTime = Nxt.getEpochTime();
        broadcastBlockchainState = Peer.BlockchainState.UP_TO_DATE;
        ratesTime = startTime;
        bundlersChanged = false;
        bundlerRates = new HashMap<Long, List<BundlerRate>>();
        isNetworkingEnabled = true;
        peerUnBlacklistingThread = () -> {
            try {
                int n = Nxt.getEpochTime();
                for (PeerImpl peerImpl : peers.values()) {
                    peerImpl.updateBlacklistedStatus(n);
                }
            }
            catch (Throwable throwable) {
                Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS", throwable);
                System.exit(1);
            }
        };
        peerConnectingThread = () -> {
            block16: {
                if (!NetworkHandler.isNetworkStarted() || !Peers.isNetworkingEnabled()) {
                    return;
                }
                try {
                    Peer.BlockchainState blockchainState;
                    Object object;
                    int n = Nxt.getEpochTime();
                    int n2 = Math.min(10, NetworkHandler.getMaxOutboundConnections() - NetworkHandler.getOutboundCount());
                    ArrayList<PeerImpl> arrayList = new ArrayList<PeerImpl>();
                    if (n2 > 0) {
                        for (String object22 : wellKnownPeers) {
                            object = (PeerImpl)Peers.findOrCreatePeer(object22, true);
                            if (object == null) {
                                Logger.logWarningMessage("Unable to create peer for well-known peer " + object22);
                                continue;
                            }
                            if (((PeerImpl)object).isBlacklisted() || !((PeerImpl)object).shareAddress() || ((PeerImpl)object).getState() == Peer.State.CONNECTED || n - ((PeerImpl)object).getLastConnectAttempt() <= 600 && ((PeerImpl)object).getLastConnectAttempt() >= startTime) continue;
                            ((PeerImpl)object).setLastConnectAttempt(n);
                            arrayList.add((PeerImpl)object);
                            if (--n2 != 0) continue;
                            break;
                        }
                    }
                    if (n2 > 0) {
                        List<Peer> list = Peers.getPeers(peer -> !(peer.isBlacklisted() || !peer.shareAddress() || peer.getState() == Peer.State.CONNECTED || n - peer.getLastUpdated() <= 3600 && peer.getLastUpdated() >= startTime || n - peer.getLastConnectAttempt() <= 600 && peer.getLastConnectAttempt() >= startTime));
                        while (!list.isEmpty() && n2 > 0) {
                            int n3 = ThreadLocalRandom.current().nextInt(list.size());
                            object = (PeerImpl)list.remove(n3);
                            ((PeerImpl)object).setLastConnectAttempt(n);
                            arrayList.add((PeerImpl)object);
                            --n2;
                        }
                    }
                    if (!arrayList.isEmpty()) {
                        arrayList.forEach(peerImpl -> peersService.execute(peerImpl::connectPeer));
                    }
                    Peers.getConnectedPeers().forEach(peer -> {
                        if (((PeerImpl)peer).isHandshakePending() && peer.getLastUpdated() < n - NetworkHandler.peerConnectTimeout) {
                            Logger.logDebugMessage("Disconnecting dead peer " + peer.getHost() + " last updated " + peer.getLastUpdated() + " at " + n);
                            peer.disconnectPeer();
                        }
                    });
                    if (peers.size() > maxNumberOfKnownPeers) {
                        int n4 = peers.size();
                        PriorityQueue<PeerImpl> priorityQueue = new PriorityQueue<PeerImpl>(peers.size(), Comparator.comparingInt(PeerImpl::getLastUpdated));
                        priorityQueue.addAll(peers.values());
                        while (peers.size() > minNumberOfKnownPeers) {
                            priorityQueue.poll().remove();
                        }
                        Logger.logDebugMessage("Reduced peer pool size from " + n4 + " to " + peers.size());
                    }
                    if ((blockchainState = Peers.getMyBlockchainState()) != broadcastBlockchainState) {
                        Logger.logDebugMessage("Broadcasting blockchain state change from " + broadcastBlockchainState.name() + " to " + blockchainState.name());
                        NetworkMessage.BlockchainStateMessage blockchainStateMessage = new NetworkMessage.BlockchainStateMessage(blockchainState);
                        NetworkHandler.broadcastMessage(blockchainStateMessage);
                        broadcastBlockchainState = blockchainState;
                    }
                    if (n - ratesTime < 1800 && !bundlersChanged) break block16;
                    Peers.updateMyBundlerRates();
                    Map<Long, List<BundlerRate>> map = bundlerRates;
                    synchronized (map) {
                        if (!bundlerRates.isEmpty()) {
                            Logger.logDebugMessage("Broadcasting our bundler rates");
                            object = new ArrayList();
                            bundlerRates.values().forEach(((List)object)::addAll);
                            NetworkHandler.broadcastMessage(new NetworkMessage.BundlerRateMessage((List<BundlerRate>)object));
                        }
                    }
                    ratesTime = n;
                    bundlersChanged = false;
                }
                catch (Throwable throwable) {
                    Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS", throwable);
                    System.exit(1);
                }
            }
        };
        getMorePeersThread = () -> {
            try {
                Peer peer = Peers.getAnyPeer(Peers.getConnectedPeers());
                if (peer != null && peer.getState() == Peer.State.CONNECTED) {
                    List<Peer> list;
                    if (peers.size() < maxNumberOfKnownPeers) {
                        peer.sendMessage(new NetworkMessage.GetPeersMessage());
                    }
                    if (!(list = Peers.getPeers(peer2 -> !peer2.isBlacklisted() && peer2.getState() == Peer.State.CONNECTED && peer2.getAnnouncedAddress() != null && peer2.shareAddress() && !peer2.getAnnouncedAddress().equals(peer.getAnnouncedAddress()), 1500)).isEmpty()) {
                        peer.sendMessage(new NetworkMessage.AddPeersMessage(list));
                    }
                }
            }
            catch (Throwable throwable) {
                Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS", throwable);
                System.exit(1);
            }
        };
        updatePeerDbThread = () -> {
            try {
                int n = Nxt.getEpochTime();
                List<PeerDb.Entry> list = PeerDb.loadPeers();
                HashMap hashMap = new HashMap(list.size());
                list.forEach(entry -> hashMap.put(entry.getAddress(), entry));
                HashMap hashMap2 = new HashMap();
                peers.values().forEach(peerImpl -> {
                    if (peerImpl.getAnnouncedAddress() != null && peerImpl.shareAddress() && !peerImpl.isBlacklisted() && n - peerImpl.getLastUpdated() < 604800) {
                        hashMap2.put(peerImpl.getAnnouncedAddress(), new PeerDb.Entry(peerImpl.getAnnouncedAddress(), peerImpl.getServices(), peerImpl.getLastUpdated()));
                    }
                });
                ArrayList<PeerDb.Entry> arrayList = new ArrayList<PeerDb.Entry>(list.size());
                list.forEach(entry -> {
                    if (hashMap2.get(entry.getAddress()) == null) {
                        arrayList.add((PeerDb.Entry)entry);
                    }
                });
                ArrayList<PeerDb.Entry> arrayList2 = new ArrayList<PeerDb.Entry>(hashMap2.size());
                hashMap2.values().forEach(entry -> {
                    PeerDb.Entry entry2 = (PeerDb.Entry)hashMap.get(entry.getAddress());
                    if (entry2 == null || entry.getLastUpdated() - entry2.getLastUpdated() > 86400) {
                        arrayList2.add((PeerDb.Entry)entry);
                    }
                });
                if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                    return;
                }
                try {
                    Db.db.beginTransaction();
                    PeerDb.deletePeers(arrayList);
                    PeerDb.updatePeers(arrayList2);
                    Db.db.commitTransaction();
                }
                catch (Exception exception) {
                    Db.db.rollbackTransaction();
                    throw exception;
                }
                finally {
                    Db.db.endTransaction();
                }
            }
            catch (Throwable throwable) {
                Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS", throwable);
                System.exit(1);
            }
        };
        Peers.addListener(peer -> peersService.submit(() -> {
            if (peer.getAnnouncedAddress() != null && !peer.isBlacklisted()) {
                try {
                    Db.db.beginTransaction();
                    PeerDb.updatePeer((PeerImpl)peer);
                    Db.db.commitTransaction();
                }
                catch (RuntimeException runtimeException) {
                    Logger.logErrorMessage("Unable to update peer database", runtimeException);
                    Db.db.rollbackTransaction();
                }
                finally {
                    Db.db.endTransaction();
                }
            }
        }), Event.CHANGE_SERVICES);
        object = "2.2.6";
        if (((String)object).endsWith("e")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        stringArray = ((String)object).split("\\.");
        MAX_VERSION = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Peers.MAX_VERSION[i] = Integer.parseInt(stringArray[i]);
        }
    }

    public static enum Event {
        BLACKLIST,
        UNBLACKLIST,
        ADD_PEER,
        CHANGE_ANNOUNCED_ADDRESS,
        CHANGE_SERVICES,
        REMOVE_PEER,
        ADD_ACTIVE_PEER,
        CHANGE_ACTIVE_PEER;

    }
}

