/*
 * Decompiled with CFR 0.152.
 */
package nxt.shuffling;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.shuffling.ShufflingAttachment;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public abstract class AbstractShufflingAttachment
extends Attachment.AbstractAttachment
implements ShufflingAttachment {
    private final byte[] shufflingFullHash;
    private final byte[] shufflingStateHash;

    AbstractShufflingAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.shufflingFullHash = new byte[32];
        byteBuffer.get(this.shufflingFullHash);
        this.shufflingStateHash = new byte[32];
        byteBuffer.get(this.shufflingStateHash);
    }

    AbstractShufflingAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.shufflingFullHash = Convert.parseHexString((String)jSONObject.get((Object)"shufflingFullHash"));
        this.shufflingStateHash = Convert.parseHexString((String)jSONObject.get((Object)"shufflingStateHash"));
    }

    AbstractShufflingAttachment(byte[] byArray, byte[] byArray2) {
        this.shufflingFullHash = byArray;
        this.shufflingStateHash = byArray2;
    }

    @Override
    protected int getMySize() {
        return 64;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.put(this.shufflingFullHash);
        byteBuffer.put(this.shufflingStateHash);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"shufflingFullHash", (Object)Convert.toHexString(this.shufflingFullHash));
        jSONObject.put((Object)"shufflingStateHash", (Object)Convert.toHexString(this.shufflingStateHash));
    }

    @Override
    public final byte[] getShufflingFullHash() {
        return this.shufflingFullHash;
    }

    @Override
    public final byte[] getShufflingStateHash() {
        return this.shufflingStateHash;
    }
}

