/*
 * Decompiled with CFR 0.152.
 */
package nxt.shuffling;

import java.io.Serializable;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import nxt.Constants;
import nxt.Nxt;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.BalanceHome;
import nxt.account.HoldingType;
import nxt.blockchain.Block;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.ChildBlockFxtTransaction;
import nxt.blockchain.ChildBlockFxtTransactionType;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.Transaction;
import nxt.crypto.AnonymouslyEncryptedData;
import nxt.crypto.Crypto;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.VersionedEntityDbTable;
import nxt.shuffling.ShufflingAttachment;
import nxt.shuffling.ShufflingCancellationAttachment;
import nxt.shuffling.ShufflingCreationAttachment;
import nxt.shuffling.ShufflingParticipantHome;
import nxt.shuffling.ShufflingProcessingAttachment;
import nxt.shuffling.ShufflingRecipientsAttachment;
import nxt.shuffling.ShufflingStage;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;

public final class ShufflingHome {
    private static final boolean deleteFinished = Nxt.getBooleanProperty("nxt.deleteFinishedShufflings");
    private static final Listeners<Shuffling, Event> listeners = new Listeners();
    private final DbKey.HashKeyFactory<Shuffling> shufflingDbKeyFactory;
    private final VersionedEntityDbTable<Shuffling> shufflingTable;
    private final ChildChain childChain;

    public static ShufflingHome forChain(ChildChain childChain) {
        if (childChain.getShufflingHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new ShufflingHome(childChain);
    }

    public static boolean addListener(Listener<Shuffling> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Shuffling> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    private ShufflingHome(ChildChain childChain) {
        this.childChain = childChain;
        this.shufflingDbKeyFactory = new DbKey.HashKeyFactory<Shuffling>("full_hash", "id"){

            @Override
            public DbKey newKey(Shuffling shuffling) {
                return shuffling.dbKey;
            }
        };
        this.shufflingTable = new VersionedEntityDbTable<Shuffling>(childChain.getSchemaTable("shuffling"), this.shufflingDbKeyFactory){

            @Override
            protected Shuffling load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Shuffling(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Shuffling shuffling) throws SQLException {
                shuffling.save(connection);
            }
        };
        Nxt.getBlockchainProcessor().addListener(block -> {
            ArrayList<Shuffling> arrayList = new ArrayList<Shuffling>();
            try (DbIterator<Shuffling> dbIterator = this.getActiveShufflings(0, -1);){
                for (Shuffling shuffling2 : dbIterator) {
                    if (shuffling2.isFull(block)) continue;
                    arrayList.add(shuffling2);
                }
            }
            arrayList.forEach(shuffling -> {
                if ((((Shuffling)shuffling).blocksRemaining = (short)(((Shuffling)shuffling).blocksRemaining - 1)) <= 0) {
                    ((Shuffling)shuffling).cancel(block);
                } else {
                    this.shufflingTable.insert((Shuffling)shuffling);
                }
            });
        }, BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
    }

    public int getCount() {
        return this.shufflingTable.getCount();
    }

    public int getActiveCount() {
        return this.shufflingTable.getCount(new DbClause.NotNullClause("blocks_remaining"));
    }

    public DbIterator<Shuffling> getAll(int n, int n2) {
        return this.shufflingTable.getAll(n, n2, " ORDER BY blocks_remaining NULLS LAST, height DESC ");
    }

    public DbIterator<Shuffling> getActiveShufflings(int n, int n2) {
        return this.shufflingTable.getManyBy((DbClause)new DbClause.NotNullClause("blocks_remaining"), n, n2, " ORDER BY blocks_remaining, height DESC ");
    }

    public DbIterator<Shuffling> getFinishedShufflings(int n, int n2) {
        return this.shufflingTable.getManyBy((DbClause)new DbClause.NullClause("blocks_remaining"), n, n2, " ORDER BY height DESC ");
    }

    public Shuffling getShuffling(byte[] byArray) {
        return (Shuffling)this.shufflingTable.get(this.shufflingDbKeyFactory.newKey(byArray));
    }

    public int getHoldingShufflingCount(long l, boolean bl) {
        DbClause dbClause;
        DbClause dbClause2 = dbClause = l != 0L ? new DbClause.LongClause("holding_id", l) : new DbClause.NullClause("holding_id");
        if (!bl) {
            dbClause = dbClause.and(new DbClause.NotNullClause("blocks_remaining"));
        }
        return this.shufflingTable.getCount(dbClause);
    }

    public DbIterator<Shuffling> getHoldingShufflings(long l, ShufflingStage shufflingStage, boolean bl, int n, int n2) {
        DbClause dbClause;
        DbClause dbClause2 = dbClause = l != 0L ? new DbClause.LongClause("holding_id", l) : new DbClause.NullClause("holding_id");
        if (!bl) {
            dbClause = dbClause.and(new DbClause.NotNullClause("blocks_remaining"));
        }
        if (shufflingStage != null) {
            dbClause = dbClause.and(new DbClause.ByteClause("stage", shufflingStage.getCode()));
        }
        return this.shufflingTable.getManyBy(dbClause, n, n2, " ORDER BY blocks_remaining NULLS LAST, height DESC ");
    }

    public DbIterator<Shuffling> getAccountShufflings(long l, boolean bl, int n, int n2) {
        Connection connection = null;
        try {
            connection = this.shufflingTable.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT shuffling.* FROM shuffling, shuffling_participant WHERE shuffling_participant.account_id = ? AND shuffling.id = shuffling_participant.shuffling_id AND shuffling.full_hash = shuffling_participant.shuffling_full_hash " + (bl ? "" : "AND shuffling.blocks_remaining IS NOT NULL ") + "AND shuffling.latest = TRUE AND shuffling_participant.latest = TRUE ORDER BY blocks_remaining NULLS LAST, height DESC " + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return this.shufflingTable.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public DbIterator<Shuffling> getAssignedShufflings(long l, int n, int n2) {
        return this.shufflingTable.getManyBy(new DbClause.LongClause("assignee_account_id", l).and(new DbClause.ByteClause("stage", ShufflingStage.PROCESSING.getCode())), n, n2, " ORDER BY blocks_remaining NULLS LAST, height DESC ");
    }

    void addShuffling(Transaction transaction, ShufflingCreationAttachment shufflingCreationAttachment) {
        Shuffling shuffling = new Shuffling(transaction, shufflingCreationAttachment);
        this.shufflingTable.insert(shuffling);
        this.childChain.getShufflingParticipantHome().addParticipant(shuffling, transaction.getSenderId(), 0);
        listeners.notify(shuffling, Event.SHUFFLING_CREATED);
    }

    static byte[] getParticipantsHash(Iterable<ShufflingParticipantHome.ShufflingParticipant> iterable) {
        MessageDigest messageDigest = Crypto.sha256();
        iterable.forEach(shufflingParticipant -> messageDigest.update(Convert.toBytes(shufflingParticipant.getAccountId())));
        return messageDigest.digest();
    }

    public final class Shuffling {
        private final ShufflingParticipantHome shufflingParticipantHome;
        private final byte[] hash;
        private final long id;
        private final DbKey dbKey;
        private final long holdingId;
        private final HoldingType holdingType;
        private final long issuerId;
        private final long amount;
        private final byte participantCount;
        private short blocksRemaining;
        private byte registrantCount;
        private ShufflingStage stage;
        private long assigneeAccountId;
        private byte[][] recipientPublicKeys;

        private Shuffling(Transaction transaction, ShufflingCreationAttachment shufflingCreationAttachment) {
            this.shufflingParticipantHome = ShufflingHome.this.childChain.getShufflingParticipantHome();
            this.id = transaction.getId();
            this.hash = transaction.getFullHash();
            this.dbKey = ShufflingHome.this.shufflingDbKeyFactory.newKey(this.hash, this.id);
            this.holdingId = shufflingCreationAttachment.getHoldingId();
            this.holdingType = shufflingCreationAttachment.getHoldingType();
            this.issuerId = transaction.getSenderId();
            this.amount = shufflingCreationAttachment.getAmount();
            this.participantCount = shufflingCreationAttachment.getParticipantCount();
            this.blocksRemaining = shufflingCreationAttachment.getRegistrationPeriod();
            this.stage = ShufflingStage.REGISTRATION;
            this.assigneeAccountId = this.issuerId;
            this.recipientPublicKeys = Convert.EMPTY_BYTES;
            this.registrantCount = 1;
        }

        private Shuffling(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.shufflingParticipantHome = ShufflingHome.this.childChain.getShufflingParticipantHome();
            this.id = resultSet.getLong("id");
            this.hash = resultSet.getBytes("full_hash");
            this.dbKey = dbKey;
            this.holdingId = resultSet.getLong("holding_id");
            this.holdingType = HoldingType.get(resultSet.getByte("holding_type"));
            this.issuerId = resultSet.getLong("issuer_id");
            this.amount = resultSet.getLong("amount");
            this.participantCount = resultSet.getByte("participant_count");
            this.blocksRemaining = resultSet.getShort("blocks_remaining");
            this.stage = ShufflingStage.get(resultSet.getByte("stage"));
            this.assigneeAccountId = resultSet.getLong("assignee_account_id");
            this.recipientPublicKeys = (byte[][])DbUtils.getArray(resultSet, "recipient_public_keys", byte[][].class, Convert.EMPTY_BYTES);
            this.registrantCount = resultSet.getByte("registrant_count");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO shuffling (id, full_hash, holding_id, holding_type, issuer_id, amount, participant_count, blocks_remaining, stage, assignee_account_id, recipient_public_keys, registrant_count, height, latest) KEY (id, full_hash, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setBytes(++n, this.hash);
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.holdingId);
                preparedStatement.setByte(++n, this.holdingType.getCode());
                preparedStatement.setLong(++n, this.issuerId);
                preparedStatement.setLong(++n, this.amount);
                preparedStatement.setByte(++n, this.participantCount);
                DbUtils.setShortZeroToNull(preparedStatement, ++n, this.blocksRemaining);
                preparedStatement.setByte(++n, this.getStage().getCode());
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.assigneeAccountId);
                DbUtils.setArrayEmptyToNull(preparedStatement, ++n, this.recipientPublicKeys);
                preparedStatement.setByte(++n, this.registrantCount);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public ShufflingParticipantHome getShufflingParticipantHome() {
            return this.shufflingParticipantHome;
        }

        public final ChildChain getChildChain() {
            return ShufflingHome.this.childChain;
        }

        public long getId() {
            return this.id;
        }

        public byte[] getFullHash() {
            return this.hash;
        }

        public long getHoldingId() {
            return this.holdingId;
        }

        public HoldingType getHoldingType() {
            return this.holdingType;
        }

        public long getIssuerId() {
            return this.issuerId;
        }

        public long getAmount() {
            return this.amount;
        }

        public byte getParticipantCount() {
            return this.participantCount;
        }

        public byte getRegistrantCount() {
            return this.registrantCount;
        }

        public short getBlocksRemaining() {
            return this.blocksRemaining;
        }

        public ShufflingStage getStage() {
            return this.stage;
        }

        private void setStage(ShufflingStage shufflingStage, long l, short s) {
            if (!this.stage.canBecome(shufflingStage)) {
                throw new IllegalStateException(String.format("Shuffling in stage %s cannot go to stage %s", new Object[]{this.stage, shufflingStage}));
            }
            if ((shufflingStage == ShufflingStage.VERIFICATION || shufflingStage == ShufflingStage.DONE) && l != 0L) {
                throw new IllegalArgumentException(String.format("Invalid assigneeAccountId %s for stage %s", new Object[]{Convert.rsAccount(l), shufflingStage}));
            }
            if ((shufflingStage == ShufflingStage.REGISTRATION || shufflingStage == ShufflingStage.PROCESSING || shufflingStage == ShufflingStage.BLAME) && l == 0L) {
                throw new IllegalArgumentException(String.format("In stage %s assigneeAccountId cannot be 0", new Object[]{shufflingStage}));
            }
            if ((shufflingStage == ShufflingStage.DONE || shufflingStage == ShufflingStage.CANCELLED) && s != 0) {
                throw new IllegalArgumentException(String.format("For stage %s remaining blocks cannot be %s", new Object[]{shufflingStage, s}));
            }
            this.stage = shufflingStage;
            this.assigneeAccountId = l;
            this.blocksRemaining = s;
            Logger.logDebugMessage("Shuffling %s entered stage %s, assignee %s, remaining blocks %s", new Object[]{Long.toUnsignedString(this.id), this.stage, Convert.rsAccount(this.assigneeAccountId), this.blocksRemaining});
        }

        public long getAssigneeAccountId() {
            return this.assigneeAccountId;
        }

        public byte[][] getRecipientPublicKeys() {
            return this.recipientPublicKeys;
        }

        public ShufflingParticipantHome.ShufflingParticipant getParticipant(long l) {
            return this.shufflingParticipantHome.getParticipant(this.hash, l);
        }

        public ShufflingParticipantHome.ShufflingParticipant getLastParticipant() {
            return this.shufflingParticipantHome.getLastParticipant(this.hash);
        }

        public byte[] getStateHash() {
            return this.stage.getHash(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ShufflingAttachment process(long l, String string, byte[] byArray) {
            AnonymouslyEncryptedData anonymouslyEncryptedData;
            Object object2;
            Serializable serializable;
            byte[][] byArray2 = Convert.EMPTY_BYTES;
            byte[] byArray3 = null;
            int n = 0;
            ArrayList<ShufflingParticipantHome.ShufflingParticipant> arrayList = new ArrayList<ShufflingParticipantHome.ShufflingParticipant>();
            Nxt.getBlockchain().readLock();
            try {
                DbIterator<ShufflingParticipantHome.ShufflingParticipant> dbIterator = this.shufflingParticipantHome.getParticipants(this.hash);
                serializable = null;
                try {
                    for (ShufflingParticipantHome.ShufflingParticipant shufflingParticipant : dbIterator) {
                        arrayList.add(shufflingParticipant);
                        if (shufflingParticipant.getNextAccountId() != l) continue;
                        byArray2 = shufflingParticipant.getData();
                        byArray3 = shufflingParticipant.getDataTransactionFullHash();
                        n = arrayList.size();
                    }
                    if (byArray3 == null) {
                        byArray3 = ShufflingHome.getParticipantsHash(arrayList);
                    }
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (dbIterator != null) {
                        if (serializable != null) {
                            try {
                                dbIterator.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            dbIterator.close();
                        }
                    }
                }
            }
            finally {
                Nxt.getBlockchain().readUnlock();
            }
            boolean bl = n == this.participantCount - 1;
            serializable = new ArrayList();
            for (Object object2 : (Object)byArray2) {
                anonymouslyEncryptedData = AnonymouslyEncryptedData.readEncryptedData((byte[])object2);
                try {
                    byte[] byArray4 = anonymouslyEncryptedData.decrypt(string);
                    serializable.add(byArray4);
                }
                catch (Exception exception) {
                    Logger.logMessage("Decryption failed", exception);
                    return bl ? new ShufflingRecipientsAttachment(this.hash, Convert.EMPTY_BYTES, byArray3) : new ShufflingProcessingAttachment(this.hash, Convert.EMPTY_BYTES, byArray3);
                }
            }
            Object object3 = byArray;
            for (int i = arrayList.size() - 1; i > n; --i) {
                ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = (ShufflingParticipantHome.ShufflingParticipant)arrayList.get(i);
                object2 = Account.getPublicKey(shufflingParticipant.getAccountId());
                anonymouslyEncryptedData = AnonymouslyEncryptedData.encrypt((byte[])object3, string, (byte[])object2, this.hash);
                object3 = anonymouslyEncryptedData.getBytes();
            }
            serializable.add(object3);
            serializable.sort(Convert.byteArrayComparator);
            if (bl) {
                HashSet<Long> hashSet = new HashSet<Long>(this.participantCount);
                Iterator iterator = serializable.iterator();
                while (iterator.hasNext()) {
                    object2 = (byte[])iterator.next();
                    if (Crypto.isCanonicalPublicKey((byte[])object2) && hashSet.add(Account.getId((byte[])object2))) continue;
                    Logger.logDebugMessage("Invalid recipient public key " + Convert.toHexString((byte[])object2));
                    return new ShufflingRecipientsAttachment(this.hash, Convert.EMPTY_BYTES, byArray3);
                }
                return new ShufflingRecipientsAttachment(this.hash, (byte[][])serializable.toArray((T[])new byte[serializable.size()][]), byArray3);
            }
            Object object4 = null;
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                object2 = (byte[])iterator.next();
                if (object4 != null && Arrays.equals((byte[])object2, object4)) {
                    Logger.logDebugMessage("Duplicate decrypted data");
                    return new ShufflingProcessingAttachment(this.hash, Convert.EMPTY_BYTES, byArray3);
                }
                if (((Object)object2).length != 32 + 64 * (this.participantCount - n - 1)) {
                    Logger.logDebugMessage("Invalid encrypted data length in process " + ((Object)object2).length);
                    return new ShufflingProcessingAttachment(this.hash, Convert.EMPTY_BYTES, byArray3);
                }
                object4 = object2;
            }
            return new ShufflingProcessingAttachment(this.hash, (byte[][])serializable.toArray((T[])new byte[serializable.size()][]), byArray3);
        }

        /*
         * Loose catch block
         */
        public ShufflingCancellationAttachment revealKeySeeds(String string, long l, byte[] byArray) {
            Nxt.getBlockchain().readLock();
            try {
                try (DbIterator<ShufflingParticipantHome.ShufflingParticipant> dbIterator = this.shufflingParticipantHome.getParticipants(this.hash);){
                    Object object;
                    Object object2;
                    if (l != this.assigneeAccountId) {
                        throw new RuntimeException(String.format("Current shuffling cancellingAccountId %s does not match %s", Convert.rsAccount(this.assigneeAccountId), Convert.rsAccount(l)));
                    }
                    if (byArray == null || !Arrays.equals(byArray, this.getStateHash())) {
                        throw new RuntimeException("Current shuffling state hash does not match");
                    }
                    long l2 = Account.getId(Crypto.getPublicKey(string));
                    byte[][] byArray2 = null;
                    while (dbIterator.hasNext()) {
                        object2 = dbIterator.next();
                        if (((ShufflingParticipantHome.ShufflingParticipant)object2).getAccountId() != l2) continue;
                        byArray2 = ((ShufflingParticipantHome.ShufflingParticipant)object2).getData();
                        break;
                    }
                    if (!dbIterator.hasNext()) {
                        throw new RuntimeException("Last participant cannot have keySeeds to reveal");
                    }
                    if (byArray2 == null) {
                        throw new RuntimeException("Account " + Convert.rsAccount(l2) + " has not submitted data");
                    }
                    object2 = this.hash;
                    ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                    byte[] byArray3 = Account.getPublicKey(dbIterator.next().getAccountId());
                    byte[] byArray4 = Crypto.getKeySeed(string, byArray3, (byte[])object2);
                    arrayList.add(byArray4);
                    byte[] byArray5 = Crypto.getPublicKey(byArray4);
                    byte[] byArray6 = null;
                    for (byte[] byArray7 : byArray2) {
                        AnonymouslyEncryptedData anonymouslyEncryptedData = AnonymouslyEncryptedData.readEncryptedData(byArray7);
                        if (!Arrays.equals(anonymouslyEncryptedData.getPublicKey(), byArray5)) continue;
                        try {
                            byArray6 = anonymouslyEncryptedData.decrypt(byArray4, byArray3);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (byArray6 == null) {
                        throw new RuntimeException("None of the encrypted data could be decrypted");
                    }
                    while (dbIterator.hasNext()) {
                        byArray3 = Account.getPublicKey(dbIterator.next().getAccountId());
                        byArray4 = Crypto.getKeySeed(string, byArray3, (byte[])object2);
                        arrayList.add(byArray4);
                        object = AnonymouslyEncryptedData.readEncryptedData(byArray6);
                        byArray6 = ((AnonymouslyEncryptedData)object).decrypt(byArray4, byArray3);
                    }
                    object = new ShufflingCancellationAttachment(this.hash, byArray2, (byte[][])arrayList.toArray((T[])new byte[arrayList.size()][]), byArray, l);
                    return object;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Nxt.getBlockchain().readUnlock();
            }
        }

        void addParticipant(long l) {
            ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = this.shufflingParticipantHome.getParticipant(this.hash, this.assigneeAccountId);
            shufflingParticipant.setNextAccountId(l);
            this.shufflingParticipantHome.addParticipant(this, l, this.registrantCount);
            this.registrantCount = (byte)(this.registrantCount + 1);
            if (this.registrantCount == this.participantCount) {
                this.setStage(ShufflingStage.PROCESSING, this.issuerId, Constants.SHUFFLING_PROCESSING_DEADLINE);
            } else {
                this.assigneeAccountId = l;
            }
            ShufflingHome.this.shufflingTable.insert(this);
            if (this.stage == ShufflingStage.PROCESSING) {
                listeners.notify(this, Event.SHUFFLING_PROCESSING_ASSIGNED);
            }
        }

        void updateParticipantData(Transaction transaction, ShufflingProcessingAttachment shufflingProcessingAttachment) {
            long l = transaction.getSenderId();
            byte[][] byArray = shufflingProcessingAttachment.getData();
            ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = this.shufflingParticipantHome.getParticipant(this.hash, l);
            shufflingParticipant.setData(byArray, transaction.getTimestamp());
            shufflingParticipant.setProcessed(transaction.getFullHash());
            if (byArray != null && byArray.length == 0) {
                this.cancelBy(shufflingParticipant);
                return;
            }
            this.assigneeAccountId = shufflingParticipant.getNextAccountId();
            this.blocksRemaining = Constants.SHUFFLING_PROCESSING_DEADLINE;
            ShufflingHome.this.shufflingTable.insert(this);
            listeners.notify(this, Event.SHUFFLING_PROCESSING_ASSIGNED);
        }

        void updateRecipients(Transaction transaction, ShufflingRecipientsAttachment shufflingRecipientsAttachment) {
            long l = transaction.getSenderId();
            this.recipientPublicKeys = shufflingRecipientsAttachment.getRecipientPublicKeys();
            ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = this.shufflingParticipantHome.getParticipant(this.hash, l);
            shufflingParticipant.setProcessed(transaction.getFullHash());
            if (this.recipientPublicKeys.length == 0) {
                this.cancelBy(shufflingParticipant);
                return;
            }
            shufflingParticipant.verify();
            for (byte[] byArray : this.recipientPublicKeys) {
                long l2 = Account.getId(byArray);
                if (!Account.setOrVerify(l2, byArray)) continue;
                Account.addOrGetAccount(l2).apply(byArray);
            }
            this.setStage(ShufflingStage.VERIFICATION, 0L, (short)(Constants.SHUFFLING_PROCESSING_DEADLINE + this.participantCount));
            ShufflingHome.this.shufflingTable.insert(this);
            listeners.notify(this, Event.SHUFFLING_PROCESSING_FINISHED);
        }

        void verify(long l) {
            this.shufflingParticipantHome.getParticipant(this.hash, l).verify();
            if (this.shufflingParticipantHome.getVerifiedCount(this) == this.participantCount) {
                this.distribute();
            }
        }

        void cancelBy(ShufflingParticipantHome.ShufflingParticipant shufflingParticipant, byte[][] byArray, byte[][] byArray2) {
            boolean bl;
            shufflingParticipant.cancel(byArray, byArray2);
            boolean bl2 = bl = this.stage != ShufflingStage.BLAME;
            if (bl) {
                this.setStage(ShufflingStage.BLAME, shufflingParticipant.getAccountId(), (short)(Constants.SHUFFLING_PROCESSING_DEADLINE + this.participantCount));
            }
            ShufflingHome.this.shufflingTable.insert(this);
            if (bl) {
                listeners.notify(this, Event.SHUFFLING_BLAME_STARTED);
            }
        }

        private void cancelBy(ShufflingParticipantHome.ShufflingParticipant shufflingParticipant) {
            this.cancelBy(shufflingParticipant, Convert.EMPTY_BYTES, Convert.EMPTY_BYTES);
        }

        private void distribute() {
            Object object;
            Object object2;
            if (this.recipientPublicKeys.length != this.participantCount) {
                this.cancelBy(this.getLastParticipant());
                return;
            }
            Object object3 = this.recipientPublicKeys;
            int n = ((byte[][])object3).length;
            for (int i = 0; i < n; ++i) {
                object2 = object3[i];
                object = Account.getPublicKey(Account.getId(object2));
                if (object == null || Arrays.equals(object, object2)) continue;
                this.cancelBy(this.getLastParticipant());
                return;
            }
            object3 = (Object)AccountLedger.LedgerEvent.SHUFFLING_DISTRIBUTION;
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(this.id, this.getFullHash(), ShufflingHome.this.childChain);
            object2 = null;
            try (DbIterator<ShufflingParticipantHome.ShufflingParticipant> dbIterator = this.shufflingParticipantHome.getParticipants(this.hash);){
                object = dbIterator.iterator();
                while (object.hasNext()) {
                    ShufflingParticipantHome.ShufflingParticipant object4 = (ShufflingParticipantHome.ShufflingParticipant)object.next();
                    Account account = Account.getAccount(object4.getAccountId());
                    this.holdingType.addToBalance(account, (AccountLedger.LedgerEvent)((Object)object3), ledgerEventId, this.holdingId, -this.amount);
                    if (this.holdingType == HoldingType.COIN) continue;
                    account.addToBalance(ShufflingHome.this.childChain, (AccountLedger.LedgerEvent)((Object)object3), ledgerEventId, -((ShufflingHome)ShufflingHome.this).childChain.SHUFFLING_DEPOSIT_NQT);
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            for (Object object4 : (DbIterator<ShufflingParticipantHome.ShufflingParticipant>)this.recipientPublicKeys) {
                long l = Account.getId((byte[])object4);
                Account account = Account.addOrGetAccount(l);
                account.apply((byte[])object4);
                this.holdingType.addToBalanceAndUnconfirmedBalance(account, (AccountLedger.LedgerEvent)((Object)object3), ledgerEventId, this.holdingId, this.amount);
                if (this.holdingType == HoldingType.COIN) continue;
                account.addToBalanceAndUnconfirmedBalance(ShufflingHome.this.childChain, (AccountLedger.LedgerEvent)((Object)object3), ledgerEventId, ((ShufflingHome)ShufflingHome.this).childChain.SHUFFLING_DEPOSIT_NQT);
            }
            this.setStage(ShufflingStage.DONE, 0L, (short)0);
            ShufflingHome.this.shufflingTable.insert(this);
            listeners.notify(this, Event.SHUFFLING_DONE);
            if (deleteFinished) {
                this.delete();
            }
            Logger.logDebugMessage("Shuffling %s was distributed", Long.toUnsignedString(this.id));
        }

        private void cancel(Block block) {
            Object object;
            long l = this.blame();
            try (Object object2 = this.shufflingParticipantHome.getParticipants(this.hash);){
                AccountLedger.LedgerEvent ledgerEvent = AccountLedger.LedgerEvent.SHUFFLING_CANCELLATION;
                AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(this.id, this.getFullHash(), ShufflingHome.this.childChain);
                object = ((DbIterator)object2).iterator();
                while (object.hasNext()) {
                    ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = object.next();
                    Account account = Account.getAccount(shufflingParticipant.getAccountId());
                    this.holdingType.addToUnconfirmedBalance(account, ledgerEvent, ledgerEventId, this.holdingId, this.amount);
                    if (account.getId() != l) {
                        if (this.holdingType == HoldingType.COIN) continue;
                        account.addToUnconfirmedBalance(ShufflingHome.this.childChain, ledgerEvent, ledgerEventId, ((ShufflingHome)ShufflingHome.this).childChain.SHUFFLING_DEPOSIT_NQT);
                        continue;
                    }
                    if (this.holdingType == HoldingType.COIN) {
                        account.addToUnconfirmedBalance(ShufflingHome.this.childChain, ledgerEvent, ledgerEventId, -((ShufflingHome)ShufflingHome.this).childChain.SHUFFLING_DEPOSIT_NQT);
                    }
                    account.addToBalance(ShufflingHome.this.childChain, ledgerEvent, ledgerEventId, -((ShufflingHome)ShufflingHome.this).childChain.SHUFFLING_DEPOSIT_NQT);
                }
            }
            if (l != 0L) {
                object2 = AccountLedger.newEventId(block);
                long l2 = ((ShufflingHome)ShufflingHome.this).childChain.SHUFFLING_DEPOSIT_NQT / 4L;
                for (int i = 0; i < 3; ++i) {
                    object = ShufflingHome.this.childChain.getBalanceHome().getBalance(Nxt.getBlockchain().getBlockAtHeight(block.getHeight() - i - 1).getGeneratorId());
                    ((BalanceHome.Balance)object).addToBalanceAndUnconfirmedBalance(AccountLedger.LedgerEvent.BLOCK_GENERATED, (AccountLedger.LedgerEventId)object2, l2);
                    Logger.logDebugMessage("Shuffling penalty %f %s awarded to forger at height %d", (double)l2 / (double)((ShufflingHome)ShufflingHome.this).childChain.ONE_COIN, ShufflingHome.this.childChain.getName(), block.getHeight() - i - 1);
                }
                l2 = ((ShufflingHome)ShufflingHome.this).childChain.SHUFFLING_DEPOSIT_NQT - 3L * l2;
                BalanceHome.Balance balance = ShufflingHome.this.childChain.getBalanceHome().getBalance(block.getGeneratorId());
                balance.addToBalanceAndUnconfirmedBalance(AccountLedger.LedgerEvent.BLOCK_GENERATED, (AccountLedger.LedgerEventId)object2, l2);
                Logger.logDebugMessage("Shuffling penalty %f %s awarded to forger at height %d", (double)l2 / (double)((ShufflingHome)ShufflingHome.this).childChain.ONE_COIN, ShufflingHome.this.childChain.getName(), block.getHeight());
            }
            this.setStage(ShufflingStage.CANCELLED, l, (short)0);
            ShufflingHome.this.shufflingTable.insert(this);
            listeners.notify(this, Event.SHUFFLING_CANCELLED);
            if (deleteFinished) {
                this.delete();
            }
            Logger.logDebugMessage("Shuffling %s was cancelled, blaming account %s", Long.toUnsignedString(this.id), Convert.rsAccount(l));
        }

        /*
         * WARNING - void declaration
         */
        private long blame() {
            void var3_8;
            if (this.stage == ShufflingStage.REGISTRATION) {
                Logger.logDebugMessage("Registration never completed for shuffling %s", Long.toUnsignedString(this.id));
                return 0L;
            }
            if (this.stage == ShufflingStage.PROCESSING) {
                Logger.logDebugMessage("Participant %s did not submit processing", Convert.rsAccount(this.assigneeAccountId));
                return this.assigneeAccountId;
            }
            ArrayList<ShufflingParticipantHome.ShufflingParticipant> arrayList = new ArrayList<ShufflingParticipantHome.ShufflingParticipant>();
            Throwable object22 = null;
            try (Object object = this.shufflingParticipantHome.getParticipants(this.hash);){
                while (((DbIterator)object).hasNext()) {
                    arrayList.add((ShufflingParticipantHome.ShufflingParticipant)((DbIterator)object).next());
                }
            }
            catch (Throwable throwable) {
                Throwable i = throwable;
                throw throwable;
            }
            if (this.stage == ShufflingStage.VERIFICATION) {
                for (ShufflingParticipantHome.ShufflingParticipant shufflingParticipant : arrayList) {
                    if (shufflingParticipant.getState() == ShufflingParticipantHome.State.VERIFIED) continue;
                    Logger.logDebugMessage("Participant %s did not submit verification", Convert.rsAccount(shufflingParticipant.getAccountId()));
                    return shufflingParticipant.getAccountId();
                }
                throw new RuntimeException("All participants submitted data and verifications, blame phase should not have been entered");
            }
            object = new HashSet(this.participantCount);
            boolean bl = false;
            while (var3_8 < this.participantCount - 1) {
                byte[] byArray;
                ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = (ShufflingParticipantHome.ShufflingParticipant)arrayList.get((int)var3_8);
                byte[][] byArray2 = shufflingParticipant.getKeySeeds();
                if (byArray2.length == 0) {
                    Logger.logDebugMessage("Participant %s did not reveal keys", Convert.rsAccount(shufflingParticipant.getAccountId()));
                    return shufflingParticipant.getAccountId();
                }
                byte[] byArray3 = Crypto.getPublicKey(byArray2[0]);
                AnonymouslyEncryptedData anonymouslyEncryptedData = null;
                byte[][] byArray4 = shufflingParticipant.getBlameData();
                int n = byArray4.length;
                for (int i = 0; i < n && !Arrays.equals(byArray3, (anonymouslyEncryptedData = AnonymouslyEncryptedData.readEncryptedData(byArray = byArray4[i])).getPublicKey()); ++i) {
                }
                if (anonymouslyEncryptedData == null || !Arrays.equals(byArray3, anonymouslyEncryptedData.getPublicKey())) {
                    Logger.logDebugMessage("Participant %s did not submit blame data, or revealed invalid keys", Convert.rsAccount(shufflingParticipant.getAccountId()));
                    return shufflingParticipant.getAccountId();
                }
                for (void var8_17 = var3_8 + true; var8_17 < this.participantCount; ++var8_17) {
                    boolean bl2;
                    byte[] byArray5;
                    ShufflingParticipantHome.ShufflingParticipant shufflingParticipant2 = (ShufflingParticipantHome.ShufflingParticipant)arrayList.get((int)var8_17);
                    byte[] byArray6 = Account.getPublicKey(shufflingParticipant2.getAccountId());
                    byArray = byArray2[var8_17 - var3_8 - true];
                    try {
                        byArray5 = anonymouslyEncryptedData.decrypt(byArray, byArray6);
                    }
                    catch (Exception exception) {
                        Logger.logDebugMessage("Could not decrypt data from participant %s", Convert.rsAccount(shufflingParticipant.getAccountId()));
                        return shufflingParticipant.getAccountId();
                    }
                    boolean bl3 = bl2 = var8_17 == this.participantCount - 1;
                    if (bl2) {
                        if (!Crypto.isCanonicalPublicKey(byArray3)) {
                            Logger.logDebugMessage("Participant %s submitted invalid recipient public key", Convert.rsAccount(shufflingParticipant.getAccountId()));
                            return shufflingParticipant.getAccountId();
                        }
                        byte[] byArray7 = Account.getPublicKey(Account.getId(byArray5));
                        if (byArray7 != null && !Arrays.equals(byArray7, byArray5)) {
                            Logger.logDebugMessage("Participant %s submitted colliding recipient public key", Convert.rsAccount(shufflingParticipant.getAccountId()));
                            return shufflingParticipant.getAccountId();
                        }
                        if (!object.add(Account.getId(byArray5))) {
                            Logger.logDebugMessage("Participant %s submitted duplicate recipient public key", Convert.rsAccount(shufflingParticipant.getAccountId()));
                            return shufflingParticipant.getAccountId();
                        }
                    }
                    if (shufflingParticipant2.getState() == ShufflingParticipantHome.State.CANCELLED && shufflingParticipant2.getBlameData().length == 0) break;
                    boolean bl4 = false;
                    for (byte[] byArray8 : bl2 ? this.recipientPublicKeys : shufflingParticipant2.getBlameData()) {
                        if (!Arrays.equals(byArray5, byArray8)) continue;
                        bl4 = true;
                        break;
                    }
                    if (!bl4) {
                        Logger.logDebugMessage("Participant %s did not include previous data", Convert.rsAccount(shufflingParticipant2.getAccountId()));
                        return shufflingParticipant2.getAccountId();
                    }
                    if (bl2) continue;
                    anonymouslyEncryptedData = AnonymouslyEncryptedData.readEncryptedData(byArray5);
                }
                ++var3_8;
            }
            return this.assigneeAccountId;
        }

        private void delete() {
            try (DbIterator<ShufflingParticipantHome.ShufflingParticipant> dbIterator = this.shufflingParticipantHome.getParticipants(this.hash);){
                for (ShufflingParticipantHome.ShufflingParticipant shufflingParticipant : dbIterator) {
                    shufflingParticipant.delete();
                }
            }
            ShufflingHome.this.shufflingTable.delete(this);
        }

        private boolean isFull(Block block) {
            int n = 185;
            n = this.stage == ShufflingStage.REGISTRATION ? (n += 33) : 16384;
            Transaction transaction = null;
            for (FxtTransaction fxtTransaction : block.getFxtTransactions()) {
                if (fxtTransaction.getType() != ChildBlockFxtTransactionType.INSTANCE || ((ChildBlockFxtTransaction)fxtTransaction).getChildChain() != ShufflingHome.this.childChain) continue;
                transaction = (ChildBlockFxtTransaction)fxtTransaction;
                break;
            }
            if (transaction == null) {
                return block.getFxtTransactions().size() == 10;
            }
            return transaction.getFullSize() + n > 131072;
        }
    }

    public static enum Event {
        SHUFFLING_CREATED,
        SHUFFLING_PROCESSING_ASSIGNED,
        SHUFFLING_PROCESSING_FINISHED,
        SHUFFLING_BLAME_STARTED,
        SHUFFLING_CANCELLED,
        SHUFFLING_DONE;

    }
}

