/*
 * Decompiled with CFR 0.152.
 */
package nxt.shuffling;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import nxt.Constants;
import nxt.Nxt;
import nxt.blockchain.ChildChain;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.PrunableDbTable;
import nxt.db.VersionedEntityDbTable;
import nxt.shuffling.ShufflingHome;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;

public final class ShufflingParticipantHome {
    private static final Listeners<ShufflingParticipant, Event> listeners = new Listeners();
    private final DbKey.HashLongKeyFactory<ShufflingParticipant> shufflingParticipantDbKeyFactory;
    private final VersionedEntityDbTable<ShufflingParticipant> shufflingParticipantTable;
    private final DbKey.HashLongKeyFactory<ShufflingData> shufflingDataDbKeyFactory;
    private final PrunableDbTable<ShufflingData> shufflingDataTable;
    private final ChildChain childChain;

    public static ShufflingParticipantHome forChain(ChildChain childChain) {
        if (childChain.getShufflingParticipantHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new ShufflingParticipantHome(childChain);
    }

    public static boolean addListener(Listener<ShufflingParticipant> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<ShufflingParticipant> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    private ShufflingParticipantHome(ChildChain childChain) {
        this.childChain = childChain;
        this.shufflingParticipantDbKeyFactory = new DbKey.HashLongKeyFactory<ShufflingParticipant>("shuffling_full_hash", "shuffling_id", "account_id"){

            @Override
            public DbKey newKey(ShufflingParticipant shufflingParticipant) {
                return shufflingParticipant.dbKey;
            }
        };
        this.shufflingParticipantTable = new VersionedEntityDbTable<ShufflingParticipant>(childChain.getSchemaTable("shuffling_participant"), this.shufflingParticipantDbKeyFactory){

            @Override
            protected ShufflingParticipant load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new ShufflingParticipant(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, ShufflingParticipant shufflingParticipant) throws SQLException {
                shufflingParticipant.save(connection);
            }
        };
        this.shufflingDataDbKeyFactory = new DbKey.HashLongKeyFactory<ShufflingData>("shuffling_full_hash", "shuffling_id", "account_id"){

            @Override
            public DbKey newKey(ShufflingData shufflingData) {
                return shufflingData.dbKey;
            }
        };
        this.shufflingDataTable = new PrunableDbTable<ShufflingData>(childChain.getSchemaTable("shuffling_data"), this.shufflingDataDbKeyFactory){

            @Override
            protected ShufflingData load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new ShufflingData(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, ShufflingData shufflingData) throws SQLException {
                shufflingData.save(connection);
            }
        };
    }

    public DbIterator<ShufflingParticipant> getParticipants(byte[] byArray) {
        return this.shufflingParticipantTable.getManyBy(new DbClause.LongClause("shuffling_id", Convert.fullHashToId(byArray)).and(new DbClause.BytesClause("shuffling_full_hash", byArray)), 0, -1, " ORDER BY participant_index ");
    }

    public ShufflingParticipant getParticipant(byte[] byArray, long l) {
        return (ShufflingParticipant)this.shufflingParticipantTable.get(this.shufflingParticipantDbKeyFactory.newKey(byArray, l));
    }

    ShufflingParticipant getLastParticipant(byte[] byArray) {
        return (ShufflingParticipant)this.shufflingParticipantTable.getBy(new DbClause.LongClause("shuffling_id", Convert.fullHashToId(byArray)).and(new DbClause.BytesClause("shuffling_full_hash", byArray)).and(new DbClause.NullClause("next_account_id")));
    }

    void addParticipant(ShufflingHome.Shuffling shuffling, long l, int n) {
        ShufflingParticipant shufflingParticipant = new ShufflingParticipant(shuffling, l, n);
        this.shufflingParticipantTable.insert(shufflingParticipant);
        listeners.notify(shufflingParticipant, Event.PARTICIPANT_REGISTERED);
    }

    int getVerifiedCount(ShufflingHome.Shuffling shuffling) {
        return this.shufflingParticipantTable.getCount(new DbClause.LongClause("shuffling_id", shuffling.getId()).and(new DbClause.BytesClause("shuffling_full_hash", shuffling.getFullHash())).and(new DbClause.ByteClause("state", State.VERIFIED.getCode())));
    }

    void restoreData(byte[] byArray, long l, byte[][] byArray2, int n, int n2) {
        if (byArray2 != null && this.getData(byArray, l) == null) {
            this.shufflingDataTable.insert(new ShufflingData(byArray, l, byArray2, n, n2));
        }
    }

    public byte[][] getData(byte[] byArray, long l) {
        ShufflingData shufflingData = (ShufflingData)this.shufflingDataTable.get(this.shufflingDataDbKeyFactory.newKey(byArray, Convert.fullHashToId(byArray), l));
        return shufflingData != null ? shufflingData.data : (byte[][])null;
    }

    public final class ShufflingParticipant {
        private final long shufflingId;
        private final byte[] shufflingFullHash;
        private final long accountId;
        private final DbKey dbKey;
        private final int index;
        private long nextAccountId;
        private State state;
        private byte[][] blameData;
        private byte[][] keySeeds;
        private byte[] dataTransactionFullHash;

        private ShufflingParticipant(ShufflingHome.Shuffling shuffling, long l, int n) {
            this.shufflingFullHash = shuffling.getFullHash();
            this.shufflingId = shuffling.getId();
            this.accountId = l;
            this.dbKey = ShufflingParticipantHome.this.shufflingParticipantDbKeyFactory.newKey(this.shufflingFullHash, this.shufflingId, l);
            this.index = n;
            this.state = State.REGISTERED;
            this.blameData = Convert.EMPTY_BYTES;
            this.keySeeds = Convert.EMPTY_BYTES;
        }

        private ShufflingParticipant(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.shufflingId = resultSet.getLong("shuffling_id");
            this.shufflingFullHash = resultSet.getBytes("shuffling_full_hash");
            this.accountId = resultSet.getLong("account_id");
            this.dbKey = dbKey;
            this.nextAccountId = resultSet.getLong("next_account_id");
            this.index = resultSet.getInt("participant_index");
            this.state = State.get(resultSet.getByte("state"));
            this.blameData = (byte[][])DbUtils.getArray(resultSet, "blame_data", byte[][].class, Convert.EMPTY_BYTES);
            this.keySeeds = (byte[][])DbUtils.getArray(resultSet, "key_seeds", byte[][].class, Convert.EMPTY_BYTES);
            this.dataTransactionFullHash = resultSet.getBytes("data_transaction_full_hash");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO shuffling_participant (shuffling_id, shuffling_full_hash, account_id, next_account_id, participant_index, state, blame_data, key_seeds, data_transaction_full_hash, height, latest) KEY (shuffling_id, shuffling_full_hash, account_id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.shufflingId);
                preparedStatement.setBytes(++n, this.shufflingFullHash);
                preparedStatement.setLong(++n, this.accountId);
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.nextAccountId);
                preparedStatement.setInt(++n, this.index);
                preparedStatement.setByte(++n, this.getState().getCode());
                DbUtils.setArrayEmptyToNull(preparedStatement, ++n, this.blameData);
                DbUtils.setArrayEmptyToNull(preparedStatement, ++n, this.keySeeds);
                DbUtils.setBytes(preparedStatement, ++n, this.dataTransactionFullHash);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public ChildChain getChildChain() {
            return ShufflingParticipantHome.this.childChain;
        }

        public long getShufflingId() {
            return this.shufflingId;
        }

        public byte[] getShufflingFullHash() {
            return this.shufflingFullHash;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public long getNextAccountId() {
            return this.nextAccountId;
        }

        void setNextAccountId(long l) {
            if (this.nextAccountId != 0L) {
                throw new IllegalStateException("nextAccountId already set to " + Long.toUnsignedString(this.nextAccountId));
            }
            this.nextAccountId = l;
            ShufflingParticipantHome.this.shufflingParticipantTable.insert(this);
        }

        public int getIndex() {
            return this.index;
        }

        public State getState() {
            return this.state;
        }

        private void setState(State state) {
            if (!this.state.canBecome(state)) {
                throw new IllegalStateException(String.format("Shuffling participant in state %s cannot go to state %s", new Object[]{this.state, state}));
            }
            this.state = state;
            Logger.logDebugMessage("Shuffling participant %s changed state to %s", new Object[]{Long.toUnsignedString(this.accountId), this.state});
        }

        public byte[][] getData() {
            return ShufflingParticipantHome.this.getData(this.shufflingFullHash, this.accountId);
        }

        void setData(byte[][] byArray, int n) {
            if (byArray != null && Nxt.getEpochTime() - n < Constants.MAX_PRUNABLE_LIFETIME && this.getData() == null) {
                ShufflingParticipantHome.this.shufflingDataTable.insert(new ShufflingData(this.shufflingFullHash, this.accountId, byArray, n, Nxt.getBlockchain().getHeight()));
            }
        }

        public byte[][] getBlameData() {
            return this.blameData;
        }

        public byte[][] getKeySeeds() {
            return this.keySeeds;
        }

        void cancel(byte[][] byArray, byte[][] byArray2) {
            if (this.keySeeds.length > 0) {
                throw new IllegalStateException("keySeeds already set");
            }
            this.blameData = byArray;
            this.keySeeds = byArray2;
            this.setState(State.CANCELLED);
            ShufflingParticipantHome.this.shufflingParticipantTable.insert(this);
            listeners.notify(this, Event.PARTICIPANT_CANCELLED);
        }

        public byte[] getDataTransactionFullHash() {
            return this.dataTransactionFullHash;
        }

        void setProcessed(byte[] byArray) {
            if (this.dataTransactionFullHash != null) {
                throw new IllegalStateException("dataTransactionFullHash already set");
            }
            this.setState(State.PROCESSED);
            this.dataTransactionFullHash = byArray;
            ShufflingParticipantHome.this.shufflingParticipantTable.insert(this);
            listeners.notify(this, Event.PARTICIPANT_PROCESSED);
        }

        public ShufflingParticipant getPreviousParticipant() {
            if (this.index == 0) {
                return null;
            }
            return (ShufflingParticipant)ShufflingParticipantHome.this.shufflingParticipantTable.getBy(new DbClause.LongClause("shuffling_id", this.shufflingId).and(new DbClause.IntClause("participant_index", this.index - 1)));
        }

        void verify() {
            this.setState(State.VERIFIED);
            ShufflingParticipantHome.this.shufflingParticipantTable.insert(this);
            listeners.notify(this, Event.PARTICIPANT_VERIFIED);
        }

        void delete() {
            ShufflingParticipantHome.this.shufflingParticipantTable.delete(this);
        }
    }

    private final class ShufflingData {
        private final byte[] shufflingFullHash;
        private final long shufflingId;
        private final long accountId;
        private final DbKey dbKey;
        private final byte[][] data;
        private final int transactionTimestamp;
        private final int height;

        private ShufflingData(byte[] byArray, long l, byte[][] byArray2, int n, int n2) {
            this.shufflingFullHash = byArray;
            this.shufflingId = Convert.fullHashToId(byArray);
            this.accountId = l;
            this.dbKey = ShufflingParticipantHome.this.shufflingDataDbKeyFactory.newKey(byArray, this.shufflingId, l);
            this.data = byArray2;
            this.transactionTimestamp = n;
            this.height = n2;
        }

        private ShufflingData(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.shufflingId = resultSet.getLong("shuffling_id");
            this.shufflingFullHash = resultSet.getBytes("shuffling_full_hash");
            this.accountId = resultSet.getLong("account_id");
            this.dbKey = dbKey;
            this.data = (byte[][])DbUtils.getArray(resultSet, "data", byte[][].class, Convert.EMPTY_BYTES);
            this.transactionTimestamp = resultSet.getInt("transaction_timestamp");
            this.height = resultSet.getInt("height");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO shuffling_data (shuffling_id, shuffling_full_hash, account_id, data, transaction_timestamp, height) VALUES (?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.shufflingId);
                preparedStatement.setBytes(++n, this.shufflingFullHash);
                preparedStatement.setLong(++n, this.accountId);
                DbUtils.setArrayEmptyToNull(preparedStatement, ++n, this.data);
                preparedStatement.setInt(++n, this.transactionTimestamp);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.executeUpdate();
            }
        }
    }

    public static enum Event {
        PARTICIPANT_REGISTERED,
        PARTICIPANT_PROCESSED,
        PARTICIPANT_VERIFIED,
        PARTICIPANT_CANCELLED;

    }

    public static enum State {
        REGISTERED(0, new byte[]{1}),
        PROCESSED(1, new byte[]{2, 3}),
        VERIFIED(2, new byte[]{3}),
        CANCELLED(3, new byte[0]);

        private final byte code;
        private final byte[] allowedNext;

        private State(byte by, byte[] byArray) {
            this.code = by;
            this.allowedNext = byArray;
        }

        static State get(byte by) {
            for (State state : State.values()) {
                if (state.code != by) continue;
                return state;
            }
            throw new IllegalArgumentException("No matching state for " + by);
        }

        public byte getCode() {
            return this.code;
        }

        public boolean canBecome(State state) {
            return Arrays.binarySearch(this.allowedNext, state.code) >= 0;
        }
    }
}

