/*
 * Decompiled with CFR 0.152.
 */
package nxt.shuffling;

import java.util.Arrays;
import nxt.db.DbIterator;
import nxt.shuffling.ShufflingHome;
import nxt.shuffling.ShufflingParticipantHome;

public enum ShufflingStage {
    REGISTRATION(0, new byte[]{1, 4}){

        @Override
        byte[] getHash(ShufflingHome.Shuffling shuffling) {
            return shuffling.getFullHash();
        }
    }
    ,
    PROCESSING(1, new byte[]{2, 3, 4}){

        @Override
        byte[] getHash(ShufflingHome.Shuffling shuffling) {
            if (shuffling.getAssigneeAccountId() == shuffling.getIssuerId()) {
                try (DbIterator<ShufflingParticipantHome.ShufflingParticipant> dbIterator = shuffling.getShufflingParticipantHome().getParticipants(shuffling.getFullHash());){
                    byte[] byArray = ShufflingHome.getParticipantsHash(dbIterator);
                    return byArray;
                }
            }
            ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = shuffling.getParticipant(shuffling.getAssigneeAccountId());
            return shufflingParticipant.getPreviousParticipant().getDataTransactionFullHash();
        }
    }
    ,
    VERIFICATION(2, new byte[]{3, 4, 5}){

        @Override
        byte[] getHash(ShufflingHome.Shuffling shuffling) {
            return shuffling.getLastParticipant().getDataTransactionFullHash();
        }
    }
    ,
    BLAME(3, new byte[]{4}){

        @Override
        byte[] getHash(ShufflingHome.Shuffling shuffling) {
            return shuffling.getParticipant(shuffling.getAssigneeAccountId()).getDataTransactionFullHash();
        }
    }
    ,
    CANCELLED(4, new byte[0]){

        @Override
        byte[] getHash(ShufflingHome.Shuffling shuffling) {
            byte[] byArray = shuffling.getLastParticipant().getDataTransactionFullHash();
            if (byArray != null && byArray.length > 0) {
                return byArray;
            }
            try (DbIterator<ShufflingParticipantHome.ShufflingParticipant> dbIterator = shuffling.getShufflingParticipantHome().getParticipants(shuffling.getFullHash());){
                byte[] byArray2 = ShufflingHome.getParticipantsHash(dbIterator);
                return byArray2;
            }
        }
    }
    ,
    DONE(5, new byte[0]){

        @Override
        byte[] getHash(ShufflingHome.Shuffling shuffling) {
            return shuffling.getLastParticipant().getDataTransactionFullHash();
        }
    };

    private final byte code;
    private final byte[] allowedNext;

    private ShufflingStage(byte by, byte[] byArray) {
        this.code = by;
        this.allowedNext = byArray;
    }

    public static ShufflingStage get(byte by) {
        for (ShufflingStage shufflingStage : ShufflingStage.values()) {
            if (shufflingStage.code != by) continue;
            return shufflingStage;
        }
        throw new IllegalArgumentException("No matching stage for " + by);
    }

    public byte getCode() {
        return this.code;
    }

    public boolean canBecome(ShufflingStage shufflingStage) {
        return Arrays.binarySearch(this.allowedNext, shufflingStage.code) >= 0;
    }

    abstract byte[] getHash(ShufflingHome.Shuffling var1);
}

