/*
 * Decompiled with CFR 0.152.
 */
package nxt.taggeddata;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import nxt.NxtException;
import nxt.blockchain.Appendix;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionType;
import nxt.crypto.Crypto;
import nxt.taggeddata.TaggedDataHome;
import nxt.taggeddata.TaggedDataTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class TaggedDataAttachment
extends Attachment.AbstractAttachment
implements Appendix.Prunable {
    public static final Appendix.Parser appendixParser = new Appendix.Parser(){

        @Override
        public Appendix.AbstractAppendix parse(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new TaggedDataAttachment(byteBuffer);
        }

        @Override
        public Appendix.AbstractAppendix parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(TaggedDataTransactionType.TAGGED_DATA_UPLOAD.getName(), jSONObject)) {
                return null;
            }
            return new TaggedDataAttachment(jSONObject);
        }
    };
    private final byte[] hash;
    private final String name;
    private final String description;
    private final String tags;
    private final String type;
    private final String channel;
    private final boolean isText;
    private final String filename;
    private final byte[] data;
    private volatile TaggedDataHome.TaggedData taggedData;

    TaggedDataAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        byte by = byteBuffer.get();
        if ((by & 1) != 0) {
            this.name = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
            this.description = Convert.readString(byteBuffer, byteBuffer.getShort(), 1000);
            this.tags = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
            this.type = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
            this.channel = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
            this.filename = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
            this.isText = (by & 2) != 0;
            int n = byteBuffer.getInt();
            if (n > 43008) {
                throw new NxtException.NotValidException("Invalid tagged data length " + n);
            }
            this.data = new byte[n];
            byteBuffer.get(this.data);
            this.hash = null;
        } else {
            this.hash = new byte[32];
            byteBuffer.get(this.hash);
            this.name = null;
            this.description = null;
            this.tags = null;
            this.type = null;
            this.channel = null;
            this.isText = false;
            this.filename = null;
            this.data = null;
        }
    }

    TaggedDataAttachment(JSONObject jSONObject) {
        super(jSONObject);
        String string = (String)jSONObject.get((Object)"data");
        if (string != null) {
            this.name = (String)jSONObject.get((Object)"name");
            this.description = (String)jSONObject.get((Object)"description");
            this.tags = (String)jSONObject.get((Object)"tags");
            this.type = (String)jSONObject.get((Object)"type");
            this.channel = Convert.nullToEmpty((String)jSONObject.get((Object)"channel"));
            this.isText = Boolean.TRUE.equals(jSONObject.get((Object)"isText"));
            this.data = this.isText ? Convert.toBytes(string) : Convert.parseHexString(string);
            this.filename = (String)jSONObject.get((Object)"filename");
            this.hash = null;
        } else {
            this.hash = Convert.parseHexString(Convert.emptyToNull((String)jSONObject.get((Object)"hash")));
            this.name = null;
            this.description = null;
            this.tags = null;
            this.type = null;
            this.channel = null;
            this.isText = false;
            this.filename = null;
            this.data = null;
        }
    }

    public TaggedDataAttachment(String string, String string2, String string3, String string4, String string5, boolean bl, String string6, byte[] byArray) throws NxtException.NotValidException {
        this.name = string;
        this.description = string2;
        this.tags = string3;
        this.type = string4;
        this.channel = string5;
        this.isText = bl;
        this.data = byArray;
        this.filename = string6;
        this.hash = null;
        if (bl && !Arrays.equals(byArray, Convert.toBytes(Convert.toString(byArray)))) {
            throw new NxtException.NotValidException("Data is not UTF-8 text");
        }
    }

    @Override
    public TransactionType getTransactionType() {
        return TaggedDataTransactionType.TAGGED_DATA_UPLOAD;
    }

    @Override
    protected int getMySize() {
        return 33;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)0);
        byteBuffer.put(this.getHash());
    }

    @Override
    public int getMyFullSize() {
        if (!this.hasPrunableData()) {
            throw new IllegalStateException("Prunable data not available");
        }
        return 3 + Convert.toBytes(this.getName()).length + 2 + Convert.toBytes(this.getDescription()).length + 2 + Convert.toBytes(this.getType()).length + 2 + Convert.toBytes(this.getChannel()).length + 2 + Convert.toBytes(this.getTags()).length + 2 + Convert.toBytes(this.getFilename()).length + 4 + this.getData().length;
    }

    @Override
    public void putMyPrunableBytes(ByteBuffer byteBuffer) {
        if (!this.hasPrunableData()) {
            throw new IllegalStateException("Prunable data not available");
        }
        byte by = 1;
        if (this.isText()) {
            by = (byte)(by | 2);
        }
        byteBuffer.put(by);
        byte[] byArray = Convert.toBytes(this.getName());
        byteBuffer.putShort((short)byArray.length);
        byteBuffer.put(byArray);
        byte[] byArray2 = Convert.toBytes(this.getDescription());
        byteBuffer.putShort((short)byArray2.length);
        byteBuffer.put(byArray2);
        byte[] byArray3 = Convert.toBytes(this.getTags());
        byteBuffer.putShort((short)byArray3.length);
        byteBuffer.put(byArray3);
        byte[] byArray4 = Convert.toBytes(this.getType());
        byteBuffer.putShort((short)byArray4.length);
        byteBuffer.put(byArray4);
        byte[] byArray5 = Convert.toBytes(this.getChannel());
        byteBuffer.putShort((short)byArray5.length);
        byteBuffer.put(byArray5);
        byte[] byArray6 = Convert.toBytes(this.getFilename());
        byteBuffer.putShort((short)byArray6.length);
        byteBuffer.put(byArray6);
        byteBuffer.putInt(this.getData().length);
        byteBuffer.put(this.getData());
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        if (this.taggedData != null) {
            jSONObject.put((Object)"name", (Object)this.taggedData.getName());
            jSONObject.put((Object)"description", (Object)this.taggedData.getDescription());
            jSONObject.put((Object)"tags", (Object)this.taggedData.getTags());
            jSONObject.put((Object)"type", (Object)this.taggedData.getType());
            jSONObject.put((Object)"channel", (Object)this.taggedData.getChannel());
            jSONObject.put((Object)"isText", (Object)this.taggedData.isText());
            jSONObject.put((Object)"filename", (Object)this.taggedData.getFilename());
            jSONObject.put((Object)"data", (Object)(this.taggedData.isText() ? Convert.toString(this.taggedData.getData()) : Convert.toHexString(this.taggedData.getData())));
        } else if (this.data != null) {
            jSONObject.put((Object)"name", (Object)this.name);
            jSONObject.put((Object)"description", (Object)this.description);
            jSONObject.put((Object)"tags", (Object)this.tags);
            jSONObject.put((Object)"type", (Object)this.type);
            jSONObject.put((Object)"channel", (Object)this.channel);
            jSONObject.put((Object)"isText", (Object)this.isText);
            jSONObject.put((Object)"filename", (Object)this.filename);
            jSONObject.put((Object)"data", (Object)(this.isText ? Convert.toString(this.data) : Convert.toHexString(this.data)));
        }
        jSONObject.put((Object)"hash", (Object)Convert.toHexString(this.getHash()));
    }

    @Override
    public byte[] getHash() {
        if (this.hash != null) {
            return this.hash;
        }
        if (this.data == null) {
            return null;
        }
        MessageDigest messageDigest = Crypto.sha256();
        messageDigest.update(Convert.toBytes(this.name));
        messageDigest.update(Convert.toBytes(this.description));
        messageDigest.update(Convert.toBytes(this.tags));
        messageDigest.update(Convert.toBytes(this.type));
        messageDigest.update(Convert.toBytes(this.channel));
        messageDigest.update((byte)(this.isText ? 1 : 0));
        messageDigest.update(Convert.toBytes(this.filename));
        messageDigest.update(this.data);
        return messageDigest.digest();
    }

    public final String getName() {
        if (this.taggedData != null) {
            return this.taggedData.getName();
        }
        return this.name;
    }

    public final String getDescription() {
        if (this.taggedData != null) {
            return this.taggedData.getDescription();
        }
        return this.description;
    }

    public final String getTags() {
        if (this.taggedData != null) {
            return this.taggedData.getTags();
        }
        return this.tags;
    }

    public final String getType() {
        if (this.taggedData != null) {
            return this.taggedData.getType();
        }
        return this.type;
    }

    public final String getChannel() {
        if (this.taggedData != null) {
            return this.taggedData.getChannel();
        }
        return this.channel;
    }

    public final boolean isText() {
        if (this.taggedData != null) {
            return this.taggedData.isText();
        }
        return this.isText;
    }

    public final String getFilename() {
        if (this.taggedData != null) {
            return this.taggedData.getFilename();
        }
        return this.filename;
    }

    public final byte[] getData() {
        if (this.taggedData != null) {
            return this.taggedData.getData();
        }
        return this.data;
    }

    @Override
    public void loadPrunable(Transaction transaction, boolean bl) {
        if (this.data == null && this.taggedData == null && this.shouldLoadPrunable(transaction, bl)) {
            this.taggedData = ((ChildChain)transaction.getChain()).getTaggedDataHome().getData(transaction.getFullHash());
        }
    }

    @Override
    public boolean hasPrunableData() {
        return this.taggedData != null || this.data != null;
    }

    @Override
    public void restorePrunableData(Transaction transaction, int n, int n2) {
        ((ChildChain)transaction.getChain()).getTaggedDataHome().restore(transaction, this, n, n2);
    }
}

