/*
 * Decompiled with CFR 0.152.
 */
package nxt.taggeddata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import nxt.Constants;
import nxt.Nxt;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.PrunableDbTable;
import nxt.db.VersionedPersistentDbTable;
import nxt.dbschema.Db;
import nxt.taggeddata.TaggedDataAttachment;
import nxt.util.Logger;
import nxt.util.Search;

public final class TaggedDataHome {
    private final ChildChain childChain;
    private final DbKey.HashKeyFactory<TaggedData> taggedDataKeyFactory;
    private final PrunableDbTable<TaggedData> taggedDataTable;
    private final DbKey.StringKeyFactory<Tag> tagDbKeyFactory;
    private final VersionedPersistentDbTable<Tag> tagTable;

    public static TaggedDataHome forChain(ChildChain childChain) {
        if (childChain.getTaggedDataHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new TaggedDataHome(childChain);
    }

    private TaggedDataHome(ChildChain childChain) {
        this.childChain = childChain;
        this.taggedDataKeyFactory = new DbKey.HashKeyFactory<TaggedData>("full_hash", "id"){

            @Override
            public DbKey newKey(TaggedData taggedData) {
                return taggedData.dbKey;
            }
        };
        this.taggedDataTable = new PrunableDbTable<TaggedData>(childChain.getSchemaTable("tagged_data"), this.taggedDataKeyFactory, "name,description,tags"){

            @Override
            protected TaggedData load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new TaggedData(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, TaggedData taggedData) throws SQLException {
                taggedData.save(connection);
            }

            @Override
            protected String defaultSort() {
                return " ORDER BY block_timestamp DESC, height DESC, db_id DESC ";
            }

            @Override
            protected void prune() {
                if (Constants.ENABLE_PRUNING) {
                    try (Connection connection = TaggedDataHome.this.taggedDataTable.getConnection();
                         PreparedStatement preparedStatement = connection.prepareStatement("SELECT parsed_tags FROM tagged_data WHERE transaction_timestamp < ?");){
                        int n = Nxt.getEpochTime() - Constants.MAX_PRUNABLE_LIFETIME;
                        preparedStatement.setInt(1, n);
                        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                        try (ResultSet resultSet = preparedStatement.executeQuery();){
                            while (resultSet.next()) {
                                Object[] objectArray;
                                for (Object object : objectArray = (Object[])resultSet.getArray("parsed_tags").getArray()) {
                                    Integer n2 = (Integer)hashMap.get(object);
                                    hashMap.put((String)object, n2 != null ? n2 + 1 : 1);
                                }
                            }
                        }
                        TaggedDataHome.this.deleteTags(hashMap);
                    }
                    catch (SQLException sQLException) {
                        throw new RuntimeException(sQLException.toString(), sQLException);
                    }
                }
                super.prune();
            }
        };
        this.tagDbKeyFactory = new DbKey.StringKeyFactory<Tag>("tag"){

            @Override
            public DbKey newKey(Tag tag) {
                return tag.dbKey;
            }
        };
        this.tagTable = new VersionedPersistentDbTable<Tag>(childChain.getSchemaTable("data_tag"), this.tagDbKeyFactory){

            @Override
            protected Tag load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Tag(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Tag tag) throws SQLException {
                tag.save(connection);
            }

            @Override
            public String defaultSort() {
                return " ORDER BY tag_count DESC, tag ASC ";
            }
        };
    }

    public int getTagCount() {
        return this.tagTable.getCount();
    }

    public DbIterator<Tag> getAllTags(int n, int n2) {
        return this.tagTable.getAll(n, n2);
    }

    public DbIterator<Tag> getTagsLike(String string, int n, int n2) {
        DbClause.LikeClause likeClause = new DbClause.LikeClause("tag", string);
        return this.tagTable.getManyBy((DbClause)likeClause, n, n2, " ORDER BY tag ");
    }

    private void addTags(TaggedData taggedData) {
        for (String string : taggedData.getParsedTags()) {
            Tag tag = (Tag)this.tagTable.get(this.tagDbKeyFactory.newKey(string));
            if (tag == null) {
                tag = new Tag(string, Nxt.getBlockchain().getHeight());
            }
            Tag tag2 = tag;
            tag2.count = tag2.count + 1;
            this.tagTable.insert(tag);
        }
    }

    private void addTags(TaggedData taggedData, int n) {
        try (Connection connection = this.tagTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("UPDATE data_tag SET tag_count = tag_count + 1 WHERE tag = ? AND height >= ?");){
            for (String string : taggedData.getParsedTags()) {
                Tag tag;
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, n);
                int n2 = preparedStatement.executeUpdate();
                if (n2 != 0) continue;
                Tag tag2 = tag = new Tag(string, n);
                tag2.count = tag2.count + 1;
                this.tagTable.insert(tag);
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    private void deleteTags(Map<String, Integer> map) {
        try (Connection connection = this.tagTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("UPDATE data_tag SET tag_count = tag_count - ? WHERE tag = ?");
             PreparedStatement preparedStatement2 = connection.prepareStatement("DELETE FROM data_tag WHERE tag_count <= 0 LIMIT " + Constants.BATCH_COMMIT_SIZE);){
            int n;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                preparedStatement.setInt(1, entry.getValue());
                preparedStatement.setString(2, entry.getKey());
                preparedStatement.executeUpdate();
                Logger.logDebugMessage("Reduced tag count for " + entry.getKey() + " by " + entry.getValue());
            }
            do {
                if ((n = preparedStatement2.executeUpdate()) > 0) {
                    Logger.logDebugMessage("Deleted " + n + " tags");
                }
                Db.db.commitTransaction();
            } while (n >= Constants.BATCH_COMMIT_SIZE);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public int getCount() {
        return this.taggedDataTable.getCount();
    }

    public DbIterator<TaggedData> getAll(int n, int n2) {
        return this.taggedDataTable.getAll(n, n2);
    }

    public TaggedData getData(byte[] byArray) {
        return (TaggedData)this.taggedDataTable.get(this.taggedDataKeyFactory.newKey(byArray));
    }

    public DbIterator<TaggedData> getData(String string, long l, int n, int n2) {
        if (string == null && l == 0L) {
            throw new IllegalArgumentException("Either channel, or accountId, or both, must be specified");
        }
        return this.taggedDataTable.getManyBy(this.getDbClause(string, l), n, n2);
    }

    public DbIterator<TaggedData> searchData(String string, String string2, long l, int n, int n2) {
        return this.taggedDataTable.search(string, this.getDbClause(string2, l), n, n2, " ORDER BY ft.score DESC, tagged_data.block_timestamp DESC, tagged_data.db_id DESC ");
    }

    private DbClause getDbClause(String string, long l) {
        DbClause dbClause = DbClause.EMPTY_CLAUSE;
        if (string != null) {
            dbClause = new DbClause.StringClause("channel", string);
        }
        if (l != 0L) {
            DbClause.LongClause longClause = new DbClause.LongClause("account_id", l);
            dbClause = dbClause != DbClause.EMPTY_CLAUSE ? dbClause.and(longClause) : longClause;
        }
        return dbClause;
    }

    void add(TransactionImpl transactionImpl, TaggedDataAttachment taggedDataAttachment) {
        TaggedData taggedData;
        if (Nxt.getEpochTime() - transactionImpl.getTimestamp() < Constants.MAX_PRUNABLE_LIFETIME && taggedDataAttachment.getData() != null && (taggedData = (TaggedData)this.taggedDataTable.get(this.taggedDataKeyFactory.newKey(transactionImpl.getFullHash(), transactionImpl.getId()))) == null) {
            taggedData = new TaggedData(transactionImpl, taggedDataAttachment);
            this.taggedDataTable.insert(taggedData);
            this.addTags(taggedData);
        }
    }

    void restore(Transaction transaction, TaggedDataAttachment taggedDataAttachment, int n, int n2) {
        if (this.taggedDataTable.get(this.taggedDataKeyFactory.newKey(transaction.getFullHash(), transaction.getId())) == null) {
            TaggedData taggedData = new TaggedData(transaction, taggedDataAttachment, n, n2);
            this.taggedDataTable.insert(taggedData);
            this.addTags(taggedData, n2);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isPruned(byte[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final class TaggedData {
        private final long id;
        private final byte[] transactionFullHash;
        private final DbKey dbKey;
        private final long accountId;
        private final String name;
        private final String description;
        private final String tags;
        private final String[] parsedTags;
        private final byte[] data;
        private final String type;
        private final String channel;
        private final boolean isText;
        private final String filename;
        private final int transactionTimestamp;
        private final int blockTimestamp;
        private final int height;

        private TaggedData(Transaction transaction, TaggedDataAttachment taggedDataAttachment) {
            this(transaction, taggedDataAttachment, Nxt.getBlockchain().getLastBlockTimestamp(), Nxt.getBlockchain().getHeight());
        }

        private TaggedData(Transaction transaction, TaggedDataAttachment taggedDataAttachment, int n, int n2) {
            this.id = transaction.getId();
            this.transactionFullHash = transaction.getFullHash();
            this.dbKey = TaggedDataHome.this.taggedDataKeyFactory.newKey(this.transactionFullHash, this.id);
            this.accountId = transaction.getSenderId();
            this.name = taggedDataAttachment.getName();
            this.description = taggedDataAttachment.getDescription();
            this.tags = taggedDataAttachment.getTags();
            this.parsedTags = Search.parseTags(this.tags, 3, 20, 5);
            this.data = taggedDataAttachment.getData();
            this.type = taggedDataAttachment.getType();
            this.channel = taggedDataAttachment.getChannel();
            this.isText = taggedDataAttachment.isText();
            this.filename = taggedDataAttachment.getFilename();
            this.blockTimestamp = n;
            this.transactionTimestamp = transaction.getTimestamp();
            this.height = n2;
        }

        private TaggedData(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.transactionFullHash = resultSet.getBytes("full_hash");
            this.dbKey = dbKey;
            this.accountId = resultSet.getLong("account_id");
            this.name = resultSet.getString("name");
            this.description = resultSet.getString("description");
            this.tags = resultSet.getString("tags");
            this.parsedTags = (String[])DbUtils.getArray(resultSet, "parsed_tags", String[].class);
            this.data = resultSet.getBytes("data");
            this.type = resultSet.getString("type");
            this.channel = resultSet.getString("channel");
            this.isText = resultSet.getBoolean("is_text");
            this.filename = resultSet.getString("filename");
            this.blockTimestamp = resultSet.getInt("block_timestamp");
            this.transactionTimestamp = resultSet.getInt("transaction_timestamp");
            this.height = resultSet.getInt("height");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO tagged_data (id, full_hash, account_id, name, description, tags, parsed_tags, type, channel, data, is_text, filename, block_timestamp, transaction_timestamp, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setBytes(++n, this.transactionFullHash);
                preparedStatement.setLong(++n, this.accountId);
                preparedStatement.setString(++n, this.name);
                preparedStatement.setString(++n, this.description);
                preparedStatement.setString(++n, this.tags);
                DbUtils.setArray(preparedStatement, ++n, this.parsedTags);
                preparedStatement.setString(++n, this.type);
                preparedStatement.setString(++n, this.channel);
                preparedStatement.setBytes(++n, this.data);
                preparedStatement.setBoolean(++n, this.isText);
                preparedStatement.setString(++n, this.filename);
                preparedStatement.setInt(++n, this.blockTimestamp);
                preparedStatement.setInt(++n, this.transactionTimestamp);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.id;
        }

        public byte[] getTransactionFullHash() {
            return this.transactionFullHash;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getTags() {
            return this.tags;
        }

        public String[] getParsedTags() {
            return this.parsedTags;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getType() {
            return this.type;
        }

        public String getChannel() {
            return this.channel;
        }

        public boolean isText() {
            return this.isText;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getTransactionTimestamp() {
            return this.transactionTimestamp;
        }

        public int getBlockTimestamp() {
            return this.blockTimestamp;
        }

        public ChildChain getChildChain() {
            return TaggedDataHome.this.childChain;
        }
    }

    public final class Tag {
        private final String tag;
        private final DbKey dbKey;
        private final int height;
        private int count;

        private Tag(String string, int n) {
            this.tag = string;
            this.dbKey = TaggedDataHome.this.tagDbKeyFactory.newKey(this.tag);
            this.height = n;
        }

        private Tag(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.tag = resultSet.getString("tag");
            this.dbKey = dbKey;
            this.count = resultSet.getInt("tag_count");
            this.height = resultSet.getInt("height");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO data_tag (tag, tag_count, height, latest) KEY (tag, height) VALUES (?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setString(++n, this.tag);
                preparedStatement.setInt(++n, this.count);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.executeUpdate();
            }
        }

        public String getTag() {
            return this.tag;
        }

        public int getCount() {
            return this.count;
        }
    }
}

