/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import nxt.Nxt;
import nxt.env.service.ArdorService_ServiceManagement;
import nxt.util.security.BlockchainPermission;

public class ManifestGenerator {
    public static final String JAVAFX_SDK_RUNTIME_LIB = "javafx-sdk.runtime";
    public static final String JAVAFX_LIB = "../javafx-sdk.runtime/lib";
    public static final String JAVAFX_SDK_LIB = "javafx-sdk";
    public static final String LIB = "./lib";
    public static final String CONF = "conf/";
    public static final String SOURCE_FILE = "src.zip";
    public static final String ARDOR_MANIFEST = "./resource/ardor.manifest.mf";
    public static final String ARDORSERVICE_MANIFEST = "./resource/ardorservice.manifest.mf";

    public static void main(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("tools"));
        }
        ManifestGenerator manifestGenerator = new ManifestGenerator();
        manifestGenerator.generate(ARDOR_MANIFEST, Nxt.class.getCanonicalName(), LIB, JAVAFX_LIB);
        String string = ArdorService_ServiceManagement.class.getCanonicalName();
        string = string.substring(0, string.length() - "_ServiceManagement".length());
        manifestGenerator.generate(ARDORSERVICE_MANIFEST, string, LIB);
    }

    private void generate(String string, String string2, String ... stringArray) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, string2);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            DirListing dirListing = new DirListing();
            try {
                Files.walkFileTree(Paths.get(string3, new String[0]), EnumSet.noneOf(FileVisitOption.class), 2, dirListing);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            stringBuilder.append(dirListing.getFileList().toString());
        }
        stringBuilder.append(CONF);
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, stringBuilder.toString());
        try {
            Path iOException = Paths.get(string, new String[0]);
            if (Files.exists(iOException, new LinkOption[0])) {
                Files.delete(iOException);
            }
            manifest.write(Files.newOutputStream(iOException, StandardOpenOption.CREATE));
            System.out.println("Manifest file " + string + " generated");
            byte[] byArray = Files.readAllBytes(iOException);
            System.out.println(new String(byArray, StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private static class DirListing
    extends SimpleFileVisitor<Path> {
        private final StringBuilder fileList = new StringBuilder();

        private DirListing() {
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
            if (path.getFileName().toString().equals(ManifestGenerator.SOURCE_FILE)) {
                return FileVisitResult.CONTINUE;
            }
            for (int i = 1; i < path.getNameCount() - 1; ++i) {
                String string = path.getName(i).toString().replace(ManifestGenerator.JAVAFX_SDK_RUNTIME_LIB, ManifestGenerator.JAVAFX_SDK_LIB);
                this.fileList.append(string).append('/');
            }
            this.fileList.append(path.getFileName()).append(' ');
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException iOException) {
            return FileVisitResult.CONTINUE;
        }

        public StringBuilder getFileList() {
            return this.fileList;
        }
    }
}

