/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BooleanExpression {
    public static final char CONJUNCTION_OPERATOR = '&';
    public static final char DISJUNCTION_OPERATOR = '|';
    public static final char NEGATION_OPERATOR = '!';
    private final Set<String> variables;
    private final Disjunction disjunction;
    private final BadSyntaxException syntaxException;
    private final List<SemanticWarning> semanticWarnings = new ArrayList<SemanticWarning>();
    private final int literalsCount;

    public BooleanExpression(String string) {
        BadSyntaxException badSyntaxException;
        Disjunction disjunction;
        try {
            disjunction = new Disjunction(string, this.semanticWarnings);
            badSyntaxException = null;
        }
        catch (BadSyntaxException badSyntaxException2) {
            disjunction = null;
            badSyntaxException = badSyntaxException2;
        }
        this.syntaxException = badSyntaxException;
        this.disjunction = disjunction;
        if (disjunction != null) {
            HashSet hashSet = new HashSet();
            for (Conjunction conjunction2 : disjunction.conjunctions) {
                hashSet.addAll(conjunction2.variables);
            }
            this.variables = Collections.unmodifiableSet(hashSet);
            this.literalsCount = disjunction.conjunctions.stream().mapToInt(conjunction -> ((Conjunction)conjunction).literals.size()).sum();
        } else {
            this.variables = Collections.emptySet();
            this.literalsCount = 0;
        }
    }

    public Value evaluate(Map<String, Value> map) throws BadSyntaxException {
        if (this.syntaxException != null) {
            throw this.syntaxException;
        }
        return this.disjunction.evaluate(map);
    }

    public static boolean fastImplicationCheck(BooleanExpression booleanExpression, BooleanExpression booleanExpression2) throws BadSyntaxException {
        if (booleanExpression.syntaxException != null) {
            throw booleanExpression.syntaxException;
        }
        if (booleanExpression2.syntaxException != null) {
            throw booleanExpression2.syntaxException;
        }
        for (Conjunction conjunction : booleanExpression.disjunction.conjunctions) {
            if (conjunction.implies(booleanExpression2.disjunction)) continue;
            return false;
        }
        return true;
    }

    public Set<String> getVariables() {
        return this.variables;
    }

    public int getLiteralsCount() {
        return this.literalsCount;
    }

    public boolean hasErrors(boolean bl) {
        if (this.syntaxException != null) {
            return true;
        }
        return bl && !this.semanticWarnings.isEmpty();
    }

    public BadSyntaxException getSyntaxException() {
        return this.syntaxException;
    }

    public List<SemanticWarning> getSemanticWarnings() {
        return this.semanticWarnings;
    }

    private static class Disjunction {
        private final List<Conjunction> conjunctions = new ArrayList<Conjunction>();

        private Disjunction(String string, List<SemanticWarning> list) throws BadSyntaxException {
            int n = 0;
            while (n <= string.length()) {
                int n2 = string.indexOf(124, n);
                if (n2 < 0) {
                    n2 = string.length();
                }
                Conjunction conjunction = new Conjunction(string, n, n2, list);
                for (Conjunction conjunction2 : this.conjunctions) {
                    Disjunction.checkAbsorption2(conjunction2, conjunction, string, list);
                    Disjunction.checkSingleLiterals(conjunction2, conjunction, list);
                }
                this.conjunctions.add(conjunction);
                n = n2 + 1;
            }
        }

        private Value evaluate(Map<String, Value> map) {
            boolean bl = false;
            for (Conjunction conjunction : this.conjunctions) {
                Value value = conjunction.evaluate(map);
                if (value == Value.UNKNOWN) {
                    bl = true;
                    continue;
                }
                if (value != Value.TRUE) continue;
                return Value.TRUE;
            }
            return bl ? Value.UNKNOWN : Value.FALSE;
        }

        public String toString() {
            return this.conjunctions.stream().map(Conjunction::toString).collect(Collectors.joining(" | "));
        }

        private static void checkAbsorption2(Conjunction conjunction, Conjunction conjunction2, String string, List<SemanticWarning> list) {
            if (conjunction.literals.containsAll(conjunction2.literals)) {
                Disjunction.warnAbsorption2(conjunction, conjunction2, string, list);
            } else if (conjunction2.literals.containsAll(conjunction.literals)) {
                Disjunction.warnAbsorption2(conjunction2, conjunction, string, list);
            }
        }

        private static void checkSingleLiterals(Conjunction conjunction, Conjunction conjunction2, List<SemanticWarning> list) {
            Literal literal = null;
            Literal literal2 = null;
            if (conjunction.literals.size() == 1) {
                literal = (Literal)conjunction.literals.iterator().next();
            }
            if (conjunction2.literals.size() == 1) {
                literal2 = (Literal)conjunction2.literals.iterator().next();
            }
            if (literal != null && literal2 != null) {
                if (literal.variableName.equals(literal2.variableName) && literal.isNegative != literal2.isNegative) {
                    SemanticWarning semanticWarning = new SemanticWarning(conjunction2.start, SemanticWarningType.DISJUNCTION_ALWAYS_TRUE, (literal.isNegative ? literal2 : literal).variableName);
                    list.add(semanticWarning);
                }
            } else if (literal != null) {
                if (conjunction2.variables.contains(literal.variableName)) {
                    Disjunction.warnDistributivity(literal, conjunction2, list);
                }
            } else if (literal2 != null && conjunction.variables.contains(literal2.variableName)) {
                Disjunction.warnDistributivity(literal2, conjunction, list);
            }
        }

        private static void warnAbsorption2(Conjunction conjunction, Conjunction conjunction2, String string, List<SemanticWarning> list) {
            SemanticWarning semanticWarning = new SemanticWarning(conjunction.start, SemanticWarningType.ABSORPTION_2_POSSIBLE, string.substring(conjunction.start, conjunction.end), string.substring(conjunction2.start, conjunction2.end), conjunction2.start);
            list.add(semanticWarning);
        }

        private static void warnDistributivity(Literal literal, Conjunction conjunction, List<SemanticWarning> list) {
            String string = conjunction.literals.stream().filter(literal2 -> !((Literal)literal2).variableName.equals(literal.variableName)).map(Literal::toString).collect(Collectors.joining(" & "));
            SemanticWarning semanticWarning = new SemanticWarning(conjunction.start, SemanticWarningType.DISTRIBUTIVITY_OF_OR_POSSIBLE, literal.toString(), conjunction.toString(), string);
            list.add(semanticWarning);
        }
    }

    private static class Conjunction {
        private final LinkedHashSet<Literal> literals = new LinkedHashSet();
        private final Set<String> variables = new HashSet<String>();
        private final int start;
        private final int end;

        Conjunction(String string, int n, int n2, List<SemanticWarning> list) throws BadSyntaxException {
            if (n2 - n <= 0) {
                throw new BadSyntaxException(n, SyntaxError.LITERAL_EXPECTED, new Object[0]);
            }
            int n3 = n;
            while (n3 <= n2) {
                Literal literal;
                int n4 = string.indexOf(38, n3);
                if (n4 < 0 || n4 > n2) {
                    n4 = n2;
                }
                if (this.literals.add(literal = new Literal(string, n3, n4))) {
                    if (!this.variables.add(literal.variableName)) {
                        list.add(new SemanticWarning(n3, SemanticWarningType.CONJUNCTION_ALWAYS_FALSE, string.substring(n, n2), literal.variableName));
                    }
                } else {
                    list.add(new SemanticWarning(n3, SemanticWarningType.DUPLICATE_LITERAL, string.substring(n3, n4), string.substring(n, n2)));
                }
                n3 = n4 + 1;
            }
            this.start = n;
            this.end = n2;
        }

        private boolean implies(Disjunction disjunction) {
            for (Conjunction conjunction : disjunction.conjunctions) {
                if (!this.implies(conjunction)) continue;
                return true;
            }
            return false;
        }

        private boolean implies(Conjunction conjunction) {
            return this.literals.containsAll(conjunction.literals);
        }

        Value evaluate(Map<String, Value> map) {
            boolean bl = false;
            for (Literal literal : this.literals) {
                Value value = literal.evaluate(map);
                if (value == Value.UNKNOWN) {
                    bl = true;
                    continue;
                }
                if (value != Value.FALSE) continue;
                return Value.FALSE;
            }
            return bl ? Value.UNKNOWN : Value.TRUE;
        }

        public String toString() {
            return this.literals.stream().map(Literal::toString).collect(Collectors.joining(" & "));
        }
    }

    private static class Literal {
        private String variableName = null;
        private boolean isNegative = false;

        Literal(String string, int n, int n2) throws BadSyntaxException {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            boolean bl2 = false;
            for (int i = n; i < n2; ++i) {
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (stringBuilder.length() <= 0) continue;
                    bl = true;
                    continue;
                }
                if (c == '!') {
                    if (bl2 || bl) {
                        throw new BadSyntaxException(i, SyntaxError.UNEXPECTED_NEGATION, new Object[0]);
                    }
                    this.isNegative = true;
                    bl2 = true;
                    continue;
                }
                if (Literal.isValidIdentifierChar(c)) {
                    if (bl) {
                        throw new BadSyntaxException(i, SyntaxError.OPERATOR_OR_AND_EXPECTED, new Object[0]);
                    }
                    if (stringBuilder.length() == 0 && c >= '0' && c <= '9') {
                        throw new BadSyntaxException(i, SyntaxError.DIGIT_AT_VARIABLE_START, new Object[0]);
                    }
                    stringBuilder.append(c);
                    bl2 = true;
                    continue;
                }
                throw new BadSyntaxException(i, SyntaxError.ILLEGAL_CHARACTER, Character.valueOf(c), c);
            }
            if (stringBuilder.length() == 0) {
                if (this.isNegative) {
                    throw new BadSyntaxException(n2, SyntaxError.VARIABLE_EXPECTED, new Object[0]);
                }
                throw new BadSyntaxException(n2, SyntaxError.LITERAL_EXPECTED, new Object[0]);
            }
            this.variableName = stringBuilder.toString();
        }

        Value evaluate(Map<String, Value> map) {
            Value value = map.get(this.variableName);
            if (value == null || value == Value.UNKNOWN) {
                return Value.UNKNOWN;
            }
            return this.isNegative ? Value.not(value) : value;
        }

        private static boolean isValidIdentifierChar(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
        }

        public String toString() {
            return (this.isNegative ? "!" : "") + this.variableName;
        }

        public int hashCode() {
            return 31 * this.variableName.hashCode() + (this.isNegative ? 1 : 0);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Literal) {
                Literal literal = (Literal)object;
                return literal.isNegative == this.isNegative && this.variableName.equals(literal.variableName);
            }
            return false;
        }
    }

    public static class BadSyntaxException
    extends BooleanExpressionException {
        public BadSyntaxException(int n, SyntaxError syntaxError, Object ... objectArray) {
            super(n, syntaxError.getMessage(objectArray));
        }
    }

    public static class BooleanExpressionException
    extends Exception {
        private final int position;

        BooleanExpressionException(int n, String string) {
            super(string);
            this.position = n;
        }

        public int getPosition() {
            return this.position;
        }
    }

    public static class SemanticWarning {
        private final int position;
        private final SemanticWarningType type;
        private final Object[] arguments;

        public SemanticWarning(int n, SemanticWarningType semanticWarningType, Object ... objectArray) {
            this.position = n;
            this.type = semanticWarningType;
            this.arguments = objectArray;
        }

        public int getPosition() {
            return this.position;
        }

        public String getMessage() {
            return String.format(this.type.messageFormat, this.arguments);
        }

        public boolean equals(Object object) {
            if (!(object instanceof SemanticWarning)) {
                return false;
            }
            SemanticWarning semanticWarning = (SemanticWarning)object;
            return this.type == semanticWarning.type && Arrays.equals(this.arguments, semanticWarning.arguments);
        }

        public String toString() {
            return "Boolean expression warning '" + this.getMessage() + "' at position " + this.position;
        }
    }

    public static enum SemanticWarningType {
        DUPLICATE_LITERAL("Duplicate literal \"%1$s\" in conjunction \"%2$s\""),
        CONJUNCTION_ALWAYS_FALSE("Conjunction \"%1$s\" always evaluates to FALSE because \"%2$s & !%2$s\" always evaluates to FALSE"),
        ABSORPTION_2_POSSIBLE("The expression \"%1$s\" can be removed according to the second absorption law because of \"%2$s\" at position %3$d"),
        DISJUNCTION_ALWAYS_TRUE("Expression always evaluates to TRUE because  \"%1$s | !%1$s\" always evaluates to TRUE"),
        DISTRIBUTIVITY_OF_OR_POSSIBLE("Expression \"%1$s | %2$s\" can be optimized to \"%1$s | %3$s\" by applying the law of distributivity of OR over AND");

        private final String messageFormat;

        private SemanticWarningType(String string2) {
            this.messageFormat = string2;
        }
    }

    public static enum SyntaxError {
        VARIABLE_EXPECTED("Variable expected"),
        LITERAL_EXPECTED("Literal expected"),
        OPERATOR_OR_AND_EXPECTED("Expected OR (|) or AND (&) operator"),
        UNEXPECTED_NEGATION("Unexpected negation operator"),
        DIGIT_AT_VARIABLE_START("Digit not allowed at variable start"),
        ILLEGAL_CHARACTER("Illegal character '%1$c', code=0x%2$04X");

        private final String messageFormat;

        private SyntaxError(String string2) {
            this.messageFormat = string2;
        }

        public String getMessage(Object ... objectArray) {
            return String.format(this.messageFormat, objectArray);
        }
    }

    public static enum Value {
        TRUE,
        FALSE,
        UNKNOWN;


        public static Value not(Value value) {
            switch (value) {
                case FALSE: {
                    return TRUE;
                }
                case TRUE: {
                    return FALSE;
                }
            }
            return UNKNOWN;
        }

        public static Value fromBoolean(boolean bl) {
            return bl ? TRUE : FALSE;
        }
    }
}

