/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class JSON {
    public static final JSONStreamAware emptyJSON = JSON.prepare(new JSONObject());
    private static final Pattern pattern = Pattern.compile("[\"\\\\\\u0008\\f\\n\\r\\t/\\u0000-\\u001f\\u007f-\\u009f\\u2000-\\u20ff\\ud800-\\udbff]");

    private JSON() {
    }

    public static JSONStreamAware prepare(final JSONObject jSONObject) {
        return new JSONStreamAware(){
            private final char[] jsonChars;
            {
                this.jsonChars = JSON.toJSONString((JSONAware)jSONObject).toCharArray();
            }

            public void writeJSONString(Writer writer) throws IOException {
                writer.write(this.jsonChars);
            }
        };
    }

    public static String toString(JSONStreamAware jSONStreamAware) {
        StringWriter stringWriter = new StringWriter();
        try {
            JSON.writeJSONString(jSONStreamAware, stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static String toJSONString(JSONAware jSONAware) {
        try {
            if (jSONAware == null) {
                return "null";
            }
            if (jSONAware instanceof Map) {
                StringBuilder stringBuilder = new StringBuilder(1024);
                JSON.encodeObject((Map)jSONAware, stringBuilder);
                return stringBuilder.toString();
            }
            if (jSONAware instanceof List) {
                StringBuilder stringBuilder = new StringBuilder(1024);
                JSON.encodeArray((List)jSONAware, stringBuilder);
                return stringBuilder.toString();
            }
            return jSONAware.toJSONString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void writeJSONString(JSONStreamAware jSONStreamAware, Writer writer) throws IOException {
        if (jSONStreamAware == null) {
            writer.write("null");
            return;
        }
        if (jSONStreamAware instanceof Map) {
            StringBuilder stringBuilder = new StringBuilder(1024);
            JSON.encodeObject((Map)jSONStreamAware, stringBuilder);
            writer.write(stringBuilder.toString());
            return;
        }
        if (jSONStreamAware instanceof List) {
            StringBuilder stringBuilder = new StringBuilder(1024);
            JSON.encodeArray((List)jSONStreamAware, stringBuilder);
            writer.write(stringBuilder.toString());
            return;
        }
        jSONStreamAware.writeJSONString(writer);
    }

    private static void encodeArray(List<?> list, Appendable appendable) throws IOException {
        if (list == null) {
            appendable.append("null");
            return;
        }
        boolean bl = true;
        appendable.append('[');
        for (Object obj : list) {
            if (bl) {
                bl = false;
            } else {
                appendable.append(',');
            }
            JSON.encodeValue(obj, appendable);
        }
        appendable.append(']');
    }

    public static void encodeObject(Map<?, ?> map, Appendable appendable) {
        try {
            if (map == null) {
                appendable.append("null");
                return;
            }
            Set<Map.Entry<?, ?>> set = map.entrySet();
            Iterator<Map.Entry<?, ?>> iterator = set.iterator();
            boolean bl = true;
            appendable.append('{');
            while (iterator.hasNext()) {
                Map.Entry<?, ?> entry = iterator.next();
                Object obj = entry.getKey();
                Object obj2 = entry.getValue();
                if (obj == null) continue;
                if (bl) {
                    bl = false;
                } else {
                    appendable.append(',');
                }
                appendable.append('\"').append(obj.toString()).append("\":");
                JSON.encodeValue(obj2, appendable);
            }
            appendable.append('}');
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void encodeValue(Object object, Appendable appendable) throws IOException {
        if (object == null) {
            appendable.append("null");
        } else if (object instanceof Double) {
            if (((Double)object).isInfinite() || ((Double)object).isNaN()) {
                appendable.append("null");
            } else {
                appendable.append(object.toString());
            }
        } else if (object instanceof Float) {
            if (((Float)object).isInfinite() || ((Float)object).isNaN()) {
                appendable.append("null");
            } else {
                appendable.append(object.toString());
            }
        } else if (object instanceof Number) {
            appendable.append(object.toString());
        } else if (object instanceof Boolean) {
            appendable.append(object.toString());
        } else if (object instanceof Map) {
            JSON.encodeObject((Map)object, appendable);
        } else if (object instanceof List) {
            JSON.encodeArray((List)object, appendable);
        } else {
            appendable.append('\"');
            JSON.escapeString(object.toString(), appendable);
            appendable.append('\"');
        }
    }

    private static void escapeString(String string, Appendable appendable) throws IOException {
        if (string.length() == 0) {
            return;
        }
        int n = 0;
        Matcher matcher = pattern.matcher(string);
        block10: while (matcher.find(n)) {
            int n2 = matcher.start();
            if (n2 > n) {
                appendable.append(string.substring(n, n2));
            }
            n = n2 + 1;
            char c = string.charAt(n2);
            switch (c) {
                case '\"': {
                    appendable.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    appendable.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    appendable.append("\\b");
                    continue block10;
                }
                case '\f': {
                    appendable.append("\\f");
                    continue block10;
                }
                case '\n': {
                    appendable.append("\\n");
                    continue block10;
                }
                case '\r': {
                    appendable.append("\\r");
                    continue block10;
                }
                case '\t': {
                    appendable.append("\\t");
                    continue block10;
                }
                case '/': {
                    appendable.append("\\/");
                    continue block10;
                }
            }
            if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff') {
                appendable.append("\\u").append(String.format("%04X", c));
                continue;
            }
            appendable.append(c);
        }
        if (n == 0) {
            appendable.append(string);
        } else if (n < string.length()) {
            appendable.append(string.substring(n));
        }
    }
}

