/*
 * Decompiled with CFR 0.152.
 */
package nxt.util.bbh;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.util.Convert;
import nxt.util.bbh.ByteArrayRw;
import nxt.util.bbh.LengthRw;
import nxt.util.bbh.LengthRwPrimitiveType;
import nxt.util.bbh.ObjectRw;
import nxt.util.bbh.StringLengthRw;

public class StringRw
implements ObjectRw<String> {
    private final ByteArrayRw byteArrayRw;
    private final StringLengthRw lengthRw;

    public StringRw(LengthRwPrimitiveType lengthRwPrimitiveType, int n) {
        this(new StringLengthRw(lengthRwPrimitiveType, n));
    }

    public StringRw(int n) {
        this(LengthRw.maxStringLen(n));
    }

    StringRw(StringLengthRw stringLengthRw) {
        this.byteArrayRw = new ByteArrayRw(stringLengthRw);
        this.lengthRw = stringLengthRw;
    }

    @Override
    public int getSize(String string) {
        return this.byteArrayRw.getSize(Convert.toBytes(string));
    }

    @Override
    public String readFromBuffer(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        return StringRw.fromBytes(this.byteArrayRw.readFromBuffer(byteBuffer));
    }

    private static String fromBytes(byte[] byArray) {
        return Convert.toString(byArray);
    }

    @Override
    public void writeToBuffer(String string, ByteBuffer byteBuffer) {
        this.byteArrayRw.writeToBuffer(Convert.toBytes(string), byteBuffer);
    }

    @Override
    public boolean validate(String string) {
        if (string.length() > this.lengthRw.getMaxCharCount()) {
            return false;
        }
        if (this.lengthRw.validate(Convert.getMaxStringSize(string.length()))) {
            return true;
        }
        byte[] byArray = Convert.toBytes(string);
        return this.lengthRw.validate(byArray.length);
    }
}

