/*
 * Decompiled with CFR 0.152.
 */
package nxt.util.security;

import java.security.PublicKey;
import java.util.Arrays;
import nxt.util.Convert;

public class BlockchainPublicKey
implements PublicKey {
    private final byte[] bytes;

    public BlockchainPublicKey(byte[] byArray) {
        this.bytes = byArray;
    }

    @Override
    public String getAlgorithm() {
        return "Blockchain";
    }

    @Override
    public String getFormat() {
        return "BlockchainKey";
    }

    @Override
    public byte[] getEncoded() {
        return this.bytes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BlockchainPublicKey blockchainPublicKey = (BlockchainPublicKey)object;
        return Arrays.equals(this.bytes, blockchainPublicKey.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return "publicKey:" + Convert.toHexString(this.bytes);
    }
}

