/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.nio.ByteBuffer;
import java.util.Map;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.AccountRestrictions;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionType;
import nxt.voting.SetPhasingOnlyAttachment;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONObject;

public abstract class AccountControlTransactionType
extends ChildTransactionType {
    private static final byte SUBTYPE_ACCOUNT_CONTROL_PHASING_ONLY = 0;
    public static final TransactionType SET_PHASING_ONLY = new AccountControlTransactionType(){

        @Override
        public byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ACCOUNT_CONTROL_PHASING_ONLY;
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return new Fee.ConstantFee(100000000L);
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new SetPhasingOnlyAttachment(byteBuffer);
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) throws NxtException.NotValidException {
            return new SetPhasingOnlyAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            Object object;
            SetPhasingOnlyAttachment setPhasingOnlyAttachment = (SetPhasingOnlyAttachment)childTransactionImpl.getAttachment();
            VoteWeighting.VotingModel votingModel = setPhasingOnlyAttachment.getPhasingParams().getVoteWeighting().getVotingModel();
            setPhasingOnlyAttachment.getPhasingParams().validateRestrictableParams();
            if (votingModel == VoteWeighting.VotingModel.NONE) {
                object = Account.getAccount(childTransactionImpl.getSenderId());
                if (object == null || !((Account)object).getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
                    throw new NxtException.NotCurrentlyValidException("Phasing only account control is not currently enabled");
                }
            } else if (votingModel == VoteWeighting.VotingModel.TRANSACTION || votingModel == VoteWeighting.VotingModel.HASH) {
                throw new NxtException.NotValidException("Invalid voting model " + (Object)((Object)votingModel) + " for account control");
            }
            object = setPhasingOnlyAttachment.getMaxFees();
            for (Map.Entry entry : object.entrySet()) {
                long l;
                ChildChain childChain = ChildChain.getChildChain((Integer)entry.getKey());
                if (childChain == null) {
                    throw new NxtException.NotValidException("Invalid child chain id " + entry.getKey());
                }
                long l2 = entry.getValue() == null ? -1L : (Long)entry.getValue();
                long l3 = l = Nxt.getBlockchain().getHeight() >= Constants.MISSING_TX_SENDER_BLOCK ? 0L : 1L;
                if (l2 >= l && l2 <= 100000000000000000L) continue;
                throw new NxtException.NotValidException(String.format("Invalid max fees %f for chain %s", (double)l2 / (double)childChain.ONE_COIN, childChain.getName()));
            }
            short s = setPhasingOnlyAttachment.getMinDuration();
            if (s < 0 || s > 0 && s < 3 || s >= 20160) {
                throw new NxtException.NotValidException("Invalid min duration " + setPhasingOnlyAttachment.getMinDuration());
            }
            short s2 = setPhasingOnlyAttachment.getMaxDuration();
            if (s2 < 0 || s2 > 0 && s2 < 3 || s2 >= 20160) {
                throw new NxtException.NotValidException("Invalid max duration " + s2);
            }
            if (s > s2) {
                throw new NxtException.NotValidException(String.format("Min duration %d cannot exceed max duration %d ", s, s2));
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            return TransactionType.isDuplicate(SET_PHASING_ONLY, Long.toUnsignedString(transaction.getSenderId()), map, true);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            SetPhasingOnlyAttachment setPhasingOnlyAttachment = (SetPhasingOnlyAttachment)childTransactionImpl.getAttachment();
            AccountRestrictions.PhasingOnly.set(account, setPhasingOnlyAttachment);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public String getName() {
            return "SetPhasingOnly";
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return SET_PHASING_ONLY;
            }
        }
        return null;
    }

    private AccountControlTransactionType() {
    }

    @Override
    public final byte getType() {
        return 4;
    }

    @Override
    public final boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        return true;
    }

    @Override
    public final void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
    }

    @Override
    public final boolean isGlobal() {
        return true;
    }
}

