/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.Appendix;
import nxt.blockchain.Chain;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionProcessor;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.blockchain.TransactionType;
import nxt.util.BooleanExpression;
import nxt.util.JSON;
import nxt.util.Logger;
import nxt.voting.PhasingParams;
import nxt.voting.PhasingPollHome;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public final class PhasingAppendix
extends Appendix.AbstractAppendix {
    public static final int appendixType = 64;
    public static final String appendixName = "Phasing";
    public static final Appendix.Parser appendixParser = new Appendix.Parser(){

        @Override
        public Appendix.AbstractAppendix parse(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new PhasingAppendix(byteBuffer);
        }

        @Override
        public Appendix.AbstractAppendix parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(PhasingAppendix.appendixName, jSONObject)) {
                return null;
            }
            return new PhasingAppendix(jSONObject);
        }
    };
    private static final Fee PHASING_FEE = (transactionImpl, appendix) -> {
        long l;
        PhasingParams phasingParams = ((PhasingAppendix)appendix).params;
        if (phasingParams.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
            long l2 = Math.max(phasingParams.getExpressionStr().length() / 32, phasingParams.getExpression().getLiteralsCount());
            l = (2L + l2) * 100000000L / 100L;
            for (PhasingParams phasingParams2 : phasingParams.getSubPolls().values()) {
                l += PhasingAppendix.getFeePerPoll(phasingParams2);
            }
        } else {
            l = PhasingAppendix.getFeePerPoll(phasingParams);
        }
        return l;
    };
    private final int finishHeight;
    private final PhasingParams params;

    private static long getFeePerPoll(PhasingParams phasingParams) {
        long l = 0L;
        l = !phasingParams.getVoteWeighting().isBalanceIndependent() ? (l += 20000000L) : (l += 1000000L);
        byte[] byArray = phasingParams.getHashedSecret();
        if (byArray.length > 0) {
            l += (long)(1 + (byArray.length - 1) / 32) * 100000000L / 100L;
        }
        l += 100000000L * (long)phasingParams.getLinkedTransactionsIds().size() / 100L;
        l += 100000000L * (long)phasingParams.getSenderPropertyVoting().getValue().length() / 3200L;
        return l += 100000000L * (long)phasingParams.getRecipientPropertyVoting().getValue().length() / 3200L;
    }

    private PhasingAppendix(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.finishHeight = byteBuffer.getInt();
        this.params = new PhasingParams(byteBuffer);
    }

    private PhasingAppendix(JSONObject jSONObject) {
        super(jSONObject);
        this.finishHeight = ((Long)jSONObject.get((Object)"phasingFinishHeight")).intValue();
        this.params = new PhasingParams(jSONObject);
    }

    public PhasingAppendix(int n, PhasingParams phasingParams) {
        this.finishHeight = n;
        this.params = phasingParams;
    }

    @Override
    public int getAppendixType() {
        return 64;
    }

    @Override
    public String getAppendixName() {
        return appendixName;
    }

    @Override
    protected int getMySize() {
        return 4 + this.params.getMySize();
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.finishHeight);
        this.params.putMyBytes(byteBuffer);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"phasingFinishHeight", (Object)this.finishHeight);
        this.params.putMyJSON(jSONObject);
    }

    @Override
    public void validate(Transaction transaction) throws NxtException.ValidationException {
        this.params.validate(transaction);
        int n = Nxt.getBlockchain().getHeight();
        if (this.finishHeight <= n + (this.params.getVoteWeighting().acceptsVotes() ? 2 : 1) || this.finishHeight >= n + 20160) {
            throw new NxtException.NotCurrentlyValidException("Invalid finish height " + this.finishHeight);
        }
    }

    @Override
    public void validateAtFinish(Transaction transaction) throws NxtException.ValidationException {
        this.params.checkApprovable();
    }

    @Override
    public void apply(Transaction transaction, Account account, Account account2) {
        ((ChildChain)transaction.getChain()).getPhasingPollHome().addPoll(transaction, this);
    }

    @Override
    public boolean isPhasable() {
        return false;
    }

    @Override
    public boolean isAllowed(Chain chain) {
        return chain instanceof ChildChain;
    }

    @Override
    public Fee getBaselineFee(Transaction transaction) {
        return PHASING_FEE;
    }

    private void release(TransactionImpl transactionImpl) {
        Account account = Account.getAccount(transactionImpl.getSenderId());
        Account account2 = transactionImpl.getRecipientId() == 0L ? null : Account.getAccount(transactionImpl.getRecipientId());
        transactionImpl.getAppendages().forEach(abstractAppendix -> {
            if (abstractAppendix.isPhasable()) {
                abstractAppendix.apply(transactionImpl, account, account2);
            }
        });
        TransactionProcessorImpl.getInstance().notifyListeners(Collections.singletonList(transactionImpl), TransactionProcessor.Event.RELEASE_PHASED_TRANSACTION);
        Logger.logDebugMessage("Transaction " + transactionImpl.getStringId() + " has been released");
    }

    public void reject(ChildTransactionImpl childTransactionImpl) {
        Account account = Account.getAccount(childTransactionImpl.getSenderId());
        childTransactionImpl.getType().undoAttachmentUnconfirmed(childTransactionImpl, account);
        childTransactionImpl.getChain().getBalanceHome().getBalance(childTransactionImpl.getSenderId()).addToUnconfirmedBalance(AccountLedger.LedgerEvent.REJECT_PHASED_TRANSACTION, AccountLedger.newEventId(childTransactionImpl), childTransactionImpl.getAmount());
        TransactionProcessorImpl.getInstance().notifyListeners(Collections.singletonList(childTransactionImpl), TransactionProcessor.Event.REJECT_PHASED_TRANSACTION);
        Logger.logDebugMessage("Transaction " + childTransactionImpl.getStringId() + " has been rejected");
    }

    public void countVotes(ChildTransactionImpl childTransactionImpl) {
        if (PhasingPollHome.getResult(childTransactionImpl) != null) {
            return;
        }
        PhasingPollHome phasingPollHome = childTransactionImpl.getChain().getPhasingPollHome();
        PhasingPollHome.PhasingPoll phasingPoll = phasingPollHome.getPoll(childTransactionImpl);
        long l = phasingPoll.countVotes();
        phasingPoll.finish(l);
        if (l >= phasingPoll.getQuorum()) {
            try {
                this.release(childTransactionImpl);
            }
            catch (RuntimeException runtimeException) {
                Logger.logErrorMessage("Failed to release phased transaction " + JSON.toJSONString((JSONAware)childTransactionImpl.getJSONObject()), runtimeException);
                this.reject(childTransactionImpl);
            }
        } else {
            this.reject(childTransactionImpl);
        }
    }

    public void tryCountVotes(ChildTransactionImpl childTransactionImpl, Map<TransactionType, Map<String, Integer>> map) {
        PhasingPollHome.PhasingPoll phasingPoll = childTransactionImpl.getChain().getPhasingPollHome().getPoll(childTransactionImpl);
        BooleanExpression.Value value = BooleanExpression.Value.UNKNOWN;
        long l = phasingPoll.isCompositeVoting() ? ((value = phasingPoll.getCompositeVotingResult()) == BooleanExpression.Value.TRUE ? 1L : 0L) : phasingPoll.countVotes();
        if (l >= phasingPoll.getQuorum() || value != BooleanExpression.Value.UNKNOWN) {
            if (value == BooleanExpression.Value.FALSE) {
                this.reject(childTransactionImpl);
                phasingPoll.finish(l);
                Logger.logDebugMessage("Composite voting expression of transaction " + childTransactionImpl.getStringId() + " evaluates to FALSE at height " + Nxt.getBlockchain().getHeight());
            } else if (!childTransactionImpl.attachmentIsDuplicate(map, false)) {
                try {
                    this.release(childTransactionImpl);
                    phasingPoll.finish(l);
                    Logger.logDebugMessage("Early finish of transaction " + childTransactionImpl.getStringId() + " at height " + Nxt.getBlockchain().getHeight());
                }
                catch (RuntimeException runtimeException) {
                    Logger.logErrorMessage("Failed to release phased transaction " + JSON.toJSONString((JSONAware)childTransactionImpl.getJSONObject()), runtimeException);
                }
            } else {
                Logger.logDebugMessage("At height " + Nxt.getBlockchain().getHeight() + " phased transaction " + childTransactionImpl.getStringId() + " is duplicate, cannot finish early");
            }
        } else {
            Logger.logDebugMessage("At height " + Nxt.getBlockchain().getHeight() + " phased transaction " + childTransactionImpl.getStringId() + " does not yet meet quorum, cannot finish early");
        }
    }

    public int getFinishHeight() {
        return this.finishHeight;
    }

    public List<ChainTransactionId> getLinkedTransactionsIds() {
        return this.params.getLinkedTransactionsIds();
    }

    public PhasingParams getParams() {
        return this.params;
    }
}

