/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nxt.Nxt;
import nxt.account.Account;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.EntityDbTable;
import nxt.db.ValuesDbTable;
import nxt.util.Convert;
import nxt.voting.PhasingPollHome;
import nxt.voting.PhasingVoteCastingAttachment;
import nxt.voting.VoteWeighting;

public final class PhasingVoteHome {
    private final ChildChain childChain;
    private final DbKey.HashLongKeyFactory<PhasingVote> phasingVoteDbKeyFactory;
    private final EntityDbTable<PhasingVote> phasingVoteTable;
    private final DbKey.HashLongKeyFactory<PhasingVote> phasingVoteSubPollDbKeyFactory;
    private final ValuesDbTable<PhasingVote, PhasingVoteSubPoll> phasingVoteSubPollsTable;

    public static PhasingVoteHome forChain(ChildChain childChain) {
        if (childChain.getPhasingVoteHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new PhasingVoteHome(childChain);
    }

    private PhasingVoteHome(ChildChain childChain) {
        this.childChain = childChain;
        this.phasingVoteDbKeyFactory = new DbKey.HashLongKeyFactory<PhasingVote>("transaction_full_hash", "transaction_id", "voter_id"){

            @Override
            public DbKey newKey(PhasingVote phasingVote) {
                return phasingVote.dbKey;
            }
        };
        this.phasingVoteTable = new EntityDbTable<PhasingVote>(childChain.getSchemaTable("phasing_vote"), this.phasingVoteDbKeyFactory){

            @Override
            protected PhasingVote load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new PhasingVote(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, PhasingVote phasingVote) throws SQLException {
                phasingVote.save(connection);
            }
        };
        this.phasingVoteSubPollDbKeyFactory = new DbKey.HashLongKeyFactory<PhasingVote>("transaction_full_hash", "transaction_id", "voter_id"){

            @Override
            public DbKey newKey(PhasingVote phasingVote) {
                return phasingVote.dbKey;
            }
        };
        this.phasingVoteSubPollsTable = new ValuesDbTable<PhasingVote, PhasingVoteSubPoll>(childChain.getSchemaTable("phasing_vote_sub_poll"), this.phasingVoteSubPollDbKeyFactory){

            @Override
            protected PhasingVoteSubPoll load(Connection connection, ResultSet resultSet) throws SQLException {
                return new PhasingVoteSubPoll(resultSet);
            }

            @Override
            protected void save(Connection connection, PhasingVote phasingVote, PhasingVoteSubPoll phasingVoteSubPoll) throws SQLException {
                phasingVoteSubPoll.save(connection);
            }
        };
    }

    public DbIterator<PhasingVote> getVotes(byte[] byArray, int n, int n2) {
        return this.phasingVoteTable.getManyBy(new DbClause.HashClause("transaction_full_hash", "transaction_id", byArray), n, n2);
    }

    public DbIterator<PhasingVoteSubPoll> getSubPollVotes(byte[] byArray, String string) {
        Connection connection2 = null;
        try {
            connection2 = this.phasingVoteSubPollsTable.getConnection();
            PreparedStatement preparedStatement = connection2.prepareStatement("SELECT * FROM phasing_vote_sub_poll  WHERE transaction_id = ? AND transaction_full_hash = ?  AND sub_poll_name = ?");
            int n = 0;
            preparedStatement.setLong(++n, Convert.fullHashToId(byArray));
            preparedStatement.setBytes(++n, byArray);
            preparedStatement.setString(++n, string);
            return new DbIterator<PhasingVoteSubPoll>(connection2, preparedStatement, (connection, resultSet) -> new PhasingVoteSubPoll(resultSet));
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection2);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public PhasingVote getVote(byte[] byArray, long l) {
        return this.phasingVoteTable.get(this.phasingVoteDbKeyFactory.newKey(byArray, l));
    }

    public long getVoteCount(byte[] byArray) {
        DbClause.HashClause hashClause = new DbClause.HashClause("transaction_full_hash", "transaction_id", byArray);
        return this.phasingVoteTable.getCount(hashClause);
    }

    public long getSubPollVoteCount(byte[] byArray, String string) {
        DbClause dbClause = new DbClause.HashClause("transaction_full_hash", "transaction_id", byArray).and(new DbClause.StringClause("sub_poll_name", string));
        return this.phasingVoteSubPollsTable.getCount(dbClause);
    }

    void addVote(Transaction transaction, Account account, byte[] byArray) {
        PhasingVote phasingVote = this.phasingVoteTable.get(this.phasingVoteDbKeyFactory.newKey(byArray, account.getId()));
        if (phasingVote == null) {
            PhasingPollHome.PhasingPoll phasingPoll = this.childChain.getPhasingPollHome().getPoll(byArray);
            ArrayList arrayList = new ArrayList();
            if (phasingPoll.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
                List<byte[]> list = ((PhasingVoteCastingAttachment)transaction.getAttachment()).getRevealedSecrets();
                phasingPoll.getParams().getSubPolls().forEach((string, phasingParams) -> {
                    if (phasingParams.acceptsVotes() && phasingParams.isAccountWhitelisted(account.getId()) && (phasingParams.getVoteWeighting().getVotingModel() != VoteWeighting.VotingModel.HASH || list.stream().anyMatch(byArray -> PhasingPollHome.checkSecretMatch(byArray, phasingParams)))) {
                        arrayList.add(new PhasingVoteSubPoll(byArray, account, (String)string));
                    }
                });
            }
            phasingVote = new PhasingVote(transaction, account, byArray);
            this.phasingVoteTable.insert(phasingVote);
            if (!arrayList.isEmpty()) {
                this.phasingVoteSubPollsTable.insert(phasingVote, arrayList);
            }
        }
    }

    public final class PhasingVoteSubPoll {
        private final long phasedTransactionId;
        private final byte[] phasedTransactionHash;
        private final long voterId;
        private final String subPollName;

        private PhasingVoteSubPoll(byte[] byArray, Account account, String string) {
            this.phasedTransactionHash = byArray;
            this.phasedTransactionId = Convert.fullHashToId(byArray);
            this.voterId = account.getId();
            this.subPollName = string;
        }

        private PhasingVoteSubPoll(ResultSet resultSet) throws SQLException {
            this.phasedTransactionId = resultSet.getLong("transaction_id");
            this.phasedTransactionHash = resultSet.getBytes("transaction_full_hash");
            this.voterId = resultSet.getLong("voter_id");
            this.subPollName = resultSet.getString("sub_poll_name");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_vote_sub_poll (transaction_id, transaction_full_hash, voter_id, sub_poll_name, height) VALUES (?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.phasedTransactionId);
                preparedStatement.setBytes(++n, this.phasedTransactionHash);
                preparedStatement.setLong(++n, this.voterId);
                preparedStatement.setString(++n, this.subPollName);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getVoterId() {
            return this.voterId;
        }
    }

    public final class PhasingVote {
        private final long phasedTransactionId;
        private final byte[] phasedTransactionHash;
        private final long voterId;
        private final DbKey dbKey;
        private final long voteId;
        private final byte[] voteHash;

        private PhasingVote(Transaction transaction, Account account, byte[] byArray) {
            this.phasedTransactionHash = byArray;
            this.phasedTransactionId = Convert.fullHashToId(byArray);
            this.voterId = account.getId();
            this.dbKey = PhasingVoteHome.this.phasingVoteDbKeyFactory.newKey(this.phasedTransactionHash, this.phasedTransactionId, this.voterId);
            this.voteId = transaction.getId();
            this.voteHash = transaction.getFullHash();
        }

        private PhasingVote(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.phasedTransactionId = resultSet.getLong("transaction_id");
            this.phasedTransactionHash = resultSet.getBytes("transaction_full_hash");
            this.voterId = resultSet.getLong("voter_id");
            this.dbKey = dbKey;
            this.voteId = resultSet.getLong("vote_id");
            this.voteHash = resultSet.getBytes("vote_full_hash");
        }

        public ChildChain getChildChain() {
            return PhasingVoteHome.this.childChain;
        }

        public long getPhasedTransactionId() {
            return this.phasedTransactionId;
        }

        public byte[] getPhasedTransactionFullHash() {
            return this.phasedTransactionHash;
        }

        public long getVoterId() {
            return this.voterId;
        }

        public long getVoteId() {
            return this.voteId;
        }

        public byte[] getVoteFullHash() {
            return this.voteHash;
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_vote (vote_id, vote_full_hash, transaction_id, transaction_full_hash, voter_id, height) VALUES (?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.voteId);
                preparedStatement.setBytes(++n, this.voteHash);
                preparedStatement.setLong(++n, this.phasedTransactionId);
                preparedStatement.setBytes(++n, this.phasedTransactionHash);
                preparedStatement.setLong(++n, this.voterId);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    }
}

