/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import nxt.NxtException;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import nxt.voting.AccountControlTransactionType;
import nxt.voting.PhasingParams;
import org.json.simple.JSONObject;

public final class SetPhasingOnlyAttachment
extends Attachment.AbstractAttachment {
    private final PhasingParams phasingParams;
    private final SortedMap<Integer, Long> maxFees;
    private final short minDuration;
    private final short maxDuration;

    public SetPhasingOnlyAttachment(PhasingParams phasingParams, SortedMap<Integer, Long> sortedMap, short s, short s2) {
        this.phasingParams = phasingParams;
        this.maxFees = sortedMap;
        this.minDuration = s;
        this.maxDuration = s2;
    }

    SetPhasingOnlyAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.phasingParams = new PhasingParams(byteBuffer);
        int n = byteBuffer.get() & 0xFF;
        this.maxFees = new TreeMap<Integer, Long>();
        for (int i = 0; i < n; ++i) {
            int n2 = byteBuffer.getInt();
            if (this.maxFees.put(n2, byteBuffer.getLong()) == null) continue;
            throw new NxtException.NotValidException("Duplicate max fees chainId " + n2);
        }
        this.minDuration = byteBuffer.getShort();
        this.maxDuration = byteBuffer.getShort();
    }

    SetPhasingOnlyAttachment(JSONObject jSONObject) throws NxtException.NotValidException {
        super(jSONObject);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"phasingControlParams");
        this.phasingParams = new PhasingParams(jSONObject2);
        JSONObject jSONObject3 = (JSONObject)jSONObject.get((Object)"controlMaxFees");
        this.maxFees = new TreeMap<Integer, Long>();
        for (Map.Entry entry : jSONObject3.entrySet()) {
            int n = Math.toIntExact(Convert.parseLong(entry.getKey()));
            long l = Convert.parseLong(entry.getValue());
            if (this.maxFees.put(n, l) == null) continue;
            throw new NxtException.NotValidException("Duplicate max fees chainId " + n);
        }
        this.minDuration = ((Long)jSONObject.get((Object)"controlMinDuration")).shortValue();
        this.maxDuration = ((Long)jSONObject.get((Object)"controlMaxDuration")).shortValue();
    }

    @Override
    public TransactionType getTransactionType() {
        return AccountControlTransactionType.SET_PHASING_ONLY;
    }

    @Override
    protected int getMySize() {
        return this.phasingParams.getMySize() + 1 + this.maxFees.size() * 12 + 2 + 2;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        this.phasingParams.putMyBytes(byteBuffer);
        byteBuffer.put((byte)this.maxFees.size());
        this.maxFees.forEach((n, l) -> {
            byteBuffer.putInt((int)n);
            byteBuffer.putLong((long)l);
        });
        byteBuffer.putShort(this.minDuration);
        byteBuffer.putShort(this.maxDuration);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        this.phasingParams.putMyJSON(jSONObject2);
        jSONObject.put((Object)"phasingControlParams", (Object)jSONObject2);
        JSONObject jSONObject3 = new JSONObject();
        this.maxFees.forEach((arg_0, arg_1) -> jSONObject3.put(arg_0, arg_1));
        jSONObject.put((Object)"controlMaxFees", (Object)jSONObject3);
        jSONObject.put((Object)"controlMinDuration", (Object)this.minDuration);
        jSONObject.put((Object)"controlMaxDuration", (Object)this.maxDuration);
    }

    public PhasingParams getPhasingParams() {
        return this.phasingParams;
    }

    public SortedMap<Integer, Long> getMaxFees() {
        return this.maxFees;
    }

    public short getMinDuration() {
        return this.minDuration;
    }

    public short getMaxDuration() {
        return this.maxDuration;
    }
}

