/*
 * Decompiled with CFR 0.152.
 */
package nxtdesktop;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import nxt.addons.JO;
import nxt.crypto.Crypto;
import nxt.http.API;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.security.BlockchainPermission;
import nxtdesktop.DesktopApplication;

public class JavaScriptBridge {
    final DesktopApplication application;
    private Clipboard clipboard;

    public JavaScriptBridge(DesktopApplication desktopApplication) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("desktop"));
        }
        this.application = desktopApplication;
    }

    public void log(String string) {
        Logger.logInfoMessage(string);
    }

    public void openBrowser(String string) {
        String string2 = API.getWelcomePageUri().toString() + "?account=" + string;
        Platform.runLater(() -> {
            try {
                Desktop.getDesktop().browse(new URI(string2));
            }
            catch (Exception exception) {
                Logger.logInfoMessage("Cannot open " + API.getWelcomePageUri().toString() + " error " + exception.getMessage());
            }
        });
    }

    public String readContactsFile() {
        return this.readJsonFile("contacts.json");
    }

    public String readApprovalModelsFile() {
        return this.readJsonFile("approval.models.json");
    }

    private String readJsonFile(String string) {
        try {
            Path path = Paths.get(System.getProperty("user.home"), "downloads");
            return this.application.readTextfile(path, string).orElse(null);
        }
        catch (IOException iOException) {
            Logger.logInfoMessage("Error reading " + string + ", error " + iOException.getMessage());
            JO jO = new JO();
            jO.put("error", iOException.getMessage());
            return jO.toJSONString();
        }
    }

    public String getAdminPassword() {
        return API.getAdminPassword();
    }

    public void popupHandlerURLChange(String string) {
        this.application.popupHandlerURLChange(string);
    }

    public boolean copyText(String string) {
        if (this.clipboard == null) {
            this.clipboard = Clipboard.getSystemClipboard();
            if (this.clipboard == null) {
                return false;
            }
        }
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(string);
        return this.clipboard.setContent((Map)clipboardContent);
    }

    public void renderPaperWallet(String string) {
        API.setPaperWalletPage(string);
        byte[] byArray = Crypto.sha256().digest(string.getBytes(StandardCharsets.UTF_8));
        Platform.runLater(() -> {
            try {
                URI uRI = API.getPaperWalletUri();
                Desktop.getDesktop().browse(new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), "hash=" + Convert.toHexString(byArray), uRI.getFragment()));
            }
            catch (Exception exception) {
                Logger.logInfoMessage("Cannot open paper wallet " + exception);
            }
        });
    }

    public void downloadTextFile(String string, String string2) {
        this.application.downloadFile(string, string2);
    }

    public boolean isFileReaderSupported() {
        String string = System.getProperty("javafx.version");
        return Integer.parseInt(string.substring(0, string.indexOf(46))) >= 12;
    }
}

