/*
 * Decompiled with CFR 0.152.
 */
package com.mohamnag.fxwebview_debugger;

import com.mohamnag.fxwebview_debugger.DevToolsWebSocket;
import com.mohamnag.fxwebview_debugger.DevToolsWebSocketServlet;
import com.sun.javafx.scene.web.Debugger;
import java.io.IOException;
import javafx.application.Platform;
import javafx.util.Callback;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class DevToolsDebuggerServer {
    private static ServletContextHandler contextHandler;
    private static Debugger debugger;
    private static Server server;

    public static void startDebugServer(Debugger debugger, int debuggerPort) throws Exception {
        server = new Server(debuggerPort);
        debugger.setEnabled(true);
        debugger.sendMessage("{\"id\" : -1, \"method\" : \"Network.enable\"}");
        contextHandler = new ServletContextHandler(1);
        contextHandler.setContextPath("/");
        ServletHolder devToolsHolder = new ServletHolder((Servlet)new DevToolsWebSocketServlet());
        contextHandler.addServlet(devToolsHolder, "/");
        server.setHandler((Handler)contextHandler);
        server.start();
        DevToolsDebuggerServer.debugger = debugger;
        debugger.setMessageCallback((Callback)new Callback<String, Void>(){

            public Void call(String data) {
                DevToolsWebSocket mainSocket = (DevToolsWebSocket)contextHandler.getServletContext().getAttribute("org.javafx.devtools.DevToolsWebSocket");
                if (mainSocket != null) {
                    try {
                        mainSocket.sendMessage(data);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        });
        String remoteUrl = "chrome-devtools://devtools/bundled/inspector.html?ws=localhost:" + debuggerPort + "/";
        System.out.println("To debug open chrome and load next url: " + remoteUrl);
    }

    public static void stopDebugServer() throws Exception {
        if (server != null) {
            server.stop();
            server.join();
        }
    }

    public static void sendMessageToBrowser(final String data) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                debugger.sendMessage(data);
            }
        });
    }

    public static String getServerState() {
        return server == null ? null : server.getState();
    }

    public static ServletContext getServletContext() {
        return contextHandler != null ? contextHandler.getServletContext() : null;
    }
}

