/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import nxt.account.Account;
import nxt.blockchain.Chain;
import nxt.crypto.Crypto;
import nxt.util.Convert;

public class AccountCurrencyBalance {
    private long accountId;
    private long unconfirmedBalance;
    private long balance;
    private long unconfirmedCurrencyUnits;
    private long currencyUnits;

    public AccountCurrencyBalance(long l, long l2, long l3, long l4) {
        this.unconfirmedBalance = l;
        this.balance = l2;
        this.unconfirmedCurrencyUnits = l3;
        this.currencyUnits = l4;
    }

    public AccountCurrencyBalance(String string, String string2, Chain chain) {
        Account account = Account.getAccount((byte[])Crypto.getPublicKey((String)string));
        assert (account != null);
        this.accountId = account.getId();
        this.unconfirmedBalance = chain.getBalanceHome().getBalance(this.accountId).getUnconfirmedBalance();
        this.balance = chain.getBalanceHome().getBalance(this.accountId).getBalance();
        long l = Convert.parseUnsignedLong((String)string2);
        this.unconfirmedCurrencyUnits = account.getUnconfirmedCurrencyUnits(l);
        this.currencyUnits = account.getCurrencyUnits(l);
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getUnconfirmedCurrencyUnits() {
        return this.unconfirmedCurrencyUnits;
    }

    public long getCurrencyUnits() {
        return this.currencyUnits;
    }

    public AccountCurrencyBalance diff(AccountCurrencyBalance accountCurrencyBalance) {
        return new AccountCurrencyBalance(this.unconfirmedBalance - accountCurrencyBalance.unconfirmedBalance, this.balance - accountCurrencyBalance.balance, this.unconfirmedCurrencyUnits - accountCurrencyBalance.unconfirmedCurrencyUnits, this.currencyUnits - accountCurrencyBalance.currencyUnits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AccountCurrencyBalance accountCurrencyBalance = (AccountCurrencyBalance)object;
        if (this.balance != accountCurrencyBalance.balance) {
            return false;
        }
        if (this.currencyUnits != accountCurrencyBalance.currencyUnits) {
            return false;
        }
        if (this.unconfirmedBalance != accountCurrencyBalance.unconfirmedBalance) {
            return false;
        }
        return this.unconfirmedCurrencyUnits == accountCurrencyBalance.unconfirmedCurrencyUnits;
    }

    public int hashCode() {
        int n = (int)(this.unconfirmedBalance ^ this.unconfirmedBalance >>> 32);
        n = 31 * n + (int)(this.balance ^ this.balance >>> 32);
        n = 31 * n + (int)(this.unconfirmedCurrencyUnits ^ this.unconfirmedCurrencyUnits >>> 32);
        n = 31 * n + (int)(this.currencyUnits ^ this.currencyUnits >>> 32);
        return n;
    }

    public String toString() {
        return "AccountCurrencyBalance{unconfirmedBalance=" + this.unconfirmedBalance + ", balance=" + this.balance + ", unconfirmedCurrencyUnits=" + this.unconfirmedCurrencyUnits + ", currencyUnits=" + this.currencyUnits + '}';
    }
}

