/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import nxt.AbstractBlockchainTest;
import nxt.AbstractFullDbTest;
import nxt.Constants;
import nxt.Nxt;
import nxt.account.Account;
import nxt.addons.DebugTrace;
import nxt.ae.Asset;
import nxt.blockchain.BlockImpl;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.db.DbIterator;
import nxt.util.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BlockchainProcessorTest
extends AbstractFullDbTest {
    private static final String defaultTraceFile = "nxt-trace-default.csv";
    private static final String testTraceFile = "nxt-trace.csv";
    private static final int maxHeight = Constants.LAST_KNOWN_BLOCK;
    private static final int startHeight = 0;
    private static final long[] testLesseeAccounts = new long[]{1460178482L, -318308835203526404L, 3312398282095696184L, 6373452498729869295L, 1088641461782019913L, -7984504957518839920L, 814976497827634325L};
    private static final long[] testAssets = new long[]{6775372232354238105L, 3061160746493230502L, -5981557335608550881L, 4551058913252105307L, -318057271556719590L, -2234297255166670436L};
    private static DebugTrace debugTrace;

    @BeforeClass
    public static void init() {
        AbstractBlockchainTest.init(BlockchainProcessorTest.newTestProperties());
        debugTrace = DebugTrace.addDebugTrace(Collections.emptySet(), (String)testTraceFile);
    }

    @AfterClass
    public static void shutdown() {
        AbstractBlockchainTest.shutdown();
    }

    public void reset(int n) {
        debugTrace.resetLog();
        if (blockchain.getHeight() > n) {
            blockchainProcessor.popOffTo(n);
            Assert.assertEquals((long)n, (long)blockchain.getHeight());
        }
        Assert.assertTrue((blockchain.getHeight() <= n ? 1 : 0) != 0);
    }

    @Test
    public void fullDownloadAndRescanTest() {
        this.reset(0);
        BlockchainProcessorTest.download(0, maxHeight);
        blockchainProcessor.scan(0, true);
        Assert.assertEquals((long)maxHeight, (long)blockchain.getHeight());
        Logger.logMessage((String)("Successfully rescanned blockchain from 0 to " + maxHeight));
        BlockchainProcessorTest.compareTraceFiles();
        debugTrace.resetLog();
    }

    @Test
    public void multipleRescanTest() {
        int n;
        this.reset(0);
        int n2 = 0;
        BlockchainProcessorTest.downloadTo(n2);
        while ((n = n2 + 2000) <= maxHeight) {
            BlockchainProcessorTest.download(n2, n);
            BlockchainProcessorTest.rescan(500);
            BlockchainProcessorTest.rescan(900);
            BlockchainProcessorTest.rescan(720);
            BlockchainProcessorTest.rescan(1439);
            BlockchainProcessorTest.rescan(200);
            BlockchainProcessorTest.rescan(1);
            BlockchainProcessorTest.rescan(2);
            n2 = n;
        }
    }

    @Test
    public void multiplePopOffTest() {
        int n;
        this.reset(0);
        int n2 = 0;
        BlockchainProcessorTest.downloadTo(n2);
        while ((n = n2 + 2000) <= maxHeight) {
            BlockchainProcessorTest.download(n2, n);
            BlockchainProcessorTest.redownload(800, false);
            BlockchainProcessorTest.redownload(1440, false);
            BlockchainProcessorTest.redownload(720, false);
            BlockchainProcessorTest.redownload(1, false);
            n2 = n;
        }
    }

    @Test
    public void reprocessTransactionsTest() {
        int n = Math.max(Constants.LAST_KNOWN_BLOCK - 2000, 0);
        this.reset(n);
        BlockchainProcessorTest.downloadTo(n);
        while (blockchain.getLastBlock().getTimestamp() < Nxt.getEpochTime() - 7200) {
            int n2 = n + 100;
            BlockchainProcessorTest.download(n, n2);
            BlockchainProcessorTest.redownload(100, true);
            BlockchainProcessorTest.redownload(800, true);
            BlockchainProcessorTest.redownload(1440, true);
            BlockchainProcessorTest.redownload(2, true);
            BlockchainProcessorTest.redownload(1024, true);
            BlockchainProcessorTest.redownload(10, true);
            BlockchainProcessorTest.redownload(720, true);
            BlockchainProcessorTest.redownload(1, true);
            n = n2;
        }
    }

    private static void download(int n, int n2) {
        Assert.assertEquals((long)n, (long)blockchain.getHeight());
        BlockchainProcessorTest.downloadTo(n2);
        Logger.logMessage((String)("Successfully downloaded blockchain from " + n + " to " + n2));
        BlockchainProcessorTest.compareTraceFiles();
        debugTrace.resetLog();
    }

    private static void rescan(int n) {
        if (n > Constants.MAX_ROLLBACK) {
            return;
        }
        int n2 = blockchain.getHeight();
        int n3 = n2 - n;
        blockchainProcessor.scan(n3, true);
        Assert.assertEquals((long)n2, (long)blockchain.getHeight());
        Logger.logMessage((String)("Successfully rescanned blockchain from " + n3 + " to " + n2));
        BlockchainProcessorTest.compareTraceFiles();
        debugTrace.resetLog();
    }

    private static void redownload(int n, boolean bl) {
        Throwable throwable;
        DbIterator dbIterator;
        ArrayList<Object> arrayList;
        Account account3;
        Serializable serializable;
        DbIterator dbIterator2;
        Account account2;
        ArrayList<Object> arrayList2;
        if (n > Constants.MAX_ROLLBACK) {
            return;
        }
        int n2 = blockchain.getHeight();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        for (long l : testLesseeAccounts) {
            ArrayList<Long> arrayList5 = new ArrayList<Long>();
            arrayList2 = new ArrayList<Object>();
            arrayList3.add(arrayList5);
            arrayList4.add(arrayList2);
            account2 = Account.getAccount((long)l);
            if (account2 == null) continue;
            dbIterator2 = account2.getLessors(n2 - n);
            serializable = null;
            try {
                for (Account account3 : dbIterator2) {
                    arrayList5.add(account3.getId());
                    arrayList2.add(account3.getGuaranteedBalanceFQT(Constants.GUARANTEED_BALANCE_CONFIRMATIONS, n2 - n));
                }
            }
            catch (Throwable throwable2) {
                serializable = throwable2;
                throw throwable2;
            }
            finally {
                if (dbIterator2 != null) {
                    if (serializable != null) {
                        try {
                            dbIterator2.close();
                        }
                        catch (Throwable throwable3) {
                            ((Throwable)serializable).addSuppressed(throwable3);
                        }
                    } else {
                        dbIterator2.close();
                    }
                }
            }
        }
        Object object = new ArrayList();
        for (long l : testAssets) {
            arrayList2 = new ArrayList();
            object.add(arrayList2);
            account2 = Asset.getAsset((long)l);
            if (account2 == null) continue;
            dbIterator2 = account2.getAccounts(n2 - n, 0, -1);
            serializable = null;
            try {
                for (Account account3 : dbIterator2) {
                    arrayList2.add(new TestAccountAsset((Account.AccountAsset)account3));
                }
            }
            catch (Throwable throwable4) {
                serializable = throwable4;
                throw throwable4;
            }
            finally {
                if (dbIterator2 != null) {
                    if (serializable != null) {
                        try {
                            dbIterator2.close();
                        }
                        catch (Throwable throwable5) {
                            ((Throwable)serializable).addSuppressed(throwable5);
                        }
                    } else {
                        dbIterator2.close();
                    }
                }
            }
        }
        Object object2 = blockchainProcessor.popOffTo(n2 - n);
        if (bl) {
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                BlockImpl blockImpl = (BlockImpl)iterator.next();
                TransactionProcessorImpl.getInstance().processLater((Collection)blockImpl.getFxtTransactions());
            }
        }
        Assert.assertEquals((long)(n2 - n), (long)blockchain.getHeight());
        ArrayList<Serializable> arrayList6 = new ArrayList<Serializable>();
        ArrayList arrayList7 = new ArrayList();
        for (long l : testLesseeAccounts) {
            serializable = new ArrayList();
            arrayList = new ArrayList();
            arrayList6.add(serializable);
            arrayList7.add(arrayList);
            account3 = Account.getAccount((long)l);
            if (account3 == null) continue;
            dbIterator = account3.getLessors();
            throwable = null;
            try {
                for (Account account4 : dbIterator) {
                    serializable.add(account4.getId());
                    arrayList.add(account4.getGuaranteedBalanceFQT());
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (dbIterator != null) {
                    if (throwable != null) {
                        try {
                            dbIterator.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        dbIterator.close();
                    }
                }
            }
        }
        Assert.assertEquals(arrayList3, arrayList6);
        Assert.assertEquals(arrayList4, arrayList7);
        Object object3 = new ArrayList();
        for (long l : testAssets) {
            arrayList = new ArrayList<Object>();
            object3.add(arrayList);
            account3 = Asset.getAsset((long)l);
            if (account3 == null) continue;
            dbIterator = account3.getAccounts(0, -1);
            throwable = null;
            try {
                for (Account account4 : dbIterator) {
                    arrayList.add(new TestAccountAsset((Account.AccountAsset)account4));
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (dbIterator != null) {
                    if (throwable != null) {
                        try {
                            dbIterator.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        dbIterator.close();
                    }
                }
            }
        }
        Assert.assertEquals((Object)object, (Object)object3);
        BlockchainProcessorTest.downloadTo(n2);
        Logger.logMessage((String)("Successfully redownloaded blockchain from " + (n2 - n) + " to " + n2));
        BlockchainProcessorTest.compareTraceFiles();
        debugTrace.resetLog();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void compareTraceFiles() {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(defaultTraceFile));
             BufferedReader bufferedReader2 = new BufferedReader(new FileReader(testTraceFile));){
            String string;
            bufferedReader.readLine();
            bufferedReader2.readLine();
            String string2 = bufferedReader2.readLine();
            if (string2 == null) {
                Logger.logMessage((String)"Empty trace file, nothing to compare");
                return;
            }
            int n = BlockchainProcessorTest.parseHeight(string2);
            while ((string = bufferedReader.readLine()) != null && BlockchainProcessorTest.parseHeight(string) < n) {
            }
            if (string == null) {
                Logger.logMessage((String)"End of default trace file, can't compare further");
                return;
            }
            int n2 = n;
            Assert.assertEquals((Object)string, (Object)string2);
            while ((string2 = bufferedReader2.readLine()) != null) {
                string = bufferedReader.readLine();
                if (string == null) {
                    Logger.logMessage((String)"End of default trace file, can't compare further");
                    return;
                }
                n2 = BlockchainProcessorTest.parseHeight(string2);
                Assert.assertEquals((Object)string, (Object)string2);
            }
            string = bufferedReader.readLine();
            if (string != null) {
                Assert.assertTrue((BlockchainProcessorTest.parseHeight(string) > n2 ? 1 : 0) != 0);
            }
            Logger.logMessage((String)("Comparison with default trace file passed from height " + n + " to " + n2));
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString(), iOException);
        }
    }

    private static int parseHeight(String string) {
        return Integer.parseInt(string.substring(1, string.indexOf(DebugTrace.SEPARATOR) - 1));
    }

    private static final class TestAccountAsset {
        private final Account.AccountAsset accountAsset;

        private TestAccountAsset(Account.AccountAsset accountAsset) {
            this.accountAsset = accountAsset;
        }

        public boolean equals(Object object) {
            if (!(object instanceof TestAccountAsset)) {
                return false;
            }
            Account.AccountAsset accountAsset = ((TestAccountAsset)object).accountAsset;
            return this.accountAsset.getAccountId() == accountAsset.getAccountId() && this.accountAsset.getAssetId() == accountAsset.getAssetId() && this.accountAsset.getQuantityQNT() == accountAsset.getQuantityQNT();
        }

        public String toString() {
            return this.accountAsset.toString();
        }
    }
}

