/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import nxt.AbstractBlockchainTest;
import nxt.AbstractForgingTest;
import nxt.ManualForgingTest;
import nxt.Nxt;
import nxt.Tester;
import nxt.account.Account;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.crypto.Crypto;
import nxt.dbschema.Db;
import nxt.http.APICall;
import nxt.util.Convert;
import nxt.util.JSONAssert;
import nxt.util.Logger;
import nxt.util.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.json.simple.JSONObject;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;

public abstract class BlockchainTest
extends AbstractBlockchainTest {
    protected static Tester FORGY;
    public static Tester ALICE;
    public static Tester BOB;
    public static Tester CHUCK;
    public static Tester DAVE;
    protected static Tester RIKER;
    protected static final int baseHeight = 1;
    protected static String forgerSecretPhrase;
    protected static final String forgerPublicKey;
    public static final String aliceSecretPhrase = "hope peace happen touch easy pretend worthless talk them indeed wheel state";
    public static final String bobSecretPhrase2 = "rshw9abtpsa2";
    public static final String chuckSecretPhrase = "eOdBVLMgySFvyiTy8xMuRXDTr45oTzB7L5J";
    public static final String daveSecretPhrase = "t9G2ymCmDsQij7VtYinqrbGCOAtDDA3WiNr";
    public static final String rikerSecretPhrase = "5hiig9BPdYoBzWni0QPaCDno6Wz0Vg8oX9yMcXRjEhmkuQKhvB";
    protected static final String rikerPublicKey;
    protected static boolean isNxtInitialized;
    private static boolean isRunInSuite;

    public static void setIsRunInSuite(boolean bl) {
        isRunInSuite = bl;
    }

    public static void initNxt(Map<String, String> map) {
        if (!isNxtInitialized) {
            AccessController.doPrivileged(() -> {
                Properties properties = ManualForgingTest.newTestProperties();
                properties.setProperty("nxt.isTestnet", "true");
                properties.setProperty("nxt.isAutomatedTest", "true");
                properties.setProperty("nxt.isOffline", "true");
                properties.setProperty("nxt.enableFakeForging", "true");
                properties.setProperty("nxt.fakeForgingPublicKeys", forgerPublicKey + ";" + rikerPublicKey);
                properties.setProperty("nxt.timeMultiplier", "1");
                properties.setProperty("nxt.testnetGuaranteedBalanceConfirmations", "1");
                properties.setProperty("nxt.testnetLeasingDelay", "1");
                properties.setProperty("nxt.disableProcessTransactionsThread", "true");
                properties.setProperty("nxt.deleteFinishedShufflings", "false");
                properties.setProperty("nxt.disableAdminPassword", "true");
                properties.setProperty("nxt.testDbDir", "./nxt_unit_test_db/nxt");
                properties.setProperty("nxt.secretPhrasePieces.ARDOR-XK4R-7VJU-6EQG-7R335", "1:9999:3:2:0:2:01d8ce9df0a2bbc29140a56211262d9449d501508b1c5547e5");
                map.forEach(properties::setProperty);
                AbstractForgingTest.init(properties);
                isNxtInitialized = true;
                return null;
            });
        }
    }

    @BeforeClass
    public static void init() {
        BlockchainTest.initNxt(Collections.emptyMap());
        BlockchainTest.initBlockchainTest();
        Assume.assumeThat((Object)Db.PREFIX, (Matcher)CoreMatchers.equalTo((Object)"nxt.testDb"));
    }

    @AfterClass
    public static void shutdownNxt() {
        if (!isRunInSuite) {
            AccessController.doPrivileged(() -> {
                Nxt.shutdown();
                return null;
            });
        }
    }

    protected static void initBlockchainTest() {
        AccessController.doPrivileged(() -> {
            Nxt.setTime((Time)new Time.CounterTime(Nxt.getEpochTime()));
            BlockchainTest.fundTestAccounts();
            Nxt.getBlockchainProcessor().popOffTo(1);
            Logger.logMessage((String)"baseHeight: 1");
            FORGY = new Tester(forgerSecretPhrase);
            ALICE = new Tester(aliceSecretPhrase);
            BOB = new Tester(bobSecretPhrase2);
            CHUCK = new Tester(chuckSecretPhrase);
            DAVE = new Tester(daveSecretPhrase);
            RIKER = new Tester(rikerSecretPhrase);
            BlockchainTest.startBundlers();
            return null;
        });
    }

    private static void fundTestAccounts() {
        if (Nxt.getBlockchain().getHeight() == 0) {
            Nxt.getTransactionProcessor().clearUnconfirmedTransactions();
            APICall.Builder builder = new APICall.Builder("sendMoney").secretPhrase(rikerSecretPhrase).param("chain", "" + FxtChain.FXT.getId()).param("amountNQT", 100000L * FxtChain.FXT.ONE_COIN).param("feeNQT", FxtChain.FXT.ONE_COIN * 11L);
            APICall.Builder builder2 = new APICall.Builder("sendMoney").secretPhrase(rikerSecretPhrase).param("chain", "" + ChildChain.IGNIS.getId()).param("amountNQT", 100000L * ChildChain.IGNIS.ONE_COIN).param("feeNQT", ChildChain.IGNIS.ONE_COIN * 11L);
            APICall.Builder builder3 = new APICall.Builder("sendMoney").secretPhrase(rikerSecretPhrase).param("chain", "" + ChildChain.AEUR.getId()).param("amountNQT", 100000L * ChildChain.AEUR.ONE_COIN).param("feeNQT", ChildChain.AEUR.ONE_COIN * 11L);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string : Arrays.asList(aliceSecretPhrase, bobSecretPhrase2, chuckSecretPhrase, daveSecretPhrase, forgerSecretPhrase)) {
                byte[] byArray = Crypto.getPublicKey((String)string);
                String string2 = Convert.toHexString((byte[])byArray);
                String string3 = Long.toUnsignedString(Account.getId((byte[])byArray));
                builder.param("recipient", string3);
                new JSONAssert(builder.build().invoke()).str("fullHash");
                builder2.param("recipient", string3).param("recipientPublicKey", string2);
                arrayList.add(new JSONAssert(builder2.build().invoke()).str("fullHash"));
                builder3.param("recipient", string3);
                arrayList2.add(new JSONAssert(builder3.build().invoke()).str("fullHash"));
            }
            BlockchainTest.bundleTransactions(arrayList);
            BlockchainTest.bundleTransactions(arrayList2);
            try {
                blockchainProcessor.generateBlock(rikerSecretPhrase, Nxt.getEpochTime());
            }
            catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                blockNotAcceptedException.printStackTrace();
                Assert.fail();
            }
        }
    }

    protected static void bundleTransactions(List<String> list) {
        APICall.Builder builder = new APICall.Builder("bundleTransactions").secretPhrase(rikerSecretPhrase).param("chain", "" + FxtChain.FXT.getId()).param("deadline", 10).param("transactionFullHash", list.toArray(new String[0]));
        new JSONAssert(builder.build().invoke()).str("fullHash");
    }

    private static void startBundlers() {
        for (Chain chain : ChildChain.getAll()) {
            long l = Convert.decimalMultiplier((int)(FxtChain.getChain((int)1).getDecimals() - chain.getDecimals()));
            JSONObject jSONObject = new APICall.Builder("startBundler").secretPhrase(FORGY.getSecretPhrase()).param("chain", chain.getId()).param("minRateNQTPerFXT", chain.ONE_COIN / l / 10L).param("totalFeesLimitFQT", 20000L * chain.ONE_COIN * l).param("overpayFQTPerFXT", 0).build().invoke();
        }
    }

    @After
    public void destroy() {
        AccessController.doPrivileged(() -> {
            TransactionProcessorImpl.getInstance().clearUnconfirmedTransactions();
            blockchainProcessor.popOffTo(1);
            return null;
        });
    }

    public static void generateBlock() {
        BlockchainTest.generateBlock(forgerSecretPhrase);
    }

    public static void generateBlockAndSleep() {
        BlockchainTest.generateBlock();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void generateBlock(Tester tester) {
        BlockchainTest.generateBlock(tester.getSecretPhrase());
    }

    private static void generateBlock(String string) {
        Logger.logDebugMessage((String)"vvvvvvvvvvvvvvvvv    generateBlock()    vvvvvvvvvvvvvvvvv");
        try {
            AccessController.doPrivileged(() -> {
                blockchainProcessor.generateBlock(string, Nxt.getEpochTime());
                return null;
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
            Assert.fail();
        }
        Logger.logDebugMessage((String)"^----------------    generateBlock()    ----------------^");
    }

    protected static void generateBlocks(int n) {
        for (int i = 0; i < n; ++i) {
            BlockchainTest.generateBlock();
        }
    }

    static {
        forgerSecretPhrase = "aSykrgKGZNlSVOMDxkZZgbTvQqJPGtsBggb";
        forgerPublicKey = Convert.toHexString((byte[])Crypto.getPublicKey((String)forgerSecretPhrase));
        rikerPublicKey = Convert.toHexString((byte[])Crypto.getPublicKey((String)rikerSecretPhrase));
        isNxtInitialized = false;
        isRunInSuite = false;
    }
}

