/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.account.Token;
import org.junit.Assert;
import org.junit.Test;

public class TokenTest
extends BlockchainTest {
    @Test
    public void testParseValidToken() throws Exception {
        String string = "6s7hchl9q0e5jgrrtgscoip2lcb2o3oi7ndso1bnjr475suv001ug93uu8aq2f00o7q6pvs2ivrpra1svouvb4k5nreco0tt94qest9mq5jg2qihcvj5n5ljqht5fl6n39nslr7kidqh8kh8u8v6e4rn92f47l3i";
        Token token = Token.parseToken((String)string, (String)"http://nxt.org");
        Assert.assertEquals((long)1000L, (long)token.getTimestamp());
        Assert.assertTrue((boolean)token.isValid());
    }

    @Test
    public void testParseInValidToken() throws Exception {
        String string = "6s7hchl9q0e5jgrrtgscoip2lcb2o3oi7ndso1bnjr475suv001ug93uu8aq2f00o7q6pvs2ivrpra1svouvb4k5nreco0tt94qest9mq5jg2qihcvj5n5ljqht5fl6n39nslr7kidqh8kh8u8v6e4rn92f47l3i";
        Token token = Token.parseToken((String)string, (String)"http://next.org");
        Assert.assertEquals((long)1000L, (long)token.getTimestamp());
        Assert.assertFalse((boolean)token.isValid());
    }

    @Test
    public void testGenerateToken() throws Exception {
        int n = Nxt.getEpochTime();
        String string = Token.generateToken((String)"secret", (String)"http://nxt.org");
        int n2 = Nxt.getEpochTime();
        Token token = Token.parseToken((String)string, (String)"http://nxt.org");
        Assert.assertTrue((boolean)token.isValid());
        Assert.assertTrue((token.getTimestamp() >= n ? 1 : 0) != 0);
        Assert.assertTrue((token.getTimestamp() <= n2 ? 1 : 0) != 0);
    }

    @Test
    public void emptySecret() throws Exception {
        String string = Token.generateToken((String)"", (String)"http://nxt.org");
        Token token = Token.parseToken((String)string, (String)"http://nxt.org");
        Assert.assertTrue((boolean)token.isValid());
    }

    @Test
    public void emptySite() throws Exception {
        String string = Token.generateToken((String)"secret", (String)"");
        Token token = Token.parseToken((String)string, (String)"");
        Assert.assertTrue((boolean)token.isValid());
    }

    @Test
    public void veryLongSite() throws Exception {
        StringBuilder stringBuilder = new StringBuilder(600000);
        for (int i = 0; i < 100000; ++i) {
            stringBuilder.append("abcd10");
        }
        String string = Token.generateToken((String)"secret", (String)stringBuilder.toString());
        Token token = Token.parseToken((String)string, (String)stringBuilder.toString());
        Assert.assertTrue((boolean)token.isValid());
    }
}

