/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import nxt.addons.BlockchainEntity;
import nxt.addons.ContractInvocationParameter;
import nxt.addons.ContractRunnerParameter;
import nxt.addons.ContractSetupParameter;
import nxt.addons.JO;
import nxt.addons.ParamInvocationHandler;
import org.junit.Assert;
import org.junit.Test;

public class ParamInvocationHandlerTest {
    @Test
    public void testReadRunnerParams() {
        JO jO = new JO();
        jO.put("intValue", (Object)"3");
        jO.put("stringValue", (Object)"some string");
        RunnerParams runnerParams = (RunnerParams)ParamInvocationHandler.getParams(RunnerParams.class, (JO)jO, (JO)new JO(), (JO)new JO());
        Assert.assertEquals((Object)"some string", (Object)runnerParams.stringValue());
        Assert.assertEquals((long)3L, (long)runnerParams.intValue());
    }

    @Test
    public void testContractSetupParams() {
        JO jO = new JO();
        jO.put("booleanValue", (Object)"true");
        jO.put("stringValue", (Object)"some other string");
        ContractSetupParams contractSetupParams = (ContractSetupParams)ParamInvocationHandler.getParams(ContractSetupParams.class, (JO)new JO(), (JO)jO, (JO)new JO());
        Assert.assertEquals((Object)"some other string", (Object)contractSetupParams.stringValue());
        Assert.assertTrue((boolean)contractSetupParams.booleanValue());
    }

    @Test
    public void testInvocationParams() {
        JO jO = new JO();
        jO.put("someId", (Object)Long.toUnsignedString(-2L));
        jO.put("stringValue", (Object)"some other string");
        InvocationParams invocationParams = (InvocationParams)ParamInvocationHandler.getParams(InvocationParams.class, (JO)new JO(), (JO)new JO(), (JO)jO);
        Assert.assertEquals((Object)"some other string", (Object)invocationParams.stringValue());
        Assert.assertEquals((long)-2L, (long)invocationParams.someId());
    }

    @Test
    public void testParamsScopePriority() {
        JO jO = new JO();
        jO.put("stringValue", (Object)"invocation");
        JO jO2 = new JO();
        jO2.put("stringValue", (Object)"setup");
        JO jO3 = new JO();
        jO3.put("stringValue", (Object)"runner");
        MultiAnnotatedParams multiAnnotatedParams = (MultiAnnotatedParams)ParamInvocationHandler.getParams(MultiAnnotatedParams.class, (JO)jO3, (JO)jO2, (JO)jO);
        Assert.assertEquals((Object)"invocation", (Object)multiAnnotatedParams.stringValue());
    }

    @Test
    public void testDefaultParameterValue() {
        DefaultParams defaultParams = (DefaultParams)ParamInvocationHandler.getParams(DefaultParams.class, (JO)new JO(), (JO)new JO(), (JO)new JO());
        Assert.assertEquals((long)-1L, (long)defaultParams.longValueWithDefault());
        Assert.assertEquals((long)6L, (long)defaultParams.intValueWithDefaultAndParameters(2, 3));
        Assert.assertEquals((Object)"some default string", (Object)defaultParams.objectValueWithDefault());
    }

    @Test
    public void testDefaultParameterValueOverride() {
        JO jO = new JO();
        jO.put("longValueWithDefault", (Object)2L);
        jO.put("intValueWithDefaultAndParameters", (Object)10);
        DefaultParams defaultParams = (DefaultParams)ParamInvocationHandler.getParams(DefaultParams.class, (JO)jO, (JO)new JO(), (JO)new JO());
        Assert.assertEquals((long)2L, (long)defaultParams.longValueWithDefault());
        Assert.assertEquals((long)10L, (long)defaultParams.intValueWithDefaultAndParameters(2, 3));
    }

    @Test
    public void testMissingParameterWithoutDefaultValue() {
        DefaultParams defaultParams = (DefaultParams)ParamInvocationHandler.getParams(DefaultParams.class, (JO)new JO(), (JO)new JO(), (JO)new JO());
        Assert.assertEquals((long)0L, (long)defaultParams.intValue());
        Assert.assertEquals((long)0L, (long)defaultParams.longValue());
        Assert.assertEquals((long)0L, (long)defaultParams.idValue());
        Assert.assertFalse((boolean)defaultParams.booleanValue());
        Assert.assertNull((Object)defaultParams.objectValue());
    }

    private static interface InvocationParams {
        @ContractInvocationParameter
        @BlockchainEntity
        public long someId();

        @ContractInvocationParameter
        public String stringValue();
    }

    private static interface ContractSetupParams {
        @ContractSetupParameter
        public boolean booleanValue();

        @ContractSetupParameter
        public String stringValue();
    }

    private static interface MultiAnnotatedParams {
        @ContractInvocationParameter
        @ContractSetupParameter
        @ContractRunnerParameter
        public String stringValue();
    }

    private static interface RunnerParams {
        @ContractRunnerParameter
        public int intValue();

        @ContractRunnerParameter
        public String stringValue();
    }

    public static interface DefaultParams {
        @ContractRunnerParameter
        public int intValue();

        @ContractRunnerParameter
        public boolean booleanValue();

        @ContractRunnerParameter
        public long longValue();

        @BlockchainEntity
        @ContractRunnerParameter
        public long idValue();

        @ContractRunnerParameter
        public Object objectValue();

        @ContractRunnerParameter
        default public long longValueWithDefault() {
            return -1L;
        }

        @ContractRunnerParameter
        default public Object objectValueWithDefault() {
            return "some default string";
        }

        @ContractRunnerParameter
        default public int intValueWithDefaultAndParameters(int n, int n2) {
            return n * n2;
        }
    }
}

