/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import nxt.BlockchainTest;
import nxt.DeleteFileRule;
import nxt.FileUtils;
import nxt.Tester;
import nxt.addons.SaveAssetSnapshot;
import nxt.ae.Asset;
import nxt.ae.AssetFreezeMonitorTest;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.http.assetexchange.AssetExchangeTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SaveAssetSnapshotTest
extends BlockchainTest {
    @Rule
    public final DeleteFileRule deleteFileRule = new DeleteFileRule();
    private Tester assetOwner;

    @Before
    public void setUp() {
        this.assetOwner = ALICE;
        new SaveAssetSnapshot().init();
    }

    @Override
    @After
    public void destroy() {
        AccessController.doPrivileged(() -> {
            TransactionProcessorImpl.getInstance().clearUnconfirmedTransactions();
            blockchainProcessor.popOffTo(-2);
            return null;
        });
    }

    @Test
    public void writesSnapshot() throws IOException {
        Asset asset = this.createAsset();
        SaveAssetSnapshotTest.generateBlock();
        int n = this.getHeight() + 1;
        this.freezeAsset(asset, n);
        SaveAssetSnapshotTest.generateBlock();
        this.assertSnapshotSaved(asset, n);
    }

    private void assertSnapshotSaved(Asset asset, int n) throws IOException {
        String string = Long.toUnsignedString(asset.getId());
        String string2 = String.format("snapshot-asset_%s-height_%s-testnet.json", string, n);
        File file = new File(string2);
        this.deleteFileRule.addFile(file);
        Assert.assertTrue((boolean)file.exists());
        String string3 = String.format("{\"%s\":%s}", this.assetOwner.getStrId(), 10000000);
        Assert.assertEquals((Object)string3, (Object)FileUtils.readFile(file));
    }

    private Asset createAsset() {
        return Asset.getAsset((long)AssetExchangeTest.issueAsset(this.assetOwner, "AssetC").getAssetId());
    }

    private void freezeAsset(Asset asset, int n) {
        AssetFreezeMonitorTest.setAssetFreezeHeight(asset, n);
    }
}

