/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import nxt.BlockchainTest;
import nxt.DeleteFileRule;
import nxt.FileUtils;
import nxt.Tester;
import nxt.addons.SaveCurrencySnapshot;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import nxt.ms.Currency;
import nxt.ms.CurrencyFreezeMonitorTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SaveCurrencySnapshotTest
extends BlockchainTest {
    @Rule
    public final DeleteFileRule deleteFileRule = new DeleteFileRule();
    private Tester currencyOwner;

    @Before
    public void setUp() {
        this.currencyOwner = TestCurrencyIssuance.Builder.creator;
        new SaveCurrencySnapshot().init();
    }

    @Override
    @After
    public void destroy() {
        AccessController.doPrivileged(() -> {
            TransactionProcessorImpl.getInstance().clearUnconfirmedTransactions();
            blockchainProcessor.popOffTo(-2);
            return null;
        });
    }

    @Test
    public void writesSnapshot() throws IOException {
        Currency currency = CurrencyFreezeMonitorTest.createCurrency();
        SaveCurrencySnapshotTest.generateBlock();
        int n = this.getHeight() + 1;
        CurrencyFreezeMonitorTest.setCurrencyFreezeHeight(currency, n);
        SaveCurrencySnapshotTest.generateBlock();
        this.assertSnapshotSaved(currency, n);
    }

    private void assertSnapshotSaved(Currency currency, int n) throws IOException {
        String string = Long.toUnsignedString(currency.getId());
        String string2 = String.format("snapshot-currency_%s-height_%s-testnet.json", string, n);
        File file = new File(string2);
        this.deleteFileRule.addFile(file);
        Assert.assertTrue((boolean)file.exists());
        String string3 = String.format("{\"%s\":%s}", this.currencyOwner.getStrId(), 100000);
        Assert.assertEquals((Object)string3, (Object)FileUtils.readFile(file));
    }
}

