/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.security.AccessController;
import java.util.HashMap;
import nxt.BlockchainTest;
import nxt.account.HoldingType;
import nxt.addons.JA;
import nxt.addons.JO;
import nxt.addons.StartStandbyShuffling;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StandbyShufflingConfigFileTest
extends BlockchainTest {
    @BeforeClass
    public static void init() {
        AccessController.doPrivileged(() -> {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("nxt.addOns", "nxt.addons.StandbyShuffling; nxt.addons.StartStandbyShuffling");
            hashMap.put("nxt.disableSecurityPolicy", "true");
            StandbyShufflingConfigFileTest.initNxt(hashMap);
            StandbyShufflingConfigFileTest.initBlockchainTest();
            return null;
        });
    }

    @After
    public void stopAll() {
        JO jO = new APICall.Builder("stopStandbyShuffler").call();
        Logger.logDebugMessage((String)"Stopped %d StandbyShufflers.", (Object[])new Object[]{jO.get("stopped")});
        Assert.assertNotNull((Object)jO.get("stopped"));
    }

    @Test
    public void test() {
        String string = "285c4f326fffd59460d1374888ae0219f3f4706586db3510b514353f8a410306";
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", string).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        JO jO2 = new APICall.Builder("getStandbyShufflers").chain(ChildChain.IGNIS.getId()).unsignedLongParam("account", ALICE.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).call();
        Assert.assertNull((Object)jO2.get("errorCode"));
        JA jA = jO2.getArray("standbyShufflers");
        Assert.assertNotNull((Object)jA);
        Assert.assertEquals((long)1L, (long)jA.size());
        JO jO3 = jA.get(0);
        Assert.assertNotNull((Object)jO3);
        jO = new APICall.Builder("stopStandbyShuffler").call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertEquals((long)1L, (long)jO.getInt("stopped"));
        jO3.put("secretPhrase", (Object)ALICE.getSecretPhrase());
        StartStandbyShuffling.startStandbyShufflers((JSONObject)jO2.toJSONObject());
        jO = new APICall.Builder("getStandbyShufflers").chain(ChildChain.IGNIS.getId()).unsignedLongParam("account", ALICE.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        jA = jO.getArray("standbyShufflers");
        Assert.assertNotNull((Object)jA);
        Assert.assertEquals((long)1L, (long)jA.size());
        jO3 = jA.get(0);
        Assert.assertNotNull((Object)jO3);
        Assert.assertEquals((long)ALICE.getId(), (long)jO3.getEntityId("account"));
        Assert.assertEquals((Object)ALICE.getRsAccount(), (Object)jO3.getString("accountRS"));
        Assert.assertEquals((long)ChildChain.IGNIS.getId(), (long)jO3.getInt("chain"));
        Assert.assertEquals((long)HoldingType.COIN.getCode(), (long)jO3.getByte("holdingType"));
        Assert.assertEquals((long)ChildChain.IGNIS.getId(), (long)jO3.getInt("holding"));
        Assert.assertEquals((Object)"0", (Object)jO3.getString("minAmount"));
        Assert.assertEquals((Object)"0", (Object)jO3.getString("maxAmount"));
        Assert.assertEquals((long)3L, (long)jO3.getInt("minParticipants"));
        JA jA2 = jO3.getArray("recipientPublicKeys");
        Assert.assertEquals((long)1L, (long)jA2.size());
        Assert.assertEquals((Object)string, (Object)jA2.getObject(0));
    }
}

