/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

import java.math.BigInteger;
import java.util.Arrays;
import nxt.crypto.SecretSharingGenerator;
import org.junit.Assert;
import org.junit.Test;

public class SecretSharingGeneratorTest {
    private static final BigInteger ALICE_SECRET_PHRASE_128_BIT = new BigInteger("298106192037605529109565170145082624171");
    private static final String aliceSecretPhrase = "hope peace happen touch easy pretend worthless talk them indeed wheel state";
    private static final String chuckSecretPhrase = "eOdBVLMgySFvyiTy8xMuRXDTr45oTzB7L5J";

    @Test
    public void secretPhraseTwelveWordsToBigIntegerAndBack() {
        BigInteger bigInteger = SecretSharingGenerator.to128bit((String[])aliceSecretPhrase.split(" "));
        CharSequence[] charSequenceArray = SecretSharingGenerator.from128bit((BigInteger)bigInteger);
        String string = String.join((CharSequence)" ", charSequenceArray);
        Assert.assertEquals((Object)aliceSecretPhrase, (Object)string);
        BigInteger bigInteger2 = SecretSharingGenerator.to128bit((String[])charSequenceArray);
        Assert.assertEquals((Object)ALICE_SECRET_PHRASE_128_BIT, (Object)bigInteger2);
        charSequenceArray = SecretSharingGenerator.from128bit((BigInteger)bigInteger2);
        string = String.join((CharSequence)" ", charSequenceArray);
        Assert.assertEquals((Object)aliceSecretPhrase, (Object)string);
    }

    @Test
    public void splitAndCombine12wordsSecretPhrase() {
        String[] stringArray = SecretSharingGenerator.split((String)aliceSecretPhrase, (int)5, (int)3, (BigInteger)BigInteger.ZERO);
        String[] stringArray2 = new String[]{stringArray[0], stringArray[2], stringArray[4]};
        String string = SecretSharingGenerator.combine((String[])stringArray2);
        Assert.assertEquals((Object)aliceSecretPhrase, (Object)string);
        stringArray2 = new String[]{stringArray[0], stringArray[2], stringArray[4]};
        string = SecretSharingGenerator.combine((String[])stringArray2);
        Assert.assertEquals((Object)aliceSecretPhrase, (Object)string);
        stringArray = SecretSharingGenerator.split((String)aliceSecretPhrase, (int)3, (int)2, (BigInteger)BigInteger.ZERO);
        stringArray2 = new String[]{stringArray[0], stringArray[2]};
        string = SecretSharingGenerator.combine((String[])stringArray2);
        Assert.assertEquals((Object)aliceSecretPhrase, (Object)string);
    }

    @Test
    public void splitAndCombineRandomSecretPhrase() {
        String[] stringArray = SecretSharingGenerator.split((String)chuckSecretPhrase, (int)7, (int)4, (BigInteger)BigInteger.ZERO);
        String[] stringArray2 = new String[]{stringArray[1], stringArray[3], stringArray[5], stringArray[6]};
        String string = SecretSharingGenerator.combine((String[])stringArray2);
        Assert.assertEquals((Object)chuckSecretPhrase, (Object)string);
        stringArray2 = new String[]{stringArray[1], stringArray[2], stringArray[4], stringArray[6]};
        string = SecretSharingGenerator.combine((String[])stringArray2);
        Assert.assertEquals((Object)chuckSecretPhrase, (Object)string);
    }

    @Test
    public void splitAndCombineRedundantPieces() {
        String[] stringArray = SecretSharingGenerator.split((String)chuckSecretPhrase, (int)7, (int)4, (BigInteger)BigInteger.ZERO);
        String[] stringArray2 = new String[]{stringArray[1], stringArray[2], stringArray[3], stringArray[5], stringArray[6]};
        String string = SecretSharingGenerator.combine((String[])stringArray2);
        Assert.assertEquals((Object)chuckSecretPhrase, (Object)string);
    }

    @Test
    public void shortPassphrase() {
        Object[] objectArray = SecretSharingGenerator.split((String)"aaa", (int)7, (int)4, (BigInteger)BigInteger.ZERO);
        System.out.println(Arrays.toString(objectArray));
        String[] stringArray = new String[]{objectArray[1], objectArray[2], objectArray[4], objectArray[6]};
        String string = SecretSharingGenerator.combine((String[])stringArray);
        Assert.assertEquals((Object)"aaa", (Object)string);
    }

    @Test
    public void validityChecks() {
        try {
            SecretSharingGenerator.split((String)aliceSecretPhrase, (int)4, (int)1, (BigInteger)BigInteger.ZERO);
            Assert.fail();
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
        }
        try {
            SecretSharingGenerator.split((String)aliceSecretPhrase, (int)4, (int)5, (BigInteger)BigInteger.ZERO);
            Assert.fail();
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
        }
    }
}

